package order.service.apiimpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import order.api.MallParentOrderApi;
import order.dto.MallParentOrderDto;
import order.dto.MallParentSubOrderNosDto;
import order.dto.SimpleParentOrderDto;
import order.service.service.MallParentOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 */
@MotanService
public class MallParentOrderApiImpl implements MallParentOrderApi {

    @Autowired
    private MallParentOrderService mallParentOrderService;

    @Override
    public MallParentOrderDto saveMallParentOrder(MallParentOrderDto mallParentOrderDto) {
        return mallParentOrderService.saveMallParentOrder(mallParentOrderDto);
    }

    @Override
    public MallParentSubOrderNosDto getMallSubOrderNos(String parentOrderNo) {
        return mallParentOrderService.getMallSubOrderNos(parentOrderNo);
    }

    @Override
    public BaseResponse<SimpleParentOrderDto> getSimpleParentOrderDto(String parentOrderNo) {
        return mallParentOrderService.getSimpleParentOrderDto(parentOrderNo);
    }
    @Override
    public int changeStatus(String status, String parentOrderId) {
        return mallParentOrderService.changeStatus(status,parentOrderId);
    }
}
