package order.service.apiimpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import order.api.MallTempOrderInfoApi;
import order.dto.MallTempOrderInfoDto;
import order.model.po.MallTempOrderInfo;
import order.model.repository.MallTempOrderInfoRepo;
import order.service.service.MallTempOrderInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.data.BeanMapper;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 */
@MotanService
public class MallTempOrderInfoApiImpl implements MallTempOrderInfoApi {
    @Autowired
    private MallTempOrderInfoService mallTempOrderInfoService;

    @Override
    public BaseResponse saveMallTempOrderInfo(MallTempOrderInfoDto mallTempOrderInfoDto) {
        MallTempOrderInfo mallTempOrderInfo = BeanMapper.map(mallTempOrderInfoDto, MallTempOrderInfo.class);
        mallTempOrderInfoService.saveTempOrderInfo(mallTempOrderInfo);
        return new BaseResponse(true,"保存成功");
    }

    @Override
    public void deleteTempOrderInfo(MallTempOrderInfoDto mallTempOrderInfo) {
        mallTempOrderInfoService.deleteTempInfo(mallTempOrderInfo.getId());
    }
}
