package order.service.events;

/**
 * 创建订单事件
 * @author Liang Wenxu
 * @since 2018-01-11
 */
public class OrderCreateEvent extends OrderEvent {

    /**
     * Constructs a prototypical Event.
     *
     * @param source   The object on which the Event initially occurred.
     * @param orgCode
     * @param operator @throws IllegalArgumentException if source is null.
     */
    public OrderCreateEvent(Object source, String orgCode, String operator) {
        super(source, orgCode, operator);
    }


    @Override
    public String toString() {
        return "OrderCreateEvent{" +
                "source=" + source +
                ",orgCode=" + super.getOrgCode() +
                ",operator=" + super.getOperator() +
                '}';
    }
}
