package order.service.events;

import org.springframework.context.ApplicationEvent;

import java.util.Date;
import java.util.EventObject;

/**
 * 订单相关事件
 * @author Liang Wenxu
 * @since 2018-01-11
 */
public abstract class OrderEvent extends ApplicationEvent {

    // 操作人的userId
    private String operator = null;
    // 订单的渠道代码
    private String orgCode;

    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @throws IllegalArgumentException if source is null.
     */
    public OrderEvent(Object source, String orgCode, String operator) {
        super(source);
        this.orgCode = orgCode;
        this.operator = operator;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
}
