package order.service.events.listener;

import order.model.po.OrderMain;
import fiance.messages.bills.BillsInvoiceCreateRequest;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import order.service.events.OrderEvent;
import order.service.events.OrderShippingComfirmedEvent;
import order.service.jms.JmsHelper;
import order.service.service.OrderMainService;
import order.service.stubs.SystemConfigApiStub;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.stereotype.Component;
import sysmg.dto.SystemConfigDto;
import utils.GlobalContants;
import utils.Lang;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * @author Liang Wenxu
 * @since 2018-04-11
 */
@Component
@Slf4j
public class OrderShippingComfirmedEventListener implements SmartApplicationListener {
    private Integer canInsureSpanDays; // 可开票时间间隔

    @Value("${finance.bills.message.queue.createinvoice:}")
    private String createinvoiceQueue;

    @Override
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType == OrderShippingComfirmedEvent.class;
    }

    @Override
    public boolean supportsSourceType(Class<?> sourceType) {
        return sourceType == OrderMain.class;
    }


    @Override
    public void onApplicationEvent(ApplicationEvent event) {

        OrderEvent orderEvent = (OrderShippingComfirmedEvent) event;
        OrderMain orderMain = (OrderMain) orderEvent.getSource();
        log.info("集采直购订单确认收货通过事件触发, orderNo: {}, orgCode: {}", orderMain.getOrderNo() , orderEvent.getOrgCode());
        if(!Lang.isEmpty(orderMain.getBillsRequestId())
                && GlobalContants.ORGANIZATION_CODES.JICAI.equals(orderEvent.getOrgCode())) {
            BillsInvoiceCreateRequest billsInvoiceCreateRequest = new BillsInvoiceCreateRequest();
            billsInvoiceCreateRequest.setRequestId(orderMain.getBillsRequestId());
            Date shippingComfirmedTime = new Date();
            /** 订单配送后，计算可进行发票打印的时间节点 */
            Calendar shippingComfirmTime = Calendar.getInstance();
            shippingComfirmTime.setTime(shippingComfirmedTime);
            Calendar caledCalendar = new GregorianCalendar(
                    shippingComfirmTime.get(Calendar.YEAR),
                    shippingComfirmTime.get(Calendar.MONTH),
                    shippingComfirmTime.get(Calendar.DAY_OF_MONTH),
                    shippingComfirmTime.get(Calendar.HOUR_OF_DAY),
                    shippingComfirmTime.get(Calendar.MINUTE), 0);
            /** 订单确认收货的7天后 */
            Integer spanDays = getCanInsureSpanDays();
            caledCalendar.add(Calendar.DAY_OF_MONTH, spanDays == null ? 7 : spanDays);
            billsInvoiceCreateRequest.setCanInvoiceTime(caledCalendar.getTime());
            jmsHelper.sendQueuedObjMessage(billsInvoiceCreateRequest, createinvoiceQueue);
            log.info("集采直购订单确认收货通过事件, orderNo: {}, orgCode: {}, 已发送发票申请MQ消息", orderMain.getOrderNo() , orderEvent.getOrgCode());
        }
        orderMainService.saveOrder(orderMain, true);
    }

    public Integer getCanInsureSpanDays() {
//        if(canInsureSpanDays == null ) {
        String configValue = systemConfigApi.getConfigValue(SystemConfigDto.ORG_CODE_COMMON, "InvoiceConfigs", "CanInsureSpanDays", true, true);
        try {
            canInsureSpanDays = Integer.parseInt(configValue);
        } catch (Exception e) {
            e.printStackTrace();
        }
//        }
        return canInsureSpanDays;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Autowired
    SystemConfigApiStub systemConfigApi;

    @Autowired
    JmsHelper jmsHelper;
    @Autowired
    MapperFacade mapperFacade;

    @Autowired
    OrderMainService orderMainService;
}
