package order.service.factory;

import lombok.extern.slf4j.Slf4j;
import order.model.po.OrderTemplateAdapterConfig;
import order.service.factory.helper.OrderTemplateSpringBeanHelper;
import order.service.order.templates.OrderTemplate;
import order.service.service.OrderTemplateAdapterConfigService;
import order.vo.OrderTemplateConfigKey;
import order.vo.query.OrderTemplateAdapterConfigQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import utils.Lang;

import java.util.List;

/**
 * 从数据库获取订单操作模型的工厂
 * @author Liang Wenxu
 * @since 2018/7/9
 */
@Component("dbOrderTemplateFactory")
@Slf4j
public class DbOrderTemplateFactory implements OrderTemplateFactory {
    @Autowired
    private OrderTemplateAdapterConfigService adapterConfigsService;

    @Autowired
    private OrderTemplateSpringBeanHelper orderTemplateSpringBeanHelper;

    @Override
    public OrderTemplate getOrderTemplate(OrderTemplateConfigKey orderTemplateKey) {
        if(Lang.isEmpty(orderTemplateKey.getGoodsType())
                && Lang.isEmpty(orderTemplateKey.getOrgCode())
                && Lang.isEmpty(orderTemplateKey.getOrderMode())) {
            throw new RuntimeException("orderTemplateKey.goodsType,orderTemplateKey.orgCode,orderTemplateKey.orderMode CANT BE ALL NULL!");
        }
        // 先来找出店铺可用的适配器
        OrderTemplateAdapterConfigQuery query = new OrderTemplateAdapterConfigQuery();
        query.setOrgCode(orderTemplateKey.getOrgCode());
        query.setGoodsType(orderTemplateKey.getGoodsType());
        query.setOrderMode(orderTemplateKey.getOrderMode());
        query.setTemplateName(orderTemplateKey.getTemplateName());
        query.setEnabled(true);
        query.setIsDelete(false);
        List<OrderTemplateAdapterConfig> adapterConfigs = adapterConfigsService.query(query);
        if(adapterConfigs != null && adapterConfigs.size() > 0) {
            OrderTemplateAdapterConfig adapterConfig = adapterConfigs.get(0);
            try {
                OrderTemplate orderTemplate = orderTemplateSpringBeanHelper.getOrRegisterBean(adapterConfig.getTemplateName(),
                        adapterConfig.getTemplateClass(),
                        OrderTemplate.class);
                return orderTemplate;
            } catch (ClassCastException cce) {
                throw new RuntimeException("OrderTemplate:"+adapterConfig.getTemplateName()+" is NOT FOUND");
            }
        } else {
            throw new RuntimeException("OrderTemplateAdapterConfig:"+orderTemplateKey.toString()+" is NOT FOUND");
        }
    }
}
