package order.service.jms;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Component;
import utils.log.Log;
import utils.log.Logs;

import java.io.Serializable;

/**
 * JMS消息处理工具类
 * @author Liang Wenxu
 * @since 2018-01-31
 */
@Component
public class JmsHelper {
    Log log = Logs.getLog(JmsHelper.class.getName());

    @Autowired
    JmsTemplate jmsTemplate;
    /**
     * 发送一个队列消息
     * @param obj
     * @param queueName
     */
    public void sendQueuedMessage(Object obj, String queueName) {
        log.info("Sending message: {}, to queue[{}]", obj, queueName);
//        jmsTemplate.send(queueName, session -> session.createObjectMessage(obj));
        jmsTemplate.convertAndSend(queueName, obj);
    }

    /**
     * 发送一个队列消息（使用ObjectMessage）
     * @param obj
     * @param queueName
     */
    public void sendQueuedObjMessage(Serializable obj, String queueName) {
        jmsTemplate.send(queueName, session -> session.createObjectMessage(obj));
    }

}
