package order.service.order.templates;

import order.vo.*;
import sinomall.global.common.response.BaseResponse;

import java.math.BigDecimal;
import java.util.List;

/**
 * 批量订单处理模型接口，定义订单相关操作
 * @author Liang Wenxu
 * @since 2018/7/9
 */
public interface BatchOrderTemplate {
    /**
     * 创建临时订单
     * @param batchRequest
     * @return
     */
    List<TempOrderVo> createTempOrder(final List<TempOrderCreateRequest> batchRequest);

    /**
     * 库存校验
     * @param tempOrderVos
     * @return
     */
    BaseResponse<Boolean> validateStock(List<TempOrderVo> tempOrderVos);

    /**
     * 获取运费
     * @param tempOrderVos
     * @return
     */
    BaseResponse<BigDecimal> getFreight(List<TempOrderVo> tempOrderVos);

    /**
     * 订单预校验
     * @param tempOrderVos
     * @return
     */
    BaseResponse<Boolean> orderPreCheck(List<TempOrderVo> tempOrderVos);

    /**
     * 创建订单并预占库存（如有必要）
     * @param tempOrderVos
     * @return
     */
    List<OrderVo> createOrder(List<TempOrderVo> tempOrderVos);

    /**
     * 确认订单
     * @param orderVos
     * @return
     */
    BaseResponse subscribeOrder(List<OrderVo> orderVos);

    /**
     * 营销活动
     * @param tempOrderVos
     * @return
     */
    BaseResponse<Boolean> marketingDone(List<TempOrderVo> tempOrderVos);

    /**
     * 订单支付前回调
     * @param orderVos
     * @return
     */
    BaseResponse<Boolean> orderPayPreSubmitDone(List<OrderVo> orderVos);

    /**
     * 订单支付回调
     * @param orderVos
     * @return
     */
    BaseResponse<OrderPayConfirmResp> paySubmit(List<OrderVo> orderVos);


    /**
     * 取消订单
     * @param orderVoList
     * @return
     */
    BaseResponse<CancelOrderResp> cancelOrder(List<OrderVo> orderVoList);
}
