package order.service.order.templates;

import lombok.extern.slf4j.Slf4j;
import order.Contants;
import order.exceptions.IllegalAreaCodeException;
import order.service.operator.OrderFreightOperator;
import order.service.stubs.SupplierOrderApiStub;
import order.vo.OrderKey;
import order.vo.OrderVo;
import order.vo.TempOrderVo;
import order.vo.TempSubOrderVo;
import order.vo.response.OrderFreight;
import order.vo.response.OrderStock;
import org.springframework.beans.factory.annotation.Autowired;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.orderrequest.OrderRequst;
import sinomall.global.common.response.BaseResponse;
import utils.data.BeanMapper;

import java.util.stream.Collectors;

/**
 * @author Liang Wenxu
 * @since 2018/7/10
 */
@Slf4j
public abstract class MallEntityGoodsOrderTemplate extends MallDefaultOrderTemplate {

    @Autowired
    OrderFreightOperator orderFreightOperator;

    @Autowired
    SupplierOrderApiStub supplierOrderApi;

    /**
     * 实体商品的库存校验，当查询不到库存或库存不足时不允许下单
     * @param tempOrderVo
     * @param areaCode
     * @param organizationId
     * @return
     * @throws IllegalAreaCodeException
     */
    @Override
    public BaseResponse<OrderStock> validateStock(TempSubOrderVo tempOrderVo, String areaCode, String organizationId) throws IllegalAreaCodeException {
        OrderStock orderStock = null;
        orderStock = orderStockOperator.get(tempOrderVo, areaCode, organizationId);

        if(orderStock != null) {
            return new BaseResponse<>(true, "SUC", orderStock);
        } else {
            orderStock = new OrderStock();
            orderStock.setHasNoStock(true);
        }
        return new BaseResponse<>(true, "SUC", orderStock);
    }

    @Override
    public BaseResponse<OrderFreight> getFreight(TempOrderVo tempOrderVo) {
        OrderFreight orderFreight = orderFreightOperator.get(tempOrderVo);
        return new BaseResponse<>(true, "SUC", orderFreight);
    }

    /**
     * 实物商品的预占库存
     * @param orderVo
     * @return
     */
    @Override
    public BaseResponse<Boolean> subscribeOrder(OrderVo orderVo) {
        BaseResponse<Boolean> response = new BaseResponse<>();
        response.setSuccess(true);
        response.setResult(true);
        try {
            // 预占库存成功后，更新订单信息
            OrderRequst orderRequst = new OrderRequst();
            orderRequst = BeanMapper.map(orderVo, BeanMapper.getType(OrderVo.class), BeanMapper.getType(OrderRequst.class));
            TrdOrder trdOrder = supplierOrderApi.takeOrder(orderRequst);
            orderMainService.updateTrdOrderInfo(new OrderKey(orderVo.getOrderId(), orderVo.getOrderNo()), trdOrder);
            log.info("订单【{}】预占库存成功！", orderVo.getOrderNo());
        } catch (SupplierInterfaceInvokeException e) {
            e.printStackTrace();
            response.setResultCode(e.getErrorCode().getValue());
            response.setResultMessage(e.getErrorCode().getMessage());
            response.setSuccess(false);
            cancelOrder(orderVo.getSubOrders().stream().map(o -> new OrderKey(o.getOrderId())).collect(Collectors.toList()), Contants.CancelOrderType.ERROR);
        } catch (SupplierTakeOrderFalidException e) {
            response.setResultCode(e.getErrorCode().getValue());
            response.setResultMessage(e.getMessage());
            response.setSuccess(false);
            cancelOrder(orderVo.getSubOrders().stream().map(o -> new OrderKey(o.getOrderId())).collect(Collectors.toList()), Contants.CancelOrderType.ERROR);
        }
        return response;
    }
}
