package order.service.order.templates;

import order.Contants;
import order.service.operator.OrderFreightOperator;
import order.vo.*;
import order.vo.response.OrderFreight;
import order.vo.response.OrderStock;
import org.springframework.beans.factory.annotation.Autowired;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierOrderComfirmFalidException;
import sinomall.global.common.response.BaseResponse;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商城虚拟商品订单处理模板
 * @author Liang Wenxu
 * @since 2018/7/10
 */
public class MallVirtualGoodsOrderTemplate extends MallDefaultOrderTemplate {
    @Autowired
    OrderFreightOperator orderFreightOperator;

    @Override
    public BaseResponse<OrderStock> validateStock(TempSubOrderVo tempOrderVo, String areaCode, String organizationId) {
        // 虚拟商品库存永远有货
        OrderStock orderStock = new OrderStock();
        orderStock.setHasNoStock(false);
        return new BaseResponse<>(true, "SUC", orderStock);
    }

    @Override
    public BaseResponse<OrderFreight> getFreight(TempOrderVo tempOrderVo) {
        // 虚拟商品不计入运费
        OrderFreight orderFreight = new OrderFreight();
        orderFreight.setBaseFreight(new BigDecimal(0));
        orderFreight.setOrderNo(tempOrderVo.getTmpOrderNo());

        return new BaseResponse<>(true, "SUC", orderFreight);
    }

    @Override
    public BaseResponse<Boolean> subscribeOrder(OrderVo orderVo) {
        return null;
    }

    @Override
    public BaseResponse<Boolean> marketingDone(TempOrderVo tempOrderVo) {
        return null;
    }

    @Override
    public BaseResponse<Boolean> orderPayPreSubmitDone(OrderVo orderVo) {
        return null;
    }

    @Override
    public OrderPayConfirmResp paySubmit(OrderVo orderVo) throws SupplierInterfaceInvokeException, SupplierOrderComfirmFalidException {
        return null;
    }

    @Override
    public BaseResponse<CancelOrderResp> cancelOrder(List<OrderKey> orderKeys, Contants.CancelOrderType cancelType) {
        return null;
    }
}
