package order.service.service;

import cart.api.dto.payment.PaymentConfigDto;
import com.alibaba.fastjson.JSON;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.shop.MemberDto;
import order.service.stubs.CoreCompDepartUserApiStub;
import order.service.stubs.CoreCompanyApiStub;
import order.service.stubs.MemberApiStub;
import order.service.stubs.SystemConfigApiStub;
import order.vo.TempOrderVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import sysmg.dto.SystemConfigDto;
import utils.GlobalContants;
import utils.Lang;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 集采的订单校验服务
 * @author Liang Wenxu
 * @since 2018/8/10
 */
@Service
@Transactional(readOnly = true, rollbackFor = Exception.class)
public class JicaiOrderChecker {
    /**
     * 订单下单金额管控
     *
     * @param tempOrderVo   临时订单Vo
     * @return 错误代码：0-- 可下单，1-- 在线支付金额控制
     * <p>错误代码使用GlobalContants中以ORDER_PRICE_LIMIT_开头的常量，如增加管控后，需将错误代码加入GlobalContants中</p>
     */
    @Transactional(propagation = Propagation.NOT_SUPPORTED)
    public String checkOrderPriceLimit(TempOrderVo tempOrderVo) {
        String onlinePayLimitStr = systemConfigApi.getConfigValue("jicai", SystemConfigDto.CONFIG_CODE_ORDER_CONFIGS,
                "ONLINE_PAY_LIMITS", true, true, false);
        String errorCode = "0";
        List<Map> onlinePayLimitConfigs = JSON.parseArray(onlinePayLimitStr, Map.class);
        MemberDto member = memberApi.findMemberById(tempOrderVo.getMemberId());
        CoreCompanyDto coreCompanyDto = coreCompDepartUserApi.getBuyerCompany(member.getCoreUser().getId());
        String lv2CompId = null;
        if (!Lang.isEmpty(coreCompanyDto)) {
            /** 查询2级机构 */
            CoreCompanyDto compLv2 = coreCompanyApi.getParentCompany(coreCompanyDto.getId(), 2);
            if (compLv2 != null) {
                lv2CompId = compLv2.getId();
            }
        }
        // 太寿超过1000元，在线支付限制
        if (!Lang.isEmpty(lv2CompId)) {
            CoreCompanyDto company = coreCompanyApi.findById(lv2CompId);
            if (company != null) {
                Map config = Lang.findInBeanList(onlinePayLimitConfigs, "comCode", company.getCode());
                if (config != null) {
                    if (tempOrderVo.getSumPrice().compareTo((BigDecimal) config.get("limit")) > 0 &&
                            tempOrderVo.getPayMethodCode().equals(PaymentConfigDto.PAYMENT_CONFIG_CODE_ONLINE)) {
                        // 大于1000的在线支付，不允许提交
                        errorCode = GlobalContants.ORDER_PRICE_LIMIT_ONLINE_PAY;
                    }
                }

            }
        }

        return errorCode;
    }

    public void checkQuota() {
       //TODO: 限额校验需要整改
    }



    @Autowired
    CoreCompanyApiStub coreCompanyApi;

    @Autowired
    SystemConfigApiStub systemConfigApi;

    @Autowired
    CoreCompDepartUserApiStub coreCompDepartUserApi;

    @Autowired
    MemberApiStub memberApi;
}
