package order.service.service.impl;

import lombok.extern.slf4j.Slf4j;
import order.Contants;
import order.exceptions.IllegalAreaCodeException;
import order.exceptions.temporder.TempOrderCreateException;
import order.model.repository.OrderRepos;
import order.service.service.OrderService;
import order.service.utils.OrderTemplateFactoryUtil;
import order.vo.*;
import order.vo.response.OrderAuditingResult;
import order.vo.response.OrderPrice;
import order.vo.response.OrderStock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 批量下单、OrderService实现
 *
 * @author Liang Wenxu
 * @since 2018/7/12
 */
@Component("batchOrderService")
@Slf4j
public class BatchOrderServiceImpl implements OrderService {

    @Autowired
    OrderTemplateFactoryUtil orderTemplateFactoryUtil;

    @Autowired
    OrderRepos orderRepos;

    @Override
    public TempOrderVo newTempOrder(final TempOrderCreateRequest tempOrderCreateRequest) throws TempOrderCreateException {
        log.info("batchOrderService.newTempOrder");
        // 提取所有实物商品
        List<GoodsInfoVo> entityGoods = tempOrderCreateRequest.getGoodsInfoVos().stream()
                .filter(it -> Contants.GOODS_TYPE_ENTITY.equals(it.goodsType))
                .collect(Collectors.toList());
        // 提取虚拟商品
        List<GoodsInfoVo> virturlGoods = tempOrderCreateRequest.getGoodsInfoVos().stream()
                .filter(it -> Contants.GOODS_TYPE_VIRTUAL.equals(it.goodsType))
                .collect(Collectors.toList());
        TempOrderVo entityGoodsTempOrder = null;
        TempOrderVo virtualGoodsTempOrder = null;

        TempOrderVo createdTempOrder = null;
        OrderTemplateConfigKey orderTemplateConfigKey = new OrderTemplateConfigKey();
        orderTemplateConfigKey.setOrgCode(tempOrderCreateRequest.getOrganizationCode());

        if(entityGoodsTempOrder != null && virtualGoodsTempOrder != null) {
            // 将生成的虚拟商品和实体商品的临时订单合并返回

        } else {
            createdTempOrder = entityGoodsTempOrder == null ? virtualGoodsTempOrder : entityGoodsTempOrder;
        }


        return createdTempOrder;
    }

    /**
     * 临时订单库存校验
     *
     * @param tempOrderVo 临时订单对象
     */
    @Override
    public OrderStock tempOrderStock(TempOrderVo tempOrderVo) throws IllegalAreaCodeException {
        return null;
    }

    /**
     * 临时定案价格重算
     *
     * @param tempOrderVo
     * @return
     */
    @Override
    public OrderPrice tempOrderPrice(TempOrderVo tempOrderVo) {
        return null;
    }

    @Override
    public OrderVo submit(TempOrderVo tempOrder) {
        return null;
    }

    /**
     * 刷新订单状态
     *
     * @param orderKeys
     * @return
     */
    @Override
    public List<OrderVo> refresh(List<OrderKey> orderKeys) {
        return null;
    }

    /**
     * 订单审核（单个）
     * <p>订单审核通过后，即可进入支付环节</p>
     *
     * @param orderKey            需操作的订单索引
     * @param passed              true|false（审核通过|审核不通过）
     * @param cancelSupplierOrder 审核不通过时是否取消供应商订单 true|false（取消|不取消）
     * @return 订单的处理结果
     */
    @Override
    public OrderAuditingResult audit(OrderKey orderKey, Boolean passed, Boolean cancelSupplierOrder) {
        return null;
    }

    /**
     * 订单审核（支持批量）
     *
     * @param orderKeys           需操作的订单索引
     * @param passed              true|false（审核通过|审核不通过）
     * @param cancelSupplierOrder 审核不通过时是否取消供应商订单 true|false（取消|不取消）
     * @return 返回各订单的处理结果
     */
    @Override
    public List<OrderAuditingResult> audit(List<OrderKey> orderKeys, Boolean passed, Boolean cancelSupplierOrder) {
        return null;
    }

    /**
     * 订单支付预处理完毕
     * （客户已开始支付，但未支付成功时调用）
     *
     * @param orderKey   订单key，orderNo或orderId，优先id
     * @param cusPayInfo 客户支付信息，如需在客户支付环节带入新的信息从此参数带入
     */
    @Override
    public void prePayDone(OrderKey orderKey, CusPayInfo cusPayInfo) {

    }

    @Override
    public OrderPayConfirmResp payComfirmed(OrderKey orderKey) {
        return null;
    }

    @Override
    public CancelOrderResp cancel(List<OrderKey> orderVos, Contants.CancelOrderType cancelType) {
        return null;
    }

    @Override
    public void receipt(OrderKey orderKey, String receiptType) {

    }

    @Override
    public void statusChange(OrderStatus orderStatus) {

    }
}
