package order.service.service.impl;

import cart.api.OrderMainApi;
import cart.api.dto.order.CartSimpleMallOrderDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import order.dto.MallParentOrderDto;
import order.dto.MallParentSubOrderNosDto;
import order.dto.SimpleMallOrderDto;
import order.dto.SimpleParentOrderDto;
import order.model.po.MallParentOrder;
import order.model.repository.MallParentOrderRepo;
import order.model.specification.MallParentOrderSpecification;
import order.service.service.MallParentOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.collection.CollectionUtil;
import utils.data.BeanMapper;

import java.util.ArrayList;
import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 */
@Service
public class MallParentOrderServiceImpl implements MallParentOrderService {
    @Autowired
    private MallParentOrderRepo mallParentOrderRepo;
    @MotanReferer
    OrderMainApi orderMainApi;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public MallParentOrderDto saveMallParentOrder(MallParentOrderDto mallParentOrderDto) {
        MallParentOrder mallParentOrder = BeanMapper.map(mallParentOrderDto, MallParentOrder.class);
        MallParentOrder parentOrder = mallParentOrderRepo.save(mallParentOrder);
        MallParentOrderDto parentOrderDto = BeanMapper.map(parentOrder, MallParentOrderDto.class);
        return parentOrderDto;
    }

    @Override
    public MallParentSubOrderNosDto getMallSubOrderNos(String parentOrderNo) {
        MallParentOrder mallParentOrderExam = new MallParentOrder();
        mallParentOrderExam.setParentOrderNo(parentOrderNo);
        mallParentOrderExam.setIsDelete(false);
        MallParentOrderSpecification mallParentOrderSpecification = new MallParentOrderSpecification(mallParentOrderExam);
        List<MallParentOrder> mallParentOrders = mallParentOrderRepo.findAll(mallParentOrderSpecification);
        MallParentSubOrderNosDto mallParentSubOrderNosDto = new MallParentSubOrderNosDto();
        mallParentSubOrderNosDto.setIsMallParentOrder(false);
        List<SimpleMallOrderDto> simpleMallOrderDtos = new ArrayList<>();
        if (CollectionUtil.isNoneEmpty(mallParentOrders)) {
            MallParentOrder mallParentOrder = mallParentOrders.get(0);
            List<CartSimpleMallOrderDto> cartSimpleMallOrderDtos = orderMainApi.getMallSubOrderNos(mallParentOrder.getId());
            if (CollectionUtil.isNoneEmpty(cartSimpleMallOrderDtos)) {
                cartSimpleMallOrderDtos.forEach(cartSimpleMallOrderDto -> {
                    SimpleMallOrderDto simpleMallOrderDto = new SimpleMallOrderDto();
                    simpleMallOrderDto.setOrderId(cartSimpleMallOrderDto.getOrderId());
                    simpleMallOrderDto.setOrderNo(cartSimpleMallOrderDto.getOrderNo());
                    simpleMallOrderDtos.add(simpleMallOrderDto);
                });
            }
            mallParentSubOrderNosDto.setIsMallParentOrder(true);
            mallParentSubOrderNosDto.setParentOrderNo(mallParentOrder.getParentOrderNo());
            mallParentSubOrderNosDto.setSimpleMallOrderDtos(simpleMallOrderDtos);
        }
        return mallParentSubOrderNosDto;
    }

    @Override
    public BaseResponse<SimpleParentOrderDto> getSimpleParentOrderDto(String parentOrderNo) {
        MallParentOrder mallParentOrderExam = new MallParentOrder();
        mallParentOrderExam.setParentOrderNo(parentOrderNo);
        mallParentOrderExam.setIsDelete(false);
        MallParentOrderSpecification mallParentOrderSpecification = new MallParentOrderSpecification(mallParentOrderExam);
        List<MallParentOrder> mallParentOrders = mallParentOrderRepo.findAll(mallParentOrderSpecification);
        if (CollectionUtil.isEmpty(mallParentOrders)) {
            return new BaseResponse<>(false, "无此订单号");
        }
        SimpleParentOrderDto simpleParentOrderDto = new SimpleParentOrderDto();
        MallParentOrder mallParentOrder = mallParentOrders.get(0);
        simpleParentOrderDto.setId(mallParentOrder.getId());
        simpleParentOrderDto.setParentOrderNo(mallParentOrder.getParentOrderNo());
        simpleParentOrderDto.setMemberId(mallParentOrder.getMemberId());
        simpleParentOrderDto.setTotalMoney(mallParentOrder.getTotalMoney());
        simpleParentOrderDto.setFreight(mallParentOrder.getFreight());
        return new BaseResponse<>(true, "查询成功", simpleParentOrderDto);
    }

    @Override
    public int changeStatus(String status, String parentOrderId) {
       return mallParentOrderRepo.changeOrderStatus(status,parentOrderId);
    }
}
