package order.service.service.impl;

import order.dto.MallTempOrderInfoDto;
import order.model.po.MallTempOrderInfo;
import order.model.repository.MallTempOrderInfoRepo;
import order.service.service.MallTempOrderInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;
import utils.data.BeanMapper;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 */
@Service
public class MallTempOrderInfoServiceImpl implements MallTempOrderInfoService {
    @Autowired
    private MallTempOrderInfoRepo mallTempOrderInfoRepo;

    @Override
    public MallTempOrderInfoDto findMallOrderInfoByMemberId(String memberId) {
        MallTempOrderInfo mallTempOrderInfo = mallTempOrderInfoRepo.findByMemberId(memberId);
        if(!Lang.isEmpty(mallTempOrderInfo)){
            MallTempOrderInfoDto mallTempOrderInfoDto = BeanMapper.map(mallTempOrderInfo, MallTempOrderInfoDto.class);
            return mallTempOrderInfoDto;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveTempOrderInfo(MallTempOrderInfo mallTempOrderInfo) {
        mallTempOrderInfoRepo.save(mallTempOrderInfo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteTempInfo(String id) {
        mallTempOrderInfoRepo.delete(id);
    }
}
