package order.service.service.impl.query;

import cart.api.OrderMainApi;
import cart.api.dto.order.CartSimpleMallOrderDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import order.dto.MallParentOrderDto;
import order.dto.MallParentSubOrderNosDto;
import order.dto.SimpleMallOrderDto;
import order.dto.SimpleParentOrderDto;
import order.model.po.MallParentOrder;
import order.model.repository.MallParentOrderRepo;
import order.model.specification.MallParentOrderSpecification;
import order.service.service.query.MallParentOrderQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sinomall.global.common.response.BaseResponse;
import utils.collection.CollectionUtil;
import utils.data.BeanMapper;

import java.util.ArrayList;
import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 */
@Service
public class MallParentOrderQueryServiceImpl implements MallParentOrderQueryService {
    @Autowired
    private MallParentOrderRepo mallParentOrderRepo;
    @MotanReferer
    OrderMainApi orderMainApi;

    @Override
    public BaseResponse<List<MallParentOrderDto>> findAllMallParentOrder() {
        return null;
    }

    @Override
    public MallParentSubOrderNosDto getMallSubOrderNos(String parentOrderNo) {
        MallParentOrder mallParentOrderExam = new MallParentOrder();
        mallParentOrderExam.setParentOrderNo(parentOrderNo);
        mallParentOrderExam.setIsDelete(false);
        MallParentOrderSpecification mallParentOrderSpecification = new MallParentOrderSpecification(mallParentOrderExam);
        List<MallParentOrder> mallParentOrders = mallParentOrderRepo.findAll(mallParentOrderSpecification);
        MallParentSubOrderNosDto mallParentSubOrderNosDto = new MallParentSubOrderNosDto();
        mallParentSubOrderNosDto.setIsMallParentOrder(false);
        List<SimpleMallOrderDto> simpleMallOrderDtos = new ArrayList<>();
        if (CollectionUtil.isNoneEmpty(mallParentOrders)) {
            MallParentOrder mallParentOrder = mallParentOrders.get(0);
            List<CartSimpleMallOrderDto> cartSimpleMallOrderDtos = orderMainApi.getMallSubOrderNos(mallParentOrder.getId());
            if (CollectionUtil.isNoneEmpty(cartSimpleMallOrderDtos)) {
                cartSimpleMallOrderDtos.forEach(cartSimpleMallOrderDto -> {
                    SimpleMallOrderDto simpleMallOrderDto = new SimpleMallOrderDto();
                    simpleMallOrderDto.setOrderId(cartSimpleMallOrderDto.getOrderId());
                    simpleMallOrderDto.setOrderNo(cartSimpleMallOrderDto.getOrderNo());
                    simpleMallOrderDtos.add(simpleMallOrderDto);
                });
            }
            mallParentSubOrderNosDto.setIsMallParentOrder(true);
            mallParentSubOrderNosDto.setParentOrderNo(mallParentOrder.getParentOrderNo());
            mallParentSubOrderNosDto.setSimpleMallOrderDtos(simpleMallOrderDtos);
        }
        return mallParentSubOrderNosDto;
    }

    @Override
    public BaseResponse<SimpleParentOrderDto> getSimpleParentOrderDto(String parentOrderNo) {
        MallParentOrder mallParentOrderExam = new MallParentOrder();
        mallParentOrderExam.setParentOrderNo(parentOrderNo);
        mallParentOrderExam.setIsDelete(false);
        MallParentOrderSpecification mallParentOrderSpecification = new MallParentOrderSpecification(mallParentOrderExam);
        List<MallParentOrder> mallParentOrders = mallParentOrderRepo.findAll(mallParentOrderSpecification);
        if (CollectionUtil.isEmpty(mallParentOrders)) {
            return new BaseResponse<>(false, "无此订单号");
        }
        SimpleParentOrderDto simpleParentOrderDto = new SimpleParentOrderDto();
        MallParentOrder mallParentOrder = mallParentOrders.get(0);
        simpleParentOrderDto.setId(mallParentOrder.getId());
        simpleParentOrderDto.setParentOrderNo(mallParentOrder.getParentOrderNo());
        simpleParentOrderDto.setTotalMoney(mallParentOrder.getTotalMoney());
        simpleParentOrderDto.setMemberId(mallParentOrder.getMemberId());
        simpleParentOrderDto.setFreight(mallParentOrder.getFreight());
        return new BaseResponse<>(true, "查询成功", simpleParentOrderDto);
    }

    @Override
    public MallParentOrderDto findByOrderNo(String parentOrderNo) {
        MallParentOrder mallParentOrderExam = new MallParentOrder();
        mallParentOrderExam.setParentOrderNo(parentOrderNo);
        mallParentOrderExam.setIsDelete(false);
        MallParentOrderSpecification mallParentOrderSpecification = new MallParentOrderSpecification(mallParentOrderExam);
        List<MallParentOrder> mallParentOrders = mallParentOrderRepo.findAll(mallParentOrderSpecification);
        if (CollectionUtil.isNoneEmpty(mallParentOrders)) {
            return BeanMapper.map(mallParentOrders.get(0), MallParentOrderDto.class);
        }
        return null;
    }

    @Override
    public MallParentOrderDto findParentOrderById(String parentOrderId) {
        MallParentOrder mallParentOrder = mallParentOrderRepo.findOne(parentOrderId);
        MallParentOrderDto mallParentOrderDto = BeanMapper.map(mallParentOrder, MallParentOrderDto.class);
        mallParentOrderDto.setParentOrderNo(mallParentOrder.getParentOrderNo());
        return mallParentOrderDto;
    }

    @Override
    public BaseResponse<String> findParentOrderNo(String id) {
        MallParentOrder parentOrder = mallParentOrderRepo.findOne(id);
        if (parentOrder != null) {
            return new BaseResponse<>(true, "查询成功", parentOrder.getParentOrderNo());
        }
        return new BaseResponse<>(false, "不存在该订单");
    }



}
