package order.service.stubs;

import activities.api.ActivityGoodsApi;
import activities.dto.activity.request.ActivityGoodsReqDto;
import activities.dto.activity.response.ActivityGoodsRespDto;
import activities.dto.goods.GoodsDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * 活动商品API本地代理
 * @author Liang Wenxu
 * @since 2018/7/30
 */
@Slf4j
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class ActivityGoodsApiStub {
    /**
     * 批量判断商品是否是活动商品并获取活动价
     * isActivityGoods true 是活动商品
     * activityPrice 活动价，非活动商品该值不返回
     *
     * @param goodses GoodsDto列表，只需提供id即可！
     * @param organizationCode
     * @return
     */
    public List<Map<String, Object>> isActivityGoodsAndGetActivityPriceBatch(List<GoodsDto> goodses, String organizationCode) {
        return activityGoodsApi.isActivityGoodsAndGetActivityPriceBatch(goodses, organizationCode);
    }

    public ActivityGoodsRespDto isActivityGoodsAndGetActivityPrice(ActivityGoodsReqDto activityGoodsReqDto) {
        return activityGoodsApi.isActivityGoodsAndGetActivityPrice(activityGoodsReqDto);
    }

    /**
     * 是否场次限制
     *
     * @param memberId     用户ID
     * @param activityId   活动场次ID
     * @param limitedCount 限制数量
     * @return
     */
    public boolean isActivityLimited(String memberId, String activityId, int limitedCount) {
        return activityGoodsApi.isActivityLimited(memberId, activityId, limitedCount);
    }

    /**
     * 是否商品当前处于活动期间
     * @param goodsId 商品ID
     * @param organizationCode 机构代码
     * @return 如果处于活动期间, 则返回活动场次ID, 否则返回 null
     */
    public String isInActivityNow(String goodsId, String organizationCode) {
        return activityGoodsApi.isInActivityNow(goodsId, organizationCode);
    }

    @MotanReferer
    ActivityGoodsApi activityGoodsApi;
}
