package order.service.stubs;

import api.BiddingMainApi;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018/7/30
 */
@Slf4j
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class BiddingMainApiStub {
    /**
     * 获取是否需要投票情况，决定是否显示投票标签
     *
     * @param biddingNo
     * @param memberId
     * @return
     */
    public BaseResponse<Boolean> getVoteStatus(String biddingNo, String memberId) {
        return biddingMainApi.getVoteStatus(biddingNo, memberId);
    }

    /**
     * 获取竞价操作人姓名
     * @param operatorId
     * @return
     */
    public String getOperatorName(String operatorId) {
        return null;
        //return biddingMainApi.getOperatorName(operatorId);
    }

    /**
     * 生成竞价编码
     * @return
     */
    public BaseResponse<String> getBiddingNo() {
        return biddingMainApi.getBiddingNo();
    }

    /**
     * 根据sku列表查询
     * @param skus
     * @return
     */
    public Boolean findTempOrderBySkus(List<String> skus) {
        return biddingMainApi.findTempOrderBySkus(skus);
    }

    @MotanReferer
    BiddingMainApi biddingMainApi;
}
