package order.service.stubs;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import lombok.extern.slf4j.Slf4j;
import member.api.CoreCompanyApi;
import member.api.dto.core.CoreCompanyDto;
import member.api.vo.ValidateTaxIdentification;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2018/8/3
 */
@Slf4j
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class CoreCompanyApiStub {
    /**
     * 根据coreCompanyId取CoreCompany信息
     * @param coreCompanyId 组织机构id
     * @return CoreCompany，根据机构id，返回相应的机构信息
     */
    public CoreCompanyDto getCoreCompanyInfoById(String coreCompanyId) {
        return coreCompanyApi.getCoreCompanyInfoById(coreCompanyId);
    }

    /**
     * 取组织信息
     * @param coreCompanyId 机构id
     * @return CoreCompany, 根据传入的机构id，返回相应的机构信息
     */
    public CoreCompanyDto getCompanyInfo(String coreCompanyId) {
        return coreCompanyApi.getCompanyInfo(coreCompanyId);
    }

    /**
     * 取组织信息
     * @param coreCompanyId 机构id
     * @param withChildren 当为false时，不返回下属机构集合
     * @return
     */
    public CoreCompanyDto getCompanyInfo(String coreCompanyId, Boolean withChildren) {
        return coreCompanyApi.getCompanyInfo(coreCompanyId, withChildren);
    }

    /**
     * 取组织集合
     * @return List<CoreCompany>，返回所有机构信息
     */
    public List<CoreCompanyDto> findAllByParent_idIsNotNull() {
        return coreCompanyApi.findAllByParent_idIsNotNull();
    }

    /**
     * 查询所有组织
     * @return List<CoreCompany>，返回所有机构信息列表
     */
    public List<CoreCompanyDto> findAllCompany() {
        return coreCompanyApi.findAllCompany();
    }

    /**
     * 查询所有组织(不包含child、parent)
     * @return List<CoreCompany>，返回所有机构信息列表
     */
    public List<CoreCompanyDto> findAllSimpleCompany() {
        return coreCompanyApi.findAllSimpleCompany();
    }

    /**
     * 取组织集合
     * @param isDelete 是否已删除
     * @return List<CoreCompany>，返回所有未删除的机构信息，按创建时间升序排序
     */
    public List<CoreCompanyDto> findByIsDelete(boolean isDelete) {
        return coreCompanyApi.findByIsDelete(isDelete);
    }

    /**
     * 获取子组织集合
     * @param isDelete 是否删除
     * @return List<CoreCompany>，返回子机构列表
     */
    public List<CoreCompanyDto> findAllByParent_idIsNotNullAndIsDelete(boolean isDelete) {
        return coreCompanyApi.findAllByParent_idIsNotNullAndIsDelete(isDelete);
    }

    /**
     * 获取某个父节点下的所有孩子节点
     * @param parent_id 父机构id
     * @param isDelete 是否删除
     * @return List<CoreCompany>，根据传入的参数，返回相应父节点下的子机构
     */
    public List<CoreCompanyDto> findAllByParent_idAndIsDelete(String parent_id, boolean isDelete) {
        return coreCompanyApi.findAllByParent_idAndIsDelete(parent_id, isDelete);
    }

    /**
     * 根据公司层级查询公司id
     * @param level 机构层级  1.集团 2.公司 3.二级机构
     * @return List<String>，根据传入的机构层级，返回该层级及该层级以下的机构id列表
     */
    public List<String> findCompanyIdsByCompanyLevel(Integer level) {
        return coreCompanyApi.findCompanyIdsByCompanyLevel(level);
    }

    /**
     * 获取所有根节点
     * @param isDelete 是否删除
     * @return List<CoreCompany>，返回所有顶级机构信息列表
     */
    public List<CoreCompanyDto> findAllByParent_idIsNullAndIsDelete(boolean isDelete) {
        return coreCompanyApi.findAllByParent_idIsNullAndIsDelete(isDelete);
    }

    /**
     * 根据机构编号查询机构信息
     * @param code 机构编号
     * @param isDelete 是否删除
     * @return CoreCompany，根据传入的机构编号，返回相应的机构信息
     */
    public CoreCompanyDto findByCodeAndIsDelete(String code, boolean isDelete) {
        return coreCompanyApi.findByCodeAndIsDelete(code, isDelete);
    }

    /**
     * 根据机构id，获取该机构及子机构的id列表
     * @param companyId 机构id
     * @return List<String>，根据传入的机构id，返回该机构及子机构id列表
     */
    public List<String> getCompanyListById(String companyId) {
        return coreCompanyApi.getCompanyListById(companyId);
    }

    /**
     * 获取当前机构及其所有下级机构
     * @param companyId
     * @return
     */
    public List<CoreCompanyDto> getAllComNodeList(String companyId) {
        return coreCompanyApi.getAllComNodeList(companyId);
    }

    /**
     * 根据id查询父机构
     * @param parentId 父机构id
     * @param companyLevelTwo 机构层级
     * @return CoreCompany，根据传入的父机构id，查询相应的机构信息，若该机构层级大于所传入的机构层级，则返回该机构的父机构
     */
    public CoreCompanyDto getParentCompany(String parentId, Integer companyLevelTwo) {
        return coreCompanyApi.getParentCompany(parentId, companyLevelTwo);
    }

    public Map<String, Object> findByNameAndIsDelete(String name, boolean isDelete) {
        return coreCompanyApi.findByNameAndIsDelete(name, isDelete);
    }

    public List<CoreCompanyDto> getByNameAndIsDelete(String name, boolean isDelete) {
        return coreCompanyApi.getByNameAndIsDelete(name, isDelete);
    }

    public List<Map<String, Object>> findByDateCreated() {
        return coreCompanyApi.findByDateCreated();
    }

    /**
     * 根据 hrId 确定最近的共同上级（LCA）
     * @param hrIds
     * @return
     */
    public String parentCompanyId(List<String> hrIds) {
        return coreCompanyApi.parentCompanyId(hrIds);
    }

    public CoreCompanyDto findByTpHrId(String tpHrId) {
        return coreCompanyApi.findByTpHrId(tpHrId);
    }

    /**
     * 查找相应level的公司
     * @param level
     * @param isDelete
     * @return
     */
    public List<CoreCompanyDto> findByCompanyLevelAndIsDelete(Integer level, boolean isDelete) {
        return coreCompanyApi.findByCompanyLevelAndIsDelete(level, isDelete);
    }

    /**
     * 查找相应level的父类公司
     * @param parentCompanyId
     * @param level
     */
    public List<CoreCompanyDto> findAllByParent_idAndCompanyLevel(String parentCompanyId, Integer level) {
        return coreCompanyApi.findAllByParent_idAndCompanyLevel(parentCompanyId, level);
    }

    public CoreCompanyDto findById(String companyId) {
        return coreCompanyApi.findById(companyId);
    }

    /**
     * 根据Fax查询Company信息
     * @param key
     * @return
     */
    public List<CoreCompanyDto> findByFax(String key) {
        return coreCompanyApi.findByFax(key);
    }

    /**
     * 获取子机构
     * @param id
     * @return
     */
    public List<CoreCompanyDto> getChildByParentId(String id) {
        return coreCompanyApi.getChildByParentId(id);
    }

    /**
     * 通过纳税人识别号查询机构信息
     * @param taxpayerNum
     * @return
     */
    public List<CoreCompanyDto> getInfoByTaxpayerNum(String taxpayerNum) {
        return coreCompanyApi.getInfoByTaxpayerNum(taxpayerNum);
    }

    /**
     * 校验纳税人识别号是否存在
     * @param list
     * @return
     */
    public Map validataTaxIdentification(List<ValidateTaxIdentification> list) {
        return coreCompanyApi.validataTaxIdentification(list);
    }

    @MotanReferer
    CoreCompanyApi coreCompanyApi;
}
