package order.service.stubs;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.dto.GoodsQueryDto;
import goods.dto.GoodsStateDto;
import goods.dto.goods.GoodsDto;
import goods.dto.goods.GoodsPictureDto;
import goods.dto.goods.ValidationSkuEffDto;
import goods.dto.product.ProductCategoryDto;
import goods.dto.product.ProductDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import utils.rpc.motan.ApiResponseVo;
import utils.sql.PageVo;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2018/7/30
 */
@Slf4j
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class GoodsApiStub {
    public List<GoodsStateDto> queryGoodsState(List<String> skus) {
        return goodsApi.queryGoodsState(skus);
    }

    public GoodsDto findOne(String goodsId) {
        return goodsApi.findOne(goodsId);
    }

    /**
     * 批量根据goodsId查询productFashionId
     *
     * @param goodsIds
     * @return key:goodsId ,value:fashionId
     */
    public ApiResponseVo<Map<String, String>> findFasionIdsByGoodsIds(List<String> goodsIds) {
        return goodsApi.findFasionIdsByGoodsIds(goodsIds);
    }

    public Page<GoodsDto> findByIsDeleteAndStateAndStoreIdIn(Boolean delete, Integer state, String[] storeIds, Pageable pageable) {
        return goodsApi.findByIsDeleteAndStateAndStoreIdIn(delete, state, storeIds, pageable);
    }

    public Page<GoodsDto> findByIsDeleteAndStateAndStoreIdInAndProduct_ProductCategory(Boolean delete, Integer state, String[] storeIds, ProductCategoryDto productCategory, Pageable pageable) {
        return goodsApi.findByIsDeleteAndStateAndStoreIdInAndProduct_ProductCategory(delete, state, storeIds, productCategory, pageable);
    }

    public Page<GoodsDto> findAll(Pageable pageable) {
        return goodsApi.findAll(pageable);
    }

    public List<GoodsDto> findByIsDeleteAndStateAndProduct(Boolean delete, Integer state, ProductDto product) {
        return goodsApi.findByIsDeleteAndStateAndProduct(delete, state, product);
    }

    public List<String> findByBrandNameByIds(List<String> goodsIdList) {
        return goodsApi.findByBrandNameByIds(goodsIdList);
    }

    public Page<GoodsDto> findByIsDeleteAndStateAndStoreIdInAndProduct(Boolean delete, Integer state, String[] storeIds, ProductDto product, Pageable pageable) {
        return goodsApi.findByIsDeleteAndStateAndStoreIdInAndProduct(delete, state, storeIds, product, pageable);
    }

    /**
     * 获取协议价格
     *
     * @param id id
     * @return BigDecimal
     */
    public BigDecimal findCostPriceById(String id) {
        return goodsApi.findCostPriceById(id);
    }

    /**
     * 获取市场价格
     *
     * @param id id
     * @return BigDecimal
     */
    public BigDecimal findMarketPriceById(String id) {
        return goodsApi.findMarketPriceById(id);
    }

    /**
     * 获取销售价格
     *
     *
     * @param goodId@return BigDecimal
     */
    public BigDecimal findSalePriceById(String goodId) {
        return goodsApi.findSalePriceById(goodId);
    }

    /**
     * 获取sku
     *
     *
     * @param goodsId@return String
     */
    public String findSkuById(String goodsId) {
        return goodsApi.findSkuById(goodsId);
    }

    /**
     * 按ID获取商品信息
     *
     * @param id
     * @return
     */
    public GoodsDto findById(String id) {
        return goodsApi.findById(id);
    }

    /**
     * 根据供应商查找商品
     *
     * @param storeId
     * @param pageable
     * @return
     */
    public Page<GoodsDto> findByParams(String storeId, Pageable pageable) {
        return goodsApi.findByParams(storeId, pageable);
    }

    /**
     * 根据供应商与上下架状态查找商品
     *
     * @param storeId
     * @param state
     * @param pageable
     * @return
     */
    public Page<GoodsDto> findByParams(String storeId, Integer state, Pageable pageable) {
        return goodsApi.findByParams(storeId, state, pageable);
    }

    /**
     * 根据供应商与商品名称模糊查询商品
     *
     * @param storeId
     * @param name
     * @param pageable
     * @return
     */
    public Page<GoodsDto> findByParams(String storeId, String name, Pageable pageable) {
        return goodsApi.findByParams(storeId, name, pageable);
    }

    /**
     * 根据供应商、模糊名称、上下架状态查找商品
     *
     * @param storeId
     * @param name
     * @param state
     * @param pageable
     * @return
     */
    public Page<GoodsDto> findByParams(String storeId, String name, Integer state, Pageable pageable) {
        return goodsApi.findByParams(storeId, name, state, pageable);
    }

    public PageVo<GoodsDto> findByParams(GoodsQueryDto goodsQueryDto) {
        return goodsApi.findByParams(goodsQueryDto);
    }

    public List<GoodsDto> findByCodeAndSkuAndStoreIdAndIsdeleteAndState(String code, String sku, String storeId, boolean isDelete, Integer state) {
        return goodsApi.findByCodeAndSkuAndStoreIdAndIsdeleteAndState(code, sku, storeId, isDelete, state);
    }

    /***
     * 批量获取goods的状态，不需要使用JPA查询，因为关联太多了
     * @param goodsIds
     * @return
     */
    public List<Map<String, Object>> getBatchGoodsState(List<String> goodsIds) {
        return goodsApi.getBatchGoodsState(goodsIds);
    }

    public List<GoodsDto> findBySku(String sku) {
        return goodsApi.findBySku(sku);
    }

    public List<GoodsDto> findByProductId(String productId) {
        return goodsApi.findByProductId(productId);
    }

    public List<GoodsDto> findByCodeAndSkuAndIsdeleteAndState(String code, String sku, Boolean isDelete, Integer state) {
        return goodsApi.findByCodeAndSkuAndIsdeleteAndState(code, sku, isDelete, state);
    }

    /**
     * 竞价用-验证sku有效性接口
     *
     * @param skus
     * @param storeId
     * @return
     */
    public ValidationSkuEffDto findSkuValidity(List<String> skus, String storeId) {
        return goodsApi.findSkuValidity(skus, storeId);
    }

    /**
     * 竞价执行采购页商品列表查询商品名称
     *
     * @param sku
     * @return
     */
    public String findGoodsNameBySku(String sku) {
        return goodsApi.findGoodsNameBySku(sku);
    }

    /**
     * 竞价执行采购页商品列表查询商品ID
     *
     * @param sku
     * @return
     */
    public String findGoodsIdBySku(String sku) {
        return goodsApi.findGoodsIdBySku(sku);
    }

    /**
     * 根据SKU获取商品图片
     * @param sku 商品SKU
     * @return
     */
    public List<GoodsPictureDto> getPicturesBySku(String sku) {
        return goodsApi.getPicturesBySku(sku);
    }


    /**
     * 根据id列表查询商品
     *
     * @param ids
     * @return
     */
    public List<GoodsDto> findByIdIn(List<String> ids) {
        return goodsApi.findByIdIn(ids);
    }
    @MotanReferer
    GoodsApi goodsApi;


}
