package order.service.stubs;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.SalesPriceRateApi;
import goods.dto.goods.SalesPriceRateDto;
import goods.vo.SalesPriceCalVo;
import goods.vo.SalesPriceRateQueryVo;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2018/7/18
 */
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class SalesPriceRateApiStub {
    /**
     *
     * 获取当前商户所有配置的费率
     * @param salesPriceRateQueryVo
     * @return
     */
    public List<SalesPriceRateDto> getSalesPriceRate(SalesPriceRateQueryVo salesPriceRateQueryVo) {
        return salesPriceRateApi.getSalesPriceRate(salesPriceRateQueryVo);
    }

    /**
     * 根据费率计算销售价格
     *
     * @param salesPriceCalVo @return
     */
    public BigDecimal calSalesPrice(SalesPriceCalVo salesPriceCalVo) {
        return salesPriceRateApi.calSalesPrice(salesPriceCalVo);
    }

    /**
     * 批量计算售价费率
     * @param salesPriceCalVoList 计算请求Vo列表，请求VO请查询：
     * @see SalesPriceCalVo
     * @return List<Map>，按传入的salesPriceCalVoList顺序返回费率计算后的价格， 返回数据示例->
     *     [{fashionId: 'asdfdfasdf-asdfasdf-asdf-asdfsdf'@String, salePrice:'0.00'@BigDecimal}...]
     */
    public List<Map> calBatchSalesPrice(List<SalesPriceCalVo> salesPriceCalVoList) {
        return salesPriceRateApi.calBatchSalesPrice(salesPriceCalVoList);
    }

    @MotanReferer
    SalesPriceRateApi salesPriceRateApi;
}
