package order.service.stubs;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.SalesPriceRateQueryApi;
import goods.dto.goods.GoodsDto;
import goods.vo.SalesPriceQueryVo;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2018/8/30
 */
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class SalesPriceRateQueryApiStub {
    /**
     * 根据SalesPriceQueryVo参数搜索
     * @param salesPriceQueryVos
     * @return
     */
    public List<Map> getSalesPriceListByParams(List<SalesPriceQueryVo> salesPriceQueryVos) {
        return salesPriceRateQueryApi.getSalesPriceListByParams(salesPriceQueryVos);
    }

    /**
     * 批量查询费率售价
     *
     * @param goodsIds List<String> goodsId 集合
     * @param storeCode 店铺代码
     * @param organizationId 机构ID
     * @return Map<String ,   BigDecimal> key=goodsId, value=费率售价
     */
    public Map<String, BigDecimal> getSaleRatePriceBatchByGoodsIds(List<String> goodsIds, String storeCode, String organizationId) {
        return salesPriceRateQueryApi.getSaleRatePriceBatchByGoodsIds(goodsIds, storeCode, organizationId);
    }

    /**
     * 批量查询费率售价
     *
     * @param goodsDTOs List<GoodsDto> goodsDTO 集合
     * @param storeCode 店铺代码
     * @param organizationId 机构ID
     * @return Map<String ,   BigDecimal> key=goodsId, value=费率售价
     */
    public Map<String, BigDecimal> getSaleRatePriceBatchByGoodsList(List<GoodsDto> goodsDTOs, String storeCode, String organizationId) {
        return salesPriceRateQueryApi.getSaleRatePriceBatchByGoodsList(goodsDTOs, storeCode, organizationId);
    }

    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;
}
