package order.service.stubs;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import shipping.api.ShippingInfoApi;
import shipping.api.dto.InvoiceInfoDto;
import shipping.api.dto.ShippingInfoDto;
import shipping.api.dto.SubOrderShippingListDto;
import shipping.api.vo.*;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2018/8/30
 */
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class ShippingInfoApiStub {
    /**
     * 根据物流单号来查询物流信息
     *
     * @param traceNo
     * @return
     */
    public List<SubOrderShippingListDto> findShippingListBySuborderId(String traceNo) {
        return shippingInfoApi.findShippingListBySuborderId(traceNo);
    }

    public ShippingInfoDto findById(String id) {
        return shippingInfoApi.findById(id);
    }

    /**
     * 根据物流导入序号查询
     *
     * @param importSerial
     * @return
     */
    public List<ShippingInfoDto> findByImportSerial(String importSerial) {
        return shippingInfoApi.findByImportSerial(importSerial);
    }

    public List<ShippingInfoDto> findByIds(List<String> ids) {
        return shippingInfoApi.findByIds(ids);
    }

    public List<ShippingInfoVo> findVoByIds(List<String> ids) {
        return shippingInfoApi.findVoByIds(ids);
    }

    /**
     * 查询导入记录
     *
     * @param importDateStart
     * @param importDateEnd
     * @param pageable
     * @return
     */
    public Page<Map> queryShippingImportInfo(Date importDateStart, Date importDateEnd, Pageable pageable) {
        return shippingInfoApi.queryShippingImportInfo(importDateStart, importDateEnd, pageable);
    }

    /**
     * 条件查询（带分页）
     *
     * @param example  查询对象，不需要的条件对应变量为null，其中
     * @param pageable
     * @return
     */
    public Page<ShippingInfoDto> findByExamplePaged(ShippingInfoDto example, Pageable pageable) {
        return shippingInfoApi.findByExamplePaged(example, pageable);
    }

    /**
     * 新增ShippingInfo
     *
     * @param shippingInfoVo
     * @return
     * @see ResponseMapUtils
     */
    public Map createShippingInfo(ShippingInfoVo shippingInfoVo) {
        return shippingInfoApi.createShippingInfo(shippingInfoVo);
    }

    /**
     * 批量新增ShippingInfo
     *
     * @param shippingInfoVo
     * @return
     * @see ResponseMapUtils
     */
    public Map createShippingInfo(List<ShippingInfoVo> shippingInfoVo) {
        return shippingInfoApi.createShippingInfo(shippingInfoVo);
    }

    /**
     * 直接从发票信息生成配送信息
     *
     * @param invoiceInfo 发票信息
     * @param orgId       机构ID
     * @param sender      ShippingSenderVo 如传null，则使用当前Service默认配置
     * @return
     * @see ResponseMapUtils
     */
    public Map createShippingInfoByInvoice(InvoiceInfoDto invoiceInfo, String orgId, ShippingSenderVo sender) {
        return shippingInfoApi.createShippingInfoByInvoice(invoiceInfo, orgId, sender);
    }

    /**
     * 从发票信息表生成物流vo
     *
     * @param invoiceInfo
     * @return
     */
    public Map createInfoByInvoice(InvoiceInfoDto invoiceInfo) {
        return shippingInfoApi.createInfoByInvoice(invoiceInfo);
    }

    /**
     * 按照ShippingInfoQuery对象查询
     *
     * @param shippingInfoQueryVo
     * @param pageable
     * @return
     */
    public Page<ShippingInfoDto> findByQueryVo(ShippingInfoQueryVo shippingInfoQueryVo, Pageable pageable) {
        return shippingInfoApi.findByQueryVo(shippingInfoQueryVo, pageable);
    }

    /**
     * 按照ShippingInfoQuery对象查询
     *
     * @param shippingInfoQueryVo
     * @return
     */
    public List<ShippingInfoDto> findByQueryVo(ShippingInfoQueryVo shippingInfoQueryVo) {
        return shippingInfoApi.findByQueryVo(shippingInfoQueryVo);
    }

    /**
     * 从发票信息表生成物流vo （不会创建ShippingItem）
     *
     * @param invoiceInfo
     * @return
     */
    public ShippingInfoVo createInfoVoByInvoice(InvoiceInfoDto invoiceInfo) {
        return shippingInfoApi.createInfoVoByInvoice(invoiceInfo);
    }

    /**
     * 更新物流信息表的第三方物流单号
     *
     * @param shippingInfoIdShippingNoVoList
     * @return Map -> {"serial": 导入序列号， "sucCount": 成功计数}
     */
    public Map updateShippingNo(List<ShippingInfoIdShippingNoVo> shippingInfoIdShippingNoVoList) {
        return shippingInfoApi.updateShippingNo(shippingInfoIdShippingNoVoList);
    }

    /**
     * 物流信息跟踪
     *
     * @param shippingNo 运单号
     * @return
     */
    public ShippingTraceInfoVo traceShipping(String shippingNo) {
        return shippingInfoApi.traceShipping(shippingNo);
    }

    /**
     * 查询物流跟踪信息
     *
     * @param shippingNo 运单号
     * @param configCode 物流商户配置代码
     * @return
     * @see ShippingInfoApi#traceShipping(String)
     */
    public ShippingTraceInfoVo traceShipping(String shippingNo, String configCode) {
        return shippingInfoApi.traceShipping(shippingNo, configCode);
    }

    /**
     * 物流信息跟踪
     *
     * @param shippingId shippingInfo的id
     * @return
     */
    public ShippingTraceInfoVo traceShippingId(String shippingId) {
        return shippingInfoApi.traceShippingId(shippingId);
    }

    @MotanReferer
    ShippingInfoApi shippingInfoApi;
}
