package order.service.stubs;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.api.SupplierOrderApi;
import outsideapi.exceptions.OrderCancelException;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierOrderComfirmFalidException;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.vo.BackOrderResp;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.order.TrdOrderKey;
import outsideapi.vo.orderrequest.OrderRequst;

import java.util.List;

/**
 * 供应商订单API本地代理
 * @author Liang Wenxu
 * @since 2018/8/13
 */
@Slf4j
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class SupplierOrderApiStub {

    /**
     * 取消订单
     *
     *
     * @param trdOrderKey @return
     * @throws SupplierInterfaceInvokeException 供应商接口链接异常
     */
    public Boolean cancelOrder(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException, OrderCancelException {
        return supplierOrderApi.cancelOrder(trdOrderKey);
    }

    /**
     * 向第三方供应商下单
     * @param orderMain 商城订单信息
     * @return 返回生产成功的第三方订单详情
     * @throws SupplierInterfaceInvokeException 供应商接口调用异常
     * @throws SupplierTakeOrderFalidException 供应商下单失败异常
     */
    public TrdOrder takeOrder(OrderRequst orderMain) throws SupplierInterfaceInvokeException, SupplierTakeOrderFalidException {
        return supplierOrderApi.takeOrder(orderMain);
    }

    /**
     * 确认下单，调用时记得处理所有的异常噢！
     * @param orderMain 商城订单信息
     * @throws SupplierInterfaceInvokeException 供应商接口调用异常
     * @throws SupplierOrderComfirmFalidException 供应商下单失败异常，其中错误代码3103表示已确认下单无需重复确认
     */
    public void confirmOrder(OrderRequst orderMain) throws SupplierInterfaceInvokeException, SupplierOrderComfirmFalidException {
        supplierOrderApi.confirmOrder(orderMain);
    }

    /**
     * 订单退货（暂定）
     * @param orderMain 退货的订单信息
     * @param skuIds 退货的sku
     * @return
     * @throws SupplierInterfaceInvokeException
     */
    public BackOrderResp backOrder(OrderRequst orderMain, List<String> skuIds) throws SupplierInterfaceInvokeException {
        return supplierOrderApi.backOrder(orderMain, skuIds);
    }

    /**
     * 获取订单详情
     *
     * @param trdOrderKey 第三方订单唯一标识，采用storeCode + trdOrderNo作为唯一标识
     * @return 返回第三方订单详情
     * @throws SupplierInterfaceInvokeException 供应商接口链接异常
     */
    public TrdOrder getDetail(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException {
        return supplierOrderApi.getDetail(trdOrderKey);
    }

    /**
     * 订单号反查接口
     *
     * @param trdOrderKey @return 第三方供应商订单号
     */
    public String queryTrdOrderNo(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException {
        return supplierOrderApi.queryTrdOrderNo(trdOrderKey);
    }

    @MotanReferer
    SupplierOrderApi supplierOrderApi;

    @Autowired
    OrganizationApiStub organizationApi;

    @Autowired
    SystemConfigApiStub systemConfigApi;
}
