/*
 * Decompiled with CFR 0.152.
 */
package order.service.apiimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.util.ArrayList;
import java.util.List;
import order.Contants;
import order.api.OrderApi;
import order.dto.OrderQueryDto;
import order.exceptions.IllegalAreaCodeException;
import order.exceptions.OrderCreateException;
import order.exceptions.UnAuditableOrderException;
import order.exceptions.temporder.TempOrderCreateException;
import order.service.service.OrderService;
import order.service.service.query.OrderMainQueryService;
import order.vo.CancelOrderResp;
import order.vo.CusPayInfo;
import order.vo.OrderKey;
import order.vo.OrderPayConfirmResp;
import order.vo.OrderStatus;
import order.vo.OrderVo;
import order.vo.TempOrderCreateRequest;
import order.vo.TempOrderVo;
import order.vo.query.OrdersQueryVo;
import order.vo.response.OrderAuditingResult;
import order.vo.response.OrderPrice;
import order.vo.response.OrderStock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.sql.PageVo;

@MotanService(basicService="motanServerBasicConfig")
@Transactional(propagation=Propagation.NOT_SUPPORTED)
public class OrderApiImpl
implements OrderApi {
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderMainQueryService orderMainQueryService;
    private static final Logger logger = LoggerFactory.getLogger(OrderApiImpl.class);

    public BaseResponse queryProviderOrdersDetails(String orderNo) {
        logger.info("\u7b2c\u4e09\u65b9\u8ba2\u5355\u5bf9\u63a5\u63a5\u53e3\uff0c\u67e5\u8be2\u8ba2\u5355\u8be6\u7ec6\u4fe1\u606f\u63a5\u53e3\u8f93\u5165\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)orderNo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        BaseResponse baseResponse = this.orderMainQueryService.queryProviderOrdersDetails(orderNo);
        logger.info("\u7b2c\u4e09\u65b9\u8ba2\u5355\u5bf9\u63a5\u63a5\u53e3\uff0c\u67e5\u8be2\u8ba2\u5355\u8be6\u7ec6\u4fe1\u606f\u63a5\u53e3\u8f93\u51fa\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)baseResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return baseResponse;
    }

    public BaseResponse<PageVo<OrdersQueryVo>> queryProviderOrdersPage(OrderQueryDto orderQueryDto) {
        logger.info("\u7b2c\u4e09\u65b9\u8ba2\u5355\u5bf9\u63a5\u63a5\u53e3\uff0c\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u63a5\u53e3\u8f93\u5165\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)orderQueryDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        BaseResponse baseResponse = this.orderMainQueryService.queryProviderOrdersPage(orderQueryDto);
        logger.info("\u7b2c\u4e09\u65b9\u8ba2\u5355\u5bf9\u63a5\u63a5\u53e3\uff0c\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u63a5\u53e3\u8f93\u51fa\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)baseResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return baseResponse;
    }

    public TempOrderVo newTempOrder(TempOrderCreateRequest tempOrderCreateRequest) throws TempOrderCreateException {
        return this.orderService.newTempOrder(tempOrderCreateRequest);
    }

    public OrderStock tempOrderStock(TempOrderVo tempOrderVo) throws IllegalAreaCodeException {
        return this.orderService.tempOrderStock(tempOrderVo);
    }

    public OrderPrice tempOrderPrice(TempOrderVo tempOrderVo) throws IllegalAreaCodeException {
        return this.orderService.tempOrderPrice(tempOrderVo);
    }

    public OrderVo submit(TempOrderVo tempOrder) throws OrderCreateException {
        return this.orderService.submit(tempOrder);
    }

    public List<OrderVo> refresh(List<OrderKey> orderKeys) {
        return this.orderService.refresh(orderKeys);
    }

    public OrderAuditingResult audit(OrderKey orderKey, Boolean passed, Boolean cancelSupplierOrder) throws UnAuditableOrderException {
        return this.orderService.audit(orderKey, passed, cancelSupplierOrder);
    }

    public List<OrderAuditingResult> audit(List<OrderKey> orderKeys, Boolean passed, Boolean cancelSupplierOrder) {
        return this.orderService.audit(orderKeys, passed, cancelSupplierOrder);
    }

    public OrderPayConfirmResp payComfirmed(OrderKey orderKey) {
        return this.orderService.payComfirmed(orderKey);
    }

    public CancelOrderResp cancel(OrderKey orderKey, Contants.CancelOrderType cancelType) {
        ArrayList<OrderKey> orderKeys = new ArrayList<OrderKey>();
        orderKeys.add(orderKey);
        return this.cancel(orderKeys, cancelType);
    }

    public CancelOrderResp cancel(List<OrderKey> orderKey, Contants.CancelOrderType cancelType) {
        return this.orderService.cancel(orderKey, cancelType);
    }

    public void receipt(OrderKey orderKey, String receiptType) {
        this.orderService.receipt(orderKey, receiptType);
    }

    public void statusChange(OrderStatus orderStatus) {
        this.orderService.statusChange(orderStatus);
    }

    public void prePayDone(OrderKey orderKey, CusPayInfo cusPayInfo) {
        this.orderService.prePayDone(orderKey, cusPayInfo);
    }
}

