/*
 * Decompiled with CFR 0.152.
 */
package order.service.config;

import com.weibo.api.motan.config.springsupport.BasicRefererConfigBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.Lang;

@Configuration
public class CommonWebMotanConfig {
    @Bean(name={"motanClientBasicConfig"})
    @ConditionalOnMissingBean
    public BasicRefererConfigBean baseRefererConfig(@Value(value="${motan.client.group:sinomall}") String motanClientGroup, @Value(value="${motan.client.access.log:false}") Boolean motanClientAccessLog) {
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol("motan");
        if (Lang.isEmpty((Object)motanClientGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(motanClientGroup);
        }
        if (Lang.isEmpty((Object)motanClientAccessLog)) {
            config.setAccessLog(false);
        } else {
            config.setAccessLog(motanClientAccessLog.booleanValue());
        }
        config.setRegistry("registry");
        config.setCheck(false);
        config.setRequestTimeout(Integer.valueOf(360000));
        config.setThrowException(Boolean.valueOf(true));
        config.setDefault(true);
        return config;
    }

    @Bean(name={"motanClientFastFailConfig"})
    public BasicRefererConfigBean clientFastFailConfig(@Value(value="${motan.client.group:sinomall}") String motanClientGroup, @Value(value="${motan.client.access.log:false}") Boolean motanClientAccessLog) {
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol("motan");
        if (Lang.isEmpty((Object)motanClientGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(motanClientGroup);
        }
        if (Lang.isEmpty((Object)motanClientAccessLog)) {
            config.setAccessLog(false);
        } else {
            config.setAccessLog(motanClientAccessLog.booleanValue());
        }
        config.setRegistry("registry");
        config.setCheck(false);
        config.setRequestTimeout(Integer.valueOf(60000));
        config.setThrowException(Boolean.valueOf(true));
        config.setDefault(true);
        return config;
    }
}

