/*
 * Decompiled with CFR 0.152.
 */
package order.service.events.listener;

import fiance.messages.bills.BillsQueueOrderRequest;
import fiance.messages.bills.BillsQueueRequest;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import ma.glasnost.orika.MapperFacade;
import order.model.po.OrderMain;
import order.service.events.OrderEvent;
import order.service.events.OrderPassedEvent;
import order.service.jms.JmsHelper;
import order.service.service.OrderMainService;
import order.service.service.OrderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.stereotype.Component;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;

@Component
public class MallDefaultOrderPassedEventListener
implements SmartApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(MallDefaultOrderPassedEventListener.class);
    private static final String orgCode = "protocol";
    @Value(value="${activemq.queue.orderEvents:}")
    private String orderEventQueue;
    @Value(value="${finance.bills.message.queue.billscreate:}")
    private String billsCreateQueue;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    OrderMainService orderMainService;
    @Autowired
    JmsHelper jmsHelper;
    @Autowired
    OrderService orderService;

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType == OrderPassedEvent.class;
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        OrderPassedEvent orderEvent = (OrderPassedEvent)event;
        OrderMain orderMain = (OrderMain)orderEvent.getSource();
        log.info("\u8ba2\u5355\u5ba1\u6838\u901a\u8fc7\u4e8b\u4ef6orderMain\uff1a{}", (Object)orderMain);
        if (!Lang.isEmpty((Object)orderMain)) {
            this.orderMainService.updateOrderAuditEndTime(orderMain.getId());
            if (!StoreDto.STORE_TYPE_PROTOCOL.equals(orderMain.getStoreType())) {
                log.info("orderNo: {}, orgCode: {} ,\u975e\u534f\u8bae\u91c7\u8d2d\u8ba2\u5355\u5ba1\u6838\u901a\u8fc7\u4e8b\u4ef6", (Object)orderMain.getOrderNo(), (Object)((OrderEvent)event).getOrgCode());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                BillsQueueRequest billsQueueRequest = new BillsQueueRequest();
                billsQueueRequest.setBillsTime(new Date());
                String requestId = Lang.isEmpty((Object)orderMain.getBillsRequestId()) ? "direct_" + orderMain.getOrderNo() + "_" + sdf.format(new Date()) : orderMain.getBillsRequestId();
                billsQueueRequest.setRequestId(requestId);
                billsQueueRequest.setInvoiceFlag(Boolean.valueOf(true));
                billsQueueRequest.setVoucherFlag(Boolean.valueOf(true));
                billsQueueRequest.setSouceCode("direct");
                billsQueueRequest.setPrice(orderMain.getSumPrice());
                ArrayList<BillsQueueOrderRequest> orders = new ArrayList<BillsQueueOrderRequest>();
                orders.add(new BillsQueueOrderRequest(orderMain.getId(), orderMain.getOrderNo()));
                billsQueueRequest.setBillsOrder(orders);
                this.jmsHelper.sendQueuedObjMessage((Serializable)billsQueueRequest, this.billsCreateQueue);
                orderMain.setBillsCreated(Boolean.valueOf(true));
                orderMain.setBillsRequestId(requestId);
                orderMain.setAuditEndTime(new Date());
                this.orderMainService.saveAndFlush(orderMain);
                log.info("orderNo: {}, orgCode: {} ,\u975e\u534f\u8bae\u91c7\u8d2d\u8ba2\u5355\u5ba1\u6838\u901a\u8fc7\u4e8b\u4ef6-\u5df2\u53d1\u9001\u8d26\u5355\u7533\u8bf7MQ\u6d88\u606f", (Object)orderMain.getOrderNo(), (Object)((OrderEvent)event).getOrgCode());
            }
        }
    }

    public int getOrder() {
        return 0;
    }
}

