/*
 * Decompiled with CFR 0.152.
 */
package order.service.events.listener;

import fiance.messages.bills.BillsInvoiceCreateRequest;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import ma.glasnost.orika.MapperFacade;
import order.model.po.OrderMain;
import order.service.events.OrderShippingComfirmedEvent;
import order.service.jms.JmsHelper;
import order.service.service.OrderMainService;
import order.service.stubs.SystemConfigApiStub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.stereotype.Component;
import utils.Lang;

@Component
public class OrderShippingComfirmedEventListener
implements SmartApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(OrderShippingComfirmedEventListener.class);
    private Integer canInsureSpanDays;
    @Value(value="${finance.bills.message.queue.createinvoice:}")
    private String createinvoiceQueue;
    @Autowired
    SystemConfigApiStub systemConfigApi;
    @Autowired
    JmsHelper jmsHelper;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    OrderMainService orderMainService;

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType == OrderShippingComfirmedEvent.class;
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return sourceType == OrderMain.class;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        OrderShippingComfirmedEvent orderEvent = (OrderShippingComfirmedEvent)event;
        OrderMain orderMain = (OrderMain)orderEvent.getSource();
        log.info("\u96c6\u91c7\u76f4\u8d2d\u8ba2\u5355\u786e\u8ba4\u6536\u8d27\u901a\u8fc7\u4e8b\u4ef6\u89e6\u53d1, orderNo: {}, orgCode: {}", (Object)orderMain.getOrderNo(), (Object)orderEvent.getOrgCode());
        if (!Lang.isEmpty((Object)orderMain.getBillsRequestId()) && "jicai".equals(orderEvent.getOrgCode())) {
            BillsInvoiceCreateRequest billsInvoiceCreateRequest = new BillsInvoiceCreateRequest();
            billsInvoiceCreateRequest.setRequestId(orderMain.getBillsRequestId());
            Date shippingComfirmedTime = new Date();
            Calendar shippingComfirmTime = Calendar.getInstance();
            shippingComfirmTime.setTime(shippingComfirmedTime);
            GregorianCalendar caledCalendar = new GregorianCalendar(shippingComfirmTime.get(1), shippingComfirmTime.get(2), shippingComfirmTime.get(5), shippingComfirmTime.get(11), shippingComfirmTime.get(12), 0);
            Integer spanDays = this.getCanInsureSpanDays();
            ((Calendar)caledCalendar).add(5, spanDays == null ? 7 : spanDays);
            billsInvoiceCreateRequest.setCanInvoiceTime(caledCalendar.getTime());
            this.jmsHelper.sendQueuedObjMessage((Serializable)billsInvoiceCreateRequest, this.createinvoiceQueue);
            log.info("\u96c6\u91c7\u76f4\u8d2d\u8ba2\u5355\u786e\u8ba4\u6536\u8d27\u901a\u8fc7\u4e8b\u4ef6, orderNo: {}, orgCode: {}, \u5df2\u53d1\u9001\u53d1\u7968\u7533\u8bf7MQ\u6d88\u606f", (Object)orderMain.getOrderNo(), (Object)orderEvent.getOrgCode());
        }
        this.orderMainService.saveOrder(orderMain, Boolean.valueOf(true));
    }

    public Integer getCanInsureSpanDays() {
        String configValue = this.systemConfigApi.getConfigValue("COMMON", "InvoiceConfigs", "CanInsureSpanDays", Boolean.valueOf(true), Boolean.valueOf(true));
        try {
            this.canInsureSpanDays = Integer.parseInt(configValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.canInsureSpanDays;
    }

    public int getOrder() {
        return 0;
    }
}

