/*
 * Decompiled with CFR 0.152.
 */
package order.service.events.listener;

import cart.api.dto.order.OrderJmsMessage;
import cart.api.dto.order.OrderMainDto;
import ma.glasnost.orika.MapperFacade;
import order.model.po.OrderMain;
import order.service.events.OrderCreateEvent;
import order.service.jms.JmsHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.stereotype.Component;
import store.api.dto.modeldto.core.StoreDto;
import utils.log.Log;
import utils.log.Logs;

@Component
public class ProtocolOrderCreateEventListener
implements SmartApplicationListener {
    Log log = Logs.getLog((String)ProtocolOrderCreateEventListener.class.getName());
    private static final String orgCode = "protocol";
    @Value(value="${activemq.queue.orderEvents:}")
    private String orderEventQueue;
    @Autowired
    JmsHelper jmsHelper;
    @Autowired
    MapperFacade mapperFacade;

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType == OrderCreateEvent.class;
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return sourceType == OrderMain.class;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        OrderCreateEvent orderEvent = (OrderCreateEvent)event;
        OrderMain orderMain = (OrderMain)orderEvent.getSource();
        OrderMainDto orderMainDto = (OrderMainDto)this.mapperFacade.map((Object)orderMain, OrderMainDto.class);
        if (StoreDto.STORE_TYPE_PROTOCOL.equals(orderMain.getStoreType())) {
            this.log.info((Object)"orderNo: {0}, orgCode: {1} ,\u534f\u8bae\u91c7\u8d2d\u8ba2\u5355\u521b\u5efa\u4e8b\u4ef6", new Object[]{orderMain.getOrderNo(), ((OrderCreateEvent)event).getOrgCode()});
            OrderJmsMessage message = OrderJmsMessage.newMessage((OrderMainDto)orderMainDto, (OrderJmsMessage.OrderEvents)OrderJmsMessage.OrderEvents.CREATED);
            this.jmsHelper.sendQueuedMessage((Object)message, this.orderEventQueue);
        } else {
            this.log.info((Object)"orderNo: {0}, orgCode: {1} ,\u975e\u534f\u8bae\u91c7\u8d2d\u8ba2\u5355\u521b\u5efa\u4e8b\u4ef6", new Object[]{orderMain.getOrderNo(), ((OrderCreateEvent)event).getOrgCode()});
        }
    }

    public int getOrder() {
        return 0;
    }
}

