/*
 * Decompiled with CFR 0.152.
 */
package order.service.events.listener;

import cart.api.dto.order.OrderJmsMessage;
import cart.api.dto.order.OrderMainDto;
import ma.glasnost.orika.MapperFacade;
import order.model.po.OrderMain;
import order.service.events.OrderEvent;
import order.service.events.OrderPassedEvent;
import order.service.jms.JmsHelper;
import order.service.service.OrderMainService;
import order.service.service.OrderService;
import order.vo.OrderStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.stereotype.Component;
import store.api.dto.modeldto.core.StoreDto;
import utils.GlobalContants;
import utils.Lang;

@Component
public class ProtocolOrderPassedEventListener
implements SmartApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(ProtocolOrderPassedEventListener.class);
    private static final String orgCode = "protocol";
    @Value(value="${activemq.queue.orderEvents:}")
    private String orderEventQueue;
    @Value(value="${finance.bills.message.queue.billscreate:}")
    private String billsCreateQueue;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    OrderMainService orderMainService;
    @Autowired
    JmsHelper jmsHelper;
    @Autowired
    OrderService orderService;

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType == OrderPassedEvent.class;
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        OrderPassedEvent orderEvent = (OrderPassedEvent)event;
        OrderMain orderMain = (OrderMain)orderEvent.getSource();
        log.info("\u8ba2\u5355\u5ba1\u6838\u901a\u8fc7\u4e8b\u4ef6orderMain\uff1a{}", (Object)orderMain);
        if (!Lang.isEmpty((Object)orderMain)) {
            this.orderMainService.updateOrderAuditEndTime(orderMain.getId());
            if (StoreDto.STORE_TYPE_PROTOCOL.equals(orderMain.getStoreType())) {
                log.info("orderNo: {}, orgCode: {} ,\u534f\u8bae\u91c7\u8d2d\u8ba2\u5355\u5ba1\u6838\u901a\u8fc7\u4e8b\u4ef6", (Object)orderMain.getOrderNo(), (Object)((OrderEvent)event).getOrgCode());
                OrderStatus orderStatus = new OrderStatus();
                orderStatus.setOrderId(orderMain.getId());
                orderStatus.setStatus(GlobalContants.ORDER_STATUS.WAIT_COMFIRM);
                this.orderService.statusChange(orderStatus);
                orderMain.setStatus("15");
                orderMain.setSubOrders(null);
                orderMain.setOrderGifts(null);
                orderMain.setOrderAttrs(null);
                orderMain.setOrderItems(null);
                this.jmsHelper.sendQueuedMessage((Object)OrderJmsMessage.newMessage((OrderMainDto)this.orderMainService.transToDto(orderMain), (OrderJmsMessage.OrderEvents)OrderJmsMessage.OrderEvents.STATUS_CHANGED), this.orderEventQueue);
            }
        }
    }

    public int getOrder() {
        return 0;
    }
}

