/*
 * Decompiled with CFR 0.152.
 */
package order.service.events.listener;

import cart.api.dto.order.OrderJmsMessage;
import cart.api.dto.order.OrderMainDto;
import ma.glasnost.orika.MapperFacade;
import order.model.po.OrderMain;
import order.service.events.OrderEvent;
import order.service.events.OrderStatusChangeEvent;
import order.service.jms.JmsHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.stereotype.Component;
import store.api.dto.modeldto.core.StoreDto;
import utils.log.Log;
import utils.log.Logs;

@Component
public class ProtocolOrderStatusChangeListener
implements SmartApplicationListener {
    Log log = Logs.getLog((String)ProtocolOrderStatusChangeListener.class.getName());
    private static final String orgCode = "protocol";
    @Value(value="${activemq.queue.orderEvents:}")
    private String orderEventQueue;
    @Autowired
    JmsHelper jmsHelper;
    @Autowired
    MapperFacade mapperFacade;

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType == OrderStatusChangeEvent.class;
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return sourceType == OrderMain.class;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        OrderStatusChangeEvent orderEvent = (OrderStatusChangeEvent)event;
        OrderMain orderMain = (OrderMain)orderEvent.getSource();
        OrderMainDto orderMainDto = (OrderMainDto)this.mapperFacade.map((Object)orderMain, OrderMainDto.class);
        if (StoreDto.STORE_TYPE_PROTOCOL.equals(orderMain.getStoreType())) {
            this.log.info((Object)"orderNo: {0}, orgCode: {1} ,\u534f\u8bae\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u6539\u53d8\u4e8b\u4ef6", new Object[]{orderMain.getOrderNo(), ((OrderEvent)event).getOrgCode()});
            this.jmsHelper.sendQueuedMessage((Object)OrderJmsMessage.newMessage((OrderMainDto)orderMainDto, (OrderJmsMessage.OrderEvents)OrderJmsMessage.OrderEvents.STATUS_CHANGED), this.orderEventQueue);
        } else {
            this.log.info((Object)"orderNo: {0}, orgCode: {1} ,\u975e\u534f\u8bae\u91c7\u8d2d\u8ba2\u5355\u8ba2\u5355\u72b6\u6001\u6539\u53d8\u4e8b\u4ef6", new Object[]{orderMain.getOrderNo(), ((OrderEvent)event).getOrgCode()});
        }
    }

    public int getOrder() {
        return 0;
    }
}

