/*
 * Decompiled with CFR 0.152.
 */
package order.service.factory;

import java.util.List;
import order.model.po.OrderTemplateAdapterConfig;
import order.service.factory.BatchOrderTemplateFactory;
import order.service.factory.helper.OrderTemplateSpringBeanHelper;
import order.service.order.templates.BatchOrderTemplate;
import order.service.service.OrderTemplateAdapterConfigService;
import order.vo.OrderTemplateConfigKey;
import order.vo.query.OrderTemplateAdapterConfigQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dbBatchOrderTemplateFactory")
public class DbBatchOrderTemplateFactory
implements BatchOrderTemplateFactory {
    private static final Logger log = LoggerFactory.getLogger(DbBatchOrderTemplateFactory.class);
    @Autowired
    private OrderTemplateAdapterConfigService adapterConfigsService;
    @Autowired
    private OrderTemplateSpringBeanHelper orderTemplateSpringBeanHelper;

    public BatchOrderTemplate getOrderTemplate(OrderTemplateConfigKey orderTemplateKey) {
        OrderTemplateAdapterConfigQuery query = new OrderTemplateAdapterConfigQuery();
        query.setOrgCode(orderTemplateKey.getOrgCode());
        query.setGoodsType(orderTemplateKey.getGoodsType());
        query.setOrderMode(orderTemplateKey.getOrderMode());
        query.setTemplateName(orderTemplateKey.getTemplateName());
        query.setEnabled(Boolean.valueOf(true));
        query.setIsDelete(Boolean.valueOf(false));
        List adapterConfigs = this.adapterConfigsService.query(query);
        if (adapterConfigs != null && adapterConfigs.size() > 0) {
            OrderTemplateAdapterConfig adapterConfig = (OrderTemplateAdapterConfig)adapterConfigs.get(0);
            try {
                BatchOrderTemplate orderTemplate = (BatchOrderTemplate)this.orderTemplateSpringBeanHelper.getOrRegisterBean(adapterConfig.getTemplateName(), adapterConfig.getTemplateClass(), BatchOrderTemplate.class);
                return orderTemplate;
            }
            catch (ClassCastException cce) {
                return null;
            }
        }
        return null;
    }
}

