/*
 * Decompiled with CFR 0.152.
 */
package order.service.factory;

import java.util.List;
import order.model.po.OrderTemplateAdapterConfig;
import order.service.factory.OrderTemplateFactory;
import order.service.factory.helper.OrderTemplateSpringBeanHelper;
import order.service.order.templates.OrderTemplate;
import order.service.service.OrderTemplateAdapterConfigService;
import order.vo.OrderTemplateConfigKey;
import order.vo.query.OrderTemplateAdapterConfigQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import utils.Lang;

@Component(value="dbOrderTemplateFactory")
public class DbOrderTemplateFactory
implements OrderTemplateFactory {
    private static final Logger log = LoggerFactory.getLogger(DbOrderTemplateFactory.class);
    @Autowired
    private OrderTemplateAdapterConfigService adapterConfigsService;
    @Autowired
    private OrderTemplateSpringBeanHelper orderTemplateSpringBeanHelper;

    public OrderTemplate getOrderTemplate(OrderTemplateConfigKey orderTemplateKey) {
        if (Lang.isEmpty((Object)orderTemplateKey.getGoodsType()) && Lang.isEmpty((Object)orderTemplateKey.getOrgCode()) && Lang.isEmpty((Object)orderTemplateKey.getOrderMode())) {
            throw new RuntimeException("orderTemplateKey.goodsType,orderTemplateKey.orgCode,orderTemplateKey.orderMode CANT BE ALL NULL!");
        }
        OrderTemplateAdapterConfigQuery query = new OrderTemplateAdapterConfigQuery();
        query.setOrgCode(orderTemplateKey.getOrgCode());
        query.setGoodsType(orderTemplateKey.getGoodsType());
        query.setOrderMode(orderTemplateKey.getOrderMode());
        query.setTemplateName(orderTemplateKey.getTemplateName());
        query.setEnabled(Boolean.valueOf(true));
        query.setIsDelete(Boolean.valueOf(false));
        List adapterConfigs = this.adapterConfigsService.query(query);
        if (adapterConfigs != null && adapterConfigs.size() > 0) {
            OrderTemplateAdapterConfig adapterConfig = (OrderTemplateAdapterConfig)adapterConfigs.get(0);
            try {
                OrderTemplate orderTemplate = (OrderTemplate)this.orderTemplateSpringBeanHelper.getOrRegisterBean(adapterConfig.getTemplateName(), adapterConfig.getTemplateClass(), OrderTemplate.class);
                return orderTemplate;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("OrderTemplate:" + adapterConfig.getTemplateName() + " is NOT FOUND");
            }
        }
        throw new RuntimeException("OrderTemplateAdapterConfig:" + orderTemplateKey.toString() + " is NOT FOUND");
    }
}

