/*
 * Decompiled with CFR 0.152.
 */
package order.service.jms;

import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Component;
import utils.log.Log;
import utils.log.Logs;

@Component
public class JmsHelper {
    Log log = Logs.getLog((String)JmsHelper.class.getName());
    @Autowired
    JmsTemplate jmsTemplate;

    public void sendQueuedMessage(Object obj, String queueName) {
        this.log.info((Object)"Sending message: {}, to queue[{}]", new Object[]{obj, queueName});
        this.jmsTemplate.convertAndSend(queueName, obj);
    }

    public void sendQueuedObjMessage(Serializable obj, String queueName) {
        this.jmsTemplate.send(queueName, session -> session.createObjectMessage(obj));
    }
}

