/*
 * Decompiled with CFR 0.152.
 */
package order.service.operator.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import member.api.dto.shop.MemberAddressDto;
import order.service.operator.OrderFreightOperator;
import order.service.stubs.MemberAddressApiStub;
import order.service.stubs.OutsideProductApiStub;
import order.vo.TempOrderItemVo;
import order.vo.TempOrderVo;
import order.vo.TempSubOrderVo;
import order.vo.response.OrderFreight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import outsideapi.vo.FashionNumsVo;
import outsideapi.vo.HandlerRespVo;
import outsideapi.vo.ShippingFeeRequetVo;
import utils.Lang;

@Component(value="orderFreightOperator")
public class DefaultOrderFreightOperator
implements OrderFreightOperator {
    private static final Logger log = LoggerFactory.getLogger(DefaultOrderFreightOperator.class);
    public static final String REQUEST_MAP_KEY_STORE_ID = "storeId";
    public static final String REQUEST_MAP_KEY_ORDER_NO = "orderNo";
    public static final String REQUEST_MAP_KEY_REQUEST_DATA = "request";
    @Autowired
    private MemberAddressApiStub memberAddressApi;
    @Autowired
    OutsideProductApiStub outsideProductApi;

    public OrderFreight get(TempOrderVo tempOrderVo) {
        ArrayList requestList = new ArrayList();
        if (tempOrderVo.getSubOrders() != null) {
            ThreadPoolExecutor pool = new ThreadPoolExecutor(0, 3, 10L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            ArrayList<Future<Map>> outsideFreightFutures = new ArrayList<Future<Map>>();
            Object curChild = null;
            Vector tempSubOrders = new Vector();
            for (TempSubOrderVo tempSubOrderVo : tempOrderVo.getSubOrders()) {
                HashMap<String, String> request = new HashMap<String, String>();
                if (tempSubOrderVo.getSubOrders() != null && tempSubOrderVo.getSubOrders().size() > 0) {
                    for (TempSubOrderVo sso : tempSubOrderVo.getSubOrders()) {
                        request.put(REQUEST_MAP_KEY_STORE_ID, tempSubOrderVo.getStoreId());
                        request.put(REQUEST_MAP_KEY_ORDER_NO, sso.getTmpOrderNo());
                        request.put(REQUEST_MAP_KEY_REQUEST_DATA, (String)this.createShippingFeeRequest(sso, tempOrderVo.getMemberAddrId(), tempOrderVo.getAreaCodeList()));
                        requestList.add(request);
                    }
                    continue;
                }
                request.put(REQUEST_MAP_KEY_STORE_ID, tempSubOrderVo.getStoreId());
                request.put(REQUEST_MAP_KEY_ORDER_NO, tempSubOrderVo.getTmpOrderNo());
                request.put(REQUEST_MAP_KEY_REQUEST_DATA, (String)this.createShippingFeeRequest(tempSubOrderVo, tempOrderVo.getMemberAddrId(), tempOrderVo.getAreaCodeList()));
                requestList.add(request);
            }
            for (Map map : requestList) {
                outsideFreightFutures.add(pool.submit(() -> {
                    long queryFashionPriceTime = System.currentTimeMillis();
                    HandlerRespVo outsideApiRes = this.outsideProductApi.queryShippingFee((String)m.get(REQUEST_MAP_KEY_STORE_ID), (ShippingFeeRequetVo)m.get(REQUEST_MAP_KEY_REQUEST_DATA));
                    log.info("\u7b2c\u4e09\u65b9\u8ba2\u5355\u8fd0\u8d39\u67e5\u8be2\uff08\u5355\u4e2a\u7ebf\u7a0b\uff09\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - queryFashionPriceTime));
                    if (HandlerRespVo.RESPONSE_STATUS_SUCCESS.equals(outsideApiRes.getStatus())) {
                        HashMap<String, Object> respMap = new HashMap<String, Object>();
                        respMap.put(REQUEST_MAP_KEY_ORDER_NO, m.get(REQUEST_MAP_KEY_ORDER_NO));
                        respMap.put(REQUEST_MAP_KEY_REQUEST_DATA, outsideApiRes.getData());
                        return respMap;
                    }
                    return null;
                }));
            }
            pool.shutdown();
            OrderFreight orderFreight = new OrderFreight();
            orderFreight.setOrderNo(tempOrderVo.getTmpOrderNo());
            orderFreight.setBaseFreight(new BigDecimal(-1));
            orderFreight.setSubOrderFreights(new ArrayList());
            for (TempSubOrderVo tempSubOrderVo : tempOrderVo.getSubOrders()) {
                OrderFreight sof = new OrderFreight();
                sof.setOrderNo(tempSubOrderVo.getTmpOrderNo());
                sof.setBaseFreight(new BigDecimal(-1));
                if (tempSubOrderVo.getSubOrders() != null && tempSubOrderVo.getSubOrders().size() > 0) {
                    sof.setSubOrderFreights(new ArrayList());
                    for (TempSubOrderVo sso : tempSubOrderVo.getSubOrders()) {
                        OrderFreight ssof = new OrderFreight();
                        ssof.setOrderNo(sso.getTmpOrderNo());
                        ssof.setBaseFreight(new BigDecimal(-1));
                        sof.getSubOrderFreights().add(ssof);
                    }
                }
                orderFreight.getSubOrderFreights().add(sof);
            }
            for (Future future : outsideFreightFutures) {
                try {
                    Map fm = (Map)future.get();
                    String orderNo = (String)fm.get(REQUEST_MAP_KEY_ORDER_NO);
                    Map rsMap = (Map)fm.get(REQUEST_MAP_KEY_REQUEST_DATA);
                    BigDecimal freight = (BigDecimal)rsMap.get("freight");
                    orderFreight.getSubOrderFreights().stream().filter(o -> (o.getSubOrderFreights() == null || o.getSubOrderFreights().size() <= 0) && orderNo.equals(o.getOrderNo())).forEach(o -> o.setBaseFreight(freight));
                    orderFreight.getSubOrderFreights().stream().filter(o -> o.getSubOrderFreights() != null).forEach(i -> {
                        i.getSubOrderFreights().stream().filter(j -> j.getOrderNo().equals(orderNo)).forEach(so -> so.setBaseFreight(freight));
                        i.setBaseFreight(i.getSubOrderFreights().stream().map(OrderFreight::getBaseFreight).reduce(BigDecimal.ZERO, BigDecimal::add));
                    });
                    orderFreight.setBaseFreight(orderFreight.getSubOrderFreights().stream().map(OrderFreight::getBaseFreight).reduce(BigDecimal.ZERO, BigDecimal::add));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            return orderFreight;
        }
        return null;
    }

    public void update(TempOrderVo tempOrderVo) {
        OrderFreight freight = this.get(tempOrderVo);
        tempOrderVo.setSumShippingFee(freight.getBaseFreight());
        freight.getSubOrderFreights().forEach(i -> tempOrderVo.getSubOrders().stream().filter(j -> j.getTmpOrderNo().equals(i.getOrderNo())).forEach(k -> k.setSumShippingFee(i.getBaseFreight())));
        freight.getSubOrderFreights().stream().filter(i -> i.getSubOrderFreights() != null).forEach(i -> i.getSubOrderFreights().forEach(j -> tempOrderVo.getSubOrders().stream().filter(k -> k.getSubOrders() != null).forEach(k -> k.getSubOrders().stream().filter(l -> l.getTmpOrderNo().equals(j.getOrderNo())).forEach(m -> m.setSumShippingFee(j.getBaseFreight())))));
    }

    private ShippingFeeRequetVo createShippingFeeRequest(TempSubOrderVo tempOrderVo, String memberAddrId, List<String> areaCodeList) {
        ShippingFeeRequetVo shippingFeeRequetVo = new ShippingFeeRequetVo();
        ArrayList<FashionNumsVo> fashionNums = new ArrayList<FashionNumsVo>();
        for (TempOrderItemVo itemVo : tempOrderVo.getOrderItems()) {
            FashionNumsVo fashionNumsVo = new FashionNumsVo(itemVo.getProductFashionId(), itemVo.getProductCode(), new Long(itemVo.getCount().intValue()));
            fashionNums.add(fashionNumsVo);
        }
        shippingFeeRequetVo.setFashionNums(fashionNums);
        MemberAddressDto address = null;
        if (!Lang.isEmpty((Object)memberAddrId)) {
            address = this.memberAddressApi.findById(memberAddrId);
        }
        if (address != null && !Lang.isEmpty((Object)address.getId())) {
            shippingFeeRequetVo.setProvinceCode(address.getProvinceCode());
            shippingFeeRequetVo.setCityCode(address.getCityCode());
            shippingFeeRequetVo.setCountyCode(address.getAreaCode());
            shippingFeeRequetVo.setTownCode(address.getTownCode());
            shippingFeeRequetVo.setAddrDetail(address.getAddressDetail());
        } else {
            if (areaCodeList.size() > 0) {
                shippingFeeRequetVo.setProvinceCode(areaCodeList.get(0));
            }
            if (areaCodeList.size() > 1) {
                shippingFeeRequetVo.setCityCode(areaCodeList.get(1));
            }
            if (areaCodeList.size() > 2) {
                shippingFeeRequetVo.setCountyCode(areaCodeList.get(2));
            }
            if (areaCodeList.size() > 3) {
                shippingFeeRequetVo.setTownCode(areaCodeList.get(3));
            }
            shippingFeeRequetVo.setAddrDetail("\u9ed8\u8ba4\u5730\u5740");
        }
        return shippingFeeRequetVo;
    }
}

