/*
 * Decompiled with CFR 0.152.
 */
package order.service.operator.impl;

import goods.vo.SalesPriceCalVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import order.exceptions.IllegalAreaCodeException;
import order.service.operator.OrderFreightOperator;
import order.service.operator.OrderPriceOperator;
import order.service.stubs.OutsideProductApiStub;
import order.service.stubs.ProductFashionApiStub;
import order.service.stubs.SalesPriceRateApiStub;
import order.vo.TempOrderItemVo;
import order.vo.TempOrderVo;
import order.vo.TempSubOrderVo;
import order.vo.response.OrderItemPrice;
import order.vo.response.OrderPrice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import outsideapi.vo.FashionPriceParamVo;
import outsideapi.vo.FashionPriceRequestVo;
import outsideapi.vo.FashionPriceVo;
import outsideapi.vo.HandlerRespVo;

@Component(value="orderPriceOperator")
public class DefaultOrderPriceOperator
implements OrderPriceOperator {
    private static final Logger log = LoggerFactory.getLogger(DefaultOrderPriceOperator.class);
    @Autowired
    ProductFashionApiStub productFashionApi;
    @Autowired
    OutsideProductApiStub outsideProductApi;
    @Autowired
    SalesPriceRateApiStub salesPriceRateApi;
    @Autowired
    OrderFreightOperator orderFreightOperator;

    public OrderPrice get(TempOrderVo tempOrderVo) throws IllegalAreaCodeException {
        FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo(tempOrderVo.getAreaCodeList());
        ThreadPoolExecutor pool = new ThreadPoolExecutor(0, 3, 10L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        Map<String, List<TempOrderItemVo>> storeGroups = tempOrderVo.getOrderItems().stream().collect(Collectors.groupingBy(TempOrderItemVo::getStoreId));
        ArrayList<Future<HandlerRespVo>> outsidePriceFutures = new ArrayList<Future<HandlerRespVo>>();
        for (Map.Entry<String, List<TempOrderItemVo>> entry : storeGroups.entrySet()) {
            fashionPriceRequestVo.setFashionPriceParamVos(new ArrayList());
            for (TempOrderItemVo itemVo : entry.getValue()) {
                FashionPriceParamVo fashionPriceParamVo = new FashionPriceParamVo();
                fashionPriceParamVo.setProductCode(itemVo.getProductCode());
                fashionPriceParamVo.setFactionId(itemVo.getProductFashionId());
                fashionPriceRequestVo.getFashionPriceParamVos().add(fashionPriceParamVo);
            }
            outsidePriceFutures.add(pool.submit(() -> {
                long queryFashionPriceTime = System.currentTimeMillis();
                HandlerRespVo outsideApiRes = this.outsideProductApi.queryFashionPrice((String)entry.getKey(), fashionPriceRequestVo);
                log.info("\u7b2c\u4e09\u65b9\u5b9e\u65f6\u4ef7\u683c\u67e5\u8be2\uff08\u5355\u4e2a\u7ebf\u7a0b\uff09\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - queryFashionPriceTime));
                return outsideApiRes;
            }));
        }
        pool.shutdown();
        long queryFashionPriceTime = System.currentTimeMillis();
        ArrayList allFashionPrices = new ArrayList();
        for (Future future : outsidePriceFutures) {
            try {
                HandlerRespVo frs = (HandlerRespVo)future.get();
                if (!HandlerRespVo.RESPONSE_STATUS_SUCCESS.equals(frs.getStatus()) || frs.getData() == null || ((List)frs.getData()).size() <= 0) continue;
                allFashionPrices.addAll((Collection)frs.getData());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        ArrayList batchSalesPriceCalList = new ArrayList();
        for (FashionPriceVo fp : allFashionPrices) {
            SalesPriceCalVo salesPriceCalVo = new SalesPriceCalVo();
            tempOrderVo.getOrderItems().stream().filter(it -> it.getProductFashionId().equals(fp.getFashionId())).findFirst().ifPresent(oi -> batchSalesPriceCalList.add(new SalesPriceCalVo(fp.getFashionId(), oi.getStoreId(), oi.getStoreCode(), tempOrderVo.getRealOrganizationId(), fp.getSalePrice(), fp.getCostPrice(), fp.getMarketPrice(), fp.getSalePrice(), oi.getCount(), tempOrderVo.getOrganizationCode())));
        }
        long l = System.currentTimeMillis();
        List rateCalRs = this.salesPriceRateApi.calBatchSalesPrice(batchSalesPriceCalList);
        log.info("\u67e5\u8be2\u8d39\u7387\u4ef7\u683c\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - queryFashionPriceTime));
        for (FashionPriceVo fp : allFashionPrices) {
            rateCalRs.stream().filter(it -> fp.getFashionId().equals(it.get("fashionId"))).findFirst().ifPresent(it -> fp.setSalePrice((BigDecimal)it.get("salePrice")));
        }
        OrderPrice orderPrice = new OrderPrice();
        orderPrice.setOrderItemPrices(new ArrayList());
        orderPrice.setFreight(tempOrderVo.getSumShippingFee());
        orderPrice.setOrderNo(tempOrderVo.getTmpOrderNo());
        for (TempOrderItemVo oi2 : tempOrderVo.getOrderItems()) {
            OrderItemPrice oip = new OrderItemPrice(oi2.getCount(), oi2.getProductFashionId());
            Optional<FashionPriceVo> optional = allFashionPrices.stream().filter(i -> i.getFashionId().equals(oi2.getProductFashionId())).findFirst();
            if (optional.isPresent()) {
                FashionPriceVo r = optional.get();
                this.genOrderItemPrice(oip, r);
            } else {
                this.genOrderItemPrice(oip, oi2);
            }
            orderPrice.setSubOrderPrices(this.makeOrderPrice(tempOrderVo.getSubOrders(), allFashionPrices));
            orderPrice.getOrderItemPrices().add(oip);
        }
        orderPrice.recalSumPrices();
        log.info("\u7b2c\u4e09\u65b9\u5b9e\u65f6\u4ef7\u683c\u67e5\u8be2\uff08\u603b\uff09\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - queryFashionPriceTime));
        return orderPrice;
    }

    private OrderItemPrice genOrderItemPrice(OrderItemPrice oip, FashionPriceVo fashionPrice) {
        oip.setCostPrice(fashionPrice.getCostPrice());
        oip.setMarketPrice(fashionPrice.getMarketPrice());
        oip.setSalesPrice(fashionPrice.getSalePrice());
        oip.setSumCostPrice(oip.getCostPrice().multiply(BigDecimal.valueOf(oip.getCount().intValue())));
        oip.setSumSalesPrice(oip.getSalesPrice().multiply(BigDecimal.valueOf(oip.getCount().intValue())));
        oip.setSumMarketPrice(oip.getMarketPrice().multiply(BigDecimal.valueOf(oip.getCount().intValue())));
        return oip;
    }

    private OrderItemPrice genOrderItemPrice(OrderItemPrice oip, TempOrderItemVo tempOrderItem) {
        FashionPriceVo f = new FashionPriceVo();
        f.setCostPrice(tempOrderItem.getCostPrice());
        f.setMarketPrice(tempOrderItem.getMarketPrice());
        f.setSalePrice(tempOrderItem.getSalePrice());
        return this.genOrderItemPrice(oip, f);
    }

    public OrderPrice get(TempSubOrderVo subOrder, List<String> areaNodes) throws IllegalAreaCodeException {
        OrderPrice orderPrice = null;
        FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo(areaNodes);
        fashionPriceRequestVo.setFashionPriceParamVos(new ArrayList());
        for (TempOrderItemVo itemVo : subOrder.getOrderItems()) {
            FashionPriceParamVo fashionPriceParamVo = new FashionPriceParamVo();
            fashionPriceParamVo.setProductCode(itemVo.getProductCode());
            fashionPriceParamVo.setFactionId(itemVo.getProductFashionId());
            fashionPriceRequestVo.getFashionPriceParamVos().add(fashionPriceParamVo);
        }
        HandlerRespVo outsideApiRes = this.outsideProductApi.queryFashionPrice(subOrder.getStoreId(), fashionPriceRequestVo);
        List results = null;
        if (HandlerRespVo.RESPONSE_STATUS_SUCCESS.equals(outsideApiRes.getStatus())) {
            orderPrice = new OrderPrice();
            results = (List)outsideApiRes.getData();
            orderPrice.setFreight(subOrder.getSumShippingFee());
            orderPrice.setOrderItemPrices(new ArrayList());
            for (TempOrderItemVo oi : subOrder.getOrderItems()) {
                OrderItemPrice oip = new OrderItemPrice(oi.getCount(), oi.getProductFashionId());
                Optional<FashionPriceVo> optional = results.stream().filter(i -> i.getFashionId().equals(oi.getProductFashionId())).findFirst();
                if (optional.isPresent()) {
                    FashionPriceVo r = optional.get();
                    this.genOrderItemPrice(oip, r);
                } else {
                    this.genOrderItemPrice(oip, oi);
                }
                orderPrice.getOrderItemPrices().add(oip);
            }
            orderPrice.recalSumPrices();
        }
        return orderPrice;
    }

    private List<OrderPrice> makeOrderPrice(List<TempSubOrderVo> subOrderList, List<FashionPriceVo> allItemPrice) {
        ArrayList<OrderPrice> subOrderPriceList = new ArrayList<OrderPrice>();
        for (TempSubOrderVo subOrderVo : subOrderList) {
            OrderPrice orderPrice = new OrderPrice();
            orderPrice.setOrderNo(subOrderVo.getTmpOrderNo());
            orderPrice.setOrderItemPrices(new ArrayList());
            orderPrice.setFreight(subOrderVo.getSumShippingFee());
            for (TempOrderItemVo oi : subOrderVo.getOrderItems()) {
                OrderItemPrice oip = new OrderItemPrice(oi.getCount(), oi.getProductFashionId());
                Optional<FashionPriceVo> optional = allItemPrice.stream().filter(i -> i.getFashionId().equals(oi.getProductFashionId())).findFirst();
                if (optional.isPresent()) {
                    FashionPriceVo r = optional.get();
                    this.genOrderItemPrice(oip, r);
                } else {
                    this.genOrderItemPrice(oip, oi);
                }
                orderPrice.getOrderItemPrices().add(oip);
            }
            if (subOrderVo.getSubOrders() != null && subOrderVo.getSubOrders().size() > 0) {
                orderPrice.setSubOrderPrices(this.makeOrderPrice(subOrderVo.getSubOrders(), allItemPrice));
            }
            orderPrice.recalSumPrices();
            subOrderPriceList.add(orderPrice);
        }
        return subOrderPriceList;
    }
}

