/*
 * Decompiled with CFR 0.152.
 */
package order.service.operator.impl;

import goods.vo.FashionIdAndCountVo;
import goods.vo.FashionStock;
import goods.vo.FashionStockRequest;
import goods.vo.FashionStockResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import order.exceptions.IllegalAreaCodeException;
import order.service.operator.OrderStockOperator;
import order.service.stubs.ProductFashionApiStub;
import order.vo.TempOrderItemVo;
import order.vo.TempOrderVo;
import order.vo.TempSubOrderVo;
import order.vo.response.OrderItemStock;
import order.vo.response.OrderStock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sinomall.global.common.response.BaseResponse;

@Component(value="orderStockOperator")
public class DefaultOrderStockOperator
implements OrderStockOperator {
    private static final Logger log = LoggerFactory.getLogger(DefaultOrderStockOperator.class);
    @Autowired
    ProductFashionApiStub productFashionApi;

    public OrderStock get(TempOrderVo tempOrderVo) throws IllegalAreaCodeException {
        ArrayList fashionDetailVoList = new ArrayList();
        tempOrderVo.getOrderItems().forEach(it -> fashionDetailVoList.add(new FashionIdAndCountVo(it.getProductFashionId(), it.getCount())));
        OrderStock result = new OrderStock();
        ArrayList<OrderItemStock> mainItemStocks = new ArrayList<OrderItemStock>();
        FashionStockRequest fashionStockRequest = new FashionStockRequest();
        fashionStockRequest.setAreaCode(tempOrderVo.getAreaCode());
        fashionStockRequest.setOrgId(tempOrderVo.getRealOrganizationId());
        fashionStockRequest.setFashionIdAndCountVoList(fashionDetailVoList);
        BaseResponse apiResponse = this.productFashionApi.queryFashionStockStatus(fashionStockRequest);
        boolean noStockFlag = true;
        if (apiResponse.isSuccess()) {
            noStockFlag = noStockFlag && ((FashionStockResult)apiResponse.getResult()).getNoStockFlag() != false;
            for (FashionStock r : ((FashionStockResult)apiResponse.getResult()).getDetails()) {
                mainItemStocks.add(this.genByFashionStock(r));
            }
        } else {
            if ("1001".equals(apiResponse.getResultCode()) || "1002".equals(apiResponse.getResultCode())) {
                throw new IllegalAreaCodeException(apiResponse.getResultMessage());
            }
            if (noStockFlag) {
                // empty if block
            }
            noStockFlag = false;
        }
        result.setItemStocks(mainItemStocks);
        result.setHasNoStock(Boolean.valueOf(noStockFlag));
        if (tempOrderVo.getSubOrders().size() > 1) {
            result.setSubOrderStock(new ArrayList());
            for (TempSubOrderVo o : tempOrderVo.getSubOrders()) {
                result.getSubOrderStock().add(this.makeOrderStock(o, mainItemStocks));
            }
        }
        return result;
    }

    public OrderStock get(TempSubOrderVo tempOrderVo, String areaCode, String organizationalId) throws IllegalAreaCodeException {
        ArrayList fashionDetailVoList = new ArrayList();
        tempOrderVo.getOrderItems().forEach(it -> fashionDetailVoList.add(new FashionIdAndCountVo(it.getProductFashionId(), it.getCount())));
        OrderStock result = new OrderStock();
        ArrayList<OrderItemStock> mainItemStocks = new ArrayList<OrderItemStock>();
        FashionStockRequest fashionStockRequest = new FashionStockRequest();
        fashionStockRequest.setAreaCode(areaCode);
        fashionStockRequest.setOrgId(organizationalId);
        fashionStockRequest.setFashionIdAndCountVoList(fashionDetailVoList);
        BaseResponse apiResponse = this.productFashionApi.queryFashionStockStatus(fashionStockRequest);
        boolean noStockFlag = true;
        if (apiResponse.isSuccess()) {
            noStockFlag = noStockFlag && ((FashionStockResult)apiResponse.getResult()).getNoStockFlag() != false;
            for (FashionStock r : ((FashionStockResult)apiResponse.getResult()).getDetails()) {
                mainItemStocks.add(this.genByFashionStock(r));
            }
        } else {
            if ("1001".equals(apiResponse.getResultCode()) || "1002".equals(apiResponse.getResultCode())) {
                throw new IllegalAreaCodeException(apiResponse.getResultMessage());
            }
            if (noStockFlag) {
                // empty if block
            }
            noStockFlag = false;
        }
        result.setItemStocks(mainItemStocks);
        result.setHasNoStock(Boolean.valueOf(noStockFlag));
        if (tempOrderVo.getSubOrders() != null && tempOrderVo.getSubOrders().size() > 1) {
            result.setSubOrderStock(new ArrayList());
            for (TempSubOrderVo o : tempOrderVo.getSubOrders()) {
                result.getSubOrderStock().add(this.makeOrderStock(o, mainItemStocks));
            }
        }
        return result;
    }

    private OrderStock makeOrderStock(TempSubOrderVo tempSubOrderVo, List<OrderItemStock> orderItemStocks) {
        OrderStock orderStock = new OrderStock();
        orderStock.setItemStocks(new ArrayList());
        orderStock.setSubOrderStock(new ArrayList());
        List orderItemFashionIds = tempSubOrderVo.getOrderItems().stream().map(TempOrderItemVo::getProductFashionId).collect(Collectors.toList());
        List selected = orderItemStocks.stream().filter(ois -> orderItemFashionIds.contains(ois.getFashionId())).collect(Collectors.toList());
        for (OrderItemStock ois2 : selected) {
            orderStock.getItemStocks().add(ois2);
        }
        AtomicBoolean hasStock = new AtomicBoolean(true);
        orderStock.getItemStocks().forEach(is -> hasStock.set(hasStock.get() && is.getOnSale() != false && !"0".equals(is.getStockFlag())));
        orderStock.setHasNoStock(Boolean.valueOf(!hasStock.get()));
        if (tempSubOrderVo.getSubOrders() != null && tempSubOrderVo.getSubOrders().size() > 0) {
            for (TempSubOrderVo so : tempSubOrderVo.getSubOrders()) {
                orderStock.getSubOrderStock().add(this.makeOrderStock(so, orderItemStocks));
            }
        }
        return orderStock;
    }

    private OrderItemStock genByFashionStock(FashionStock fashionStock) {
        OrderItemStock itemStock = new OrderItemStock();
        itemStock.setFashionId(fashionStock.getFashionId());
        itemStock.setStockFlag(fashionStock.getStockFlag());
        itemStock.setStockCount(fashionStock.getStockCount());
        if (0 == fashionStock.getUpdownflag()) {
            itemStock.setOnSale(Boolean.valueOf(false));
            itemStock.setStockFlag("0");
            itemStock.setNotsaleReason("1");
        } else {
            itemStock.setOnSale(fashionStock.getOnSale());
            if (!fashionStock.getOnSale().booleanValue()) {
                itemStock.setNotsaleReason("3");
            }
        }
        return itemStock;
    }
}

