/*
 * Decompiled with CFR 0.152.
 */
package order.service.operator.impl;

import goods.vo.SalesPriceCalVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import order.service.operator.OrgSalesPriceOperator;
import order.service.stubs.SalesPriceRateApiStub;
import order.vo.TempOrderItemVo;
import order.vo.TempOrderVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import utils.Lang;

@Component(value="orgSalesPriceOperator")
public class DefaultOrgSalesPriceOperator
implements OrgSalesPriceOperator {
    private static final Logger log = LoggerFactory.getLogger(DefaultOrgSalesPriceOperator.class);
    @Autowired
    SalesPriceRateApiStub salesPriceRateApi;

    public TempOrderVo updateTempOrder(TempOrderVo tempOrderVo) {
        long methodStartTime = System.currentTimeMillis();
        log.info("### \u5f00\u59cb\u4e3a\u8ba2\u5355\u8ba1\u7b97\u7b2c\u4e09\u65b9\u8d39\u7387\u4ef7\u683c ... ###");
        if (!Lang.isEmpty((Object)tempOrderVo.getOrganizationCode())) {
            long organizationTime = System.currentTimeMillis();
            String organizationId = tempOrderVo.getRealOrganizationId();
            log.info("\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - organizationTime));
            if (organizationId != null) {
                ArrayList<SalesPriceCalVo> salesPriceCalVoList = new ArrayList<SalesPriceCalVo>();
                for (TempOrderItemVo itemVo : tempOrderVo.getOrderItems()) {
                    salesPriceCalVoList.add(new SalesPriceCalVo(itemVo.getProductFashionId(), itemVo.getStoreId(), itemVo.getStoreCode(), organizationId, itemVo.getSalePrice(), itemVo.getCostPrice(), itemVo.getMarketPrice(), itemVo.getCostPrice(), itemVo.getCount(), tempOrderVo.getOrganizationCode()));
                }
                long calBatchSalesPriceTime = System.currentTimeMillis();
                List rateCalRs = this.salesPriceRateApi.calBatchSalesPrice(salesPriceCalVoList);
                log.info("\u6279\u91cf\u8ba1\u7b97\u8d39\u7387\u4ef7\u683c\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - calBatchSalesPriceTime));
                BigDecimal newOrderSalesPrice = new BigDecimal(0);
                BigDecimal newOrderCostPrice = new BigDecimal(0);
                BigDecimal newOrderMarketPrice = new BigDecimal(0);
                for (TempOrderItemVo itemVo : tempOrderVo.getOrderItems()) {
                    Optional<Map> searchRs = rateCalRs.stream().filter(map -> itemVo.getProductFashionId().equals(map.get("fashionId"))).findFirst();
                    if (searchRs.isPresent() && itemVo.getOrginSalePrice() != null && itemVo.getOrginSalePrice().equals(itemVo.getSalePrice())) {
                        Map m = searchRs.get();
                        itemVo.setSalePrice(((BigDecimal)m.get("salePrice")).setScale(2, 0));
                        itemVo.setSalesPriceRate((BigDecimal)m.get("rate"));
                        itemVo.setOrginSalePrice(itemVo.getSalePrice());
                        itemVo.recalateSumPrices();
                    }
                    newOrderSalesPrice = newOrderSalesPrice.add(itemVo.getSumSalePrice());
                    newOrderCostPrice = newOrderCostPrice.add(itemVo.getSumCostPrice());
                    newOrderMarketPrice = newOrderMarketPrice.add(itemVo.getSumMarketPrice());
                }
                tempOrderVo.setSumPrice(newOrderSalesPrice);
                tempOrderVo.setSumOrginalPrice(tempOrderVo.getSumPrice());
                tempOrderVo.setNeedPayPrice(tempOrderVo.getSumPrice().add(tempOrderVo.getSumShippingFee()));
                tempOrderVo.setSumCostPrice(newOrderCostPrice);
                tempOrderVo.setSumMarketPrice(newOrderMarketPrice);
            }
        }
        log.info("### \u4e3a\u8ba2\u5355\u8ba1\u7b97\u7b2c\u4e09\u65b9\u8d39\u7387\u4ef7\u683c\u603b\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - methodStartTime));
        return tempOrderVo;
    }
}

