/*
 * Decompiled with CFR 0.152.
 */
package order.service.order.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberDto;
import order.Contants;
import order.model.po.OrderItem;
import order.model.po.OrderMain;
import order.model.po.OrderMainAttr;
import order.model.po.SubOrder;
import order.model.po.SubOrderItem;
import order.service.events.OrderEvent;
import order.service.events.OrderStatusChangeEvent;
import order.service.operator.OrderPriceOperator;
import order.service.service.query.OrderMainQueryService;
import order.service.stubs.MemberAddressApiStub;
import order.service.stubs.OrganizationApiStub;
import order.service.stubs.OutsideProductApiStub;
import order.service.stubs.SalesPriceRateApiStub;
import order.service.stubs.StoreApiStub;
import order.service.utils.SequenceUtil;
import order.vo.CreateOrderRequest;
import order.vo.OrderAttrVo;
import order.vo.OrderKey;
import order.vo.TempOrderItemVo;
import order.vo.TempSubOrderVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;
import outsideapi.vo.HandlerRespVo;
import outsideapi.vo.jdorder.CSku;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.order.TrdOrderSku;
import store.api.dto.modeldto.core.StoreDto;
import utils.GlobalContants;
import utils.Lang;
import utils.spring.SequenceGenerator;

@Component
public class OrderHelper {
    private static final Logger log = LoggerFactory.getLogger(OrderHelper.class);
    @Value(value="${spring.profiles.active}")
    private String activeEnv;
    @Value(value="${order.orderno.prefix:}")
    private String ORDER_NO_PREFIX;
    @Value(value="${order.orderno.dbkey:}")
    private String ORDER_NO_KEY;
    @Value(value="${order.orderno.size:10}")
    private Integer ORDER_NO_SIZE;
    @Autowired
    private SequenceGenerator sequenceGenerator;
    @Autowired
    SalesPriceRateApiStub salesPriceRateApi;
    @Autowired
    MemberAddressApiStub memberAddressApi;
    @Autowired
    OutsideProductApiStub outsideProductApi;
    @Autowired
    StoreApiStub storeApi;
    @Autowired
    OrderPriceOperator orderPriceOperator;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    OrderMainQueryService orderMainQueryService;
    @Autowired
    OrganizationApiStub organizationApi;
    @Autowired
    SequenceUtil sequenceUtil;
    private static final String ORDER_NO_SEQUENCE_KEY = "ORDER_NO";

    public OrderMain genOrder(CreateOrderRequest request, TempSubOrderVo subOrder, MemberDto memberDto) {
        HandlerRespVo respVo;
        OrderMain order = new OrderMain();
        order.setOrderNo(this.generateOrderNo());
        order.setRealOrganizationId(request.getRealOrganizationId());
        StoreDto storeDto = this.storeApi.getStoreInfo(subOrder.getStoreId());
        MemberAddressDto address = this.memberAddressApi.findById(request.getMemberAddrId());
        order.setAddressId(request.getMemberAddrId());
        order.setMemberId(request.getMemberId());
        order.setOrganizationId(request.getRealOrganizationId());
        order.setSumPrice(subOrder.getNeedPayPrice());
        order.setSumNofreightPrice(subOrder.getSumPrice());
        order.setOrderItems(new ArrayList());
        order.setOrderMode(subOrder.getOrderMode());
        order.setGoodsType(subOrder.getGoodsType());
        if (address != null) {
            order.setRecipientName(address.getUsername());
        }
        if ((respVo = this.outsideProductApi.isOutsideStore(subOrder.getStoreId())).getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS) && ((Boolean)respVo.getData()).booleanValue()) {
            order.setStatus("0");
        } else {
            order.setStatus("1");
        }
        order.setStoreId(storeDto.getId());
        order.setCreateTime(new Date());
        order.setFreight(subOrder.getSumShippingFee());
        order.setFreeFreight(BigDecimal.ZERO);
        order.reCalSumPrice();
        order.setUsageCode(request.getUsageCode());
        if (order.getRealOrganizationId() == null) {
            order.setRealOrganizationId(order.getOrganizationId());
        }
        order.setStoreType(storeDto.getStoreExt().getType());
        order.setStoreName(storeDto.getStoreExt().getStoreName());
        order.setStoreCode(storeDto.getStoreExt().getCode());
        order.setPayMethod(request.getPaymentCode());
        order.setOrderAttrs(new ArrayList());
        if (request.getOrderAttrs() != null) {
            for (OrderAttrVo attrVo : request.getOrderAttrs()) {
                OrderMainAttr orderMainAttr = new OrderMainAttr();
                orderMainAttr.setOrder(order);
                orderMainAttr.setAttrName(attrVo.getAttrName());
                orderMainAttr.setAttrValue(attrVo.getAttrValue());
                orderMainAttr.setType(Lang.isEmpty((Object)attrVo.getType()) ? "JSON_LIST" : attrVo.getType());
                order.getOrderAttrs().add(orderMainAttr);
            }
        }
        order.setOrderItems(this.genOrderItems(subOrder, order, address));
        order.setBuyType(request.getBuyType());
        order.setHeadMessage(request.getHeadMessage());
        order.setBrowserType(request.getBrowserType());
        order.setPlatformType(request.getPlatformType());
        order.setRequestId(request.getRequestId());
        log.info("tempOrderVo.getRequestId{}", (Object)request.getRequestId());
        order.setPostDesc(JSONObject.toJSONString((Object)request));
        if (Lang.isEmpty((Object)request.getRequestId())) {
            order.setRequestId(request.getTmpOrderNo());
        }
        return order;
    }

    public List<OrderItem> genOrderItems(TempSubOrderVo subOrder, OrderMain order, MemberAddressDto memberAddress) {
        int totalCounts = 0;
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
        for (TempOrderItemVo c : subOrder.getOrderItems()) {
            ++totalCounts;
            OrderItem orderItem = this.generateOrderItem(c);
            if (c.getChildren() != null && c.getChildren().size() > 0) {
                ArrayList<OrderItem> childOrderItemList = new ArrayList<OrderItem>();
                for (TempOrderItemVo cc : c.getChildren()) {
                    OrderItem childOrderItem = this.generateOrderItem(cc);
                    childOrderItem.setParent(orderItem);
                    childOrderItemList.add(childOrderItem);
                }
                orderItem.setChildren(childOrderItemList);
            }
            orderItem.setOrder(order);
            orderItems.add(orderItem);
        }
        return orderItems;
    }

    public String generateOrderNo() {
        try {
            return this.sequenceUtil.getOrderNo(ORDER_NO_SEQUENCE_KEY);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("\u751f\u6210\u8ba2\u5355\u53f7\u5931\u8d25");
        }
    }

    private OrderItem generateOrderItem(TempOrderItemVo tempOrderItemVo) {
        OrderItem orderItem = new OrderItem();
        orderItem.setCount(tempOrderItemVo.getCount());
        orderItem.setProductName(tempOrderItemVo.getFashionTitle());
        orderItem.setCostPrice(tempOrderItemVo.getCostPrice());
        orderItem.setSalePrice(tempOrderItemVo.getSalePrice());
        orderItem.setOrginSalePrice(tempOrderItemVo.getOrginSalePrice());
        orderItem.setProductPrice(tempOrderItemVo.getMarketPrice());
        orderItem.setMemberPrice(orderItem.getSalePrice());
        orderItem.setFinalPrice(tempOrderItemVo.getSalePrice());
        orderItem.setSeckillPrice(tempOrderItemVo.getSalePrice());
        orderItem.setActivityId(tempOrderItemVo.getActivityId());
        orderItem.setGoodsId(tempOrderItemVo.getGoodsId());
        orderItem.setProductFashId(tempOrderItemVo.getProductFashionId());
        orderItem.setProductId(tempOrderItemVo.getProductId());
        orderItem.setSku(tempOrderItemVo.getProductCode());
        orderItem.setSalePriceRate(tempOrderItemVo.getSalesPriceRate());
        orderItem.setProductType(tempOrderItemVo.getProductType());
        orderItem.setProductPic(tempOrderItemVo.getFashionPic());
        orderItem.setBusinessCode(tempOrderItemVo.getBusinessCode());
        return orderItem;
    }

    public void publishOrderEvent(OrderEvent orderEvent) {
        this.applicationContext.publishEvent((ApplicationEvent)orderEvent);
    }

    public void publishOrderStatusChangeEvent(OrderKey orderKey, String operator) {
        OrderMain orderMain = !Lang.isEmpty((Object)orderKey.getOrderId()) ? this.orderMainQueryService.getOrder(orderKey.getOrderId()) : this.orderMainQueryService.findByOrderNo(orderKey.getOrderNo());
        if (orderMain != null) {
            String orgCode = this.organizationApi.findOrganizationCodeById(orderMain.getOrganizationId());
            this.publishOrderEvent((OrderEvent)new OrderStatusChangeEvent((Object)orderMain, orgCode, Lang.isEmpty((Object)operator) ? Contants.ORDER_OPERATOR_SYSTEM : operator));
        }
    }

    public void publishOrderStatusChangeEvent(OrderKey orderKey, GlobalContants.ORDER_STATUS status, String operator) {
        OrderMain orderMain = this.orderMainQueryService.findByKey(orderKey);
        if (orderMain != null) {
            String orgCode = this.organizationApi.findOrganizationCodeById(orderMain.getOrganizationId());
            if (status == null || !orderMain.getStatus().equals(status.getValue())) {
                this.publishOrderEvent((OrderEvent)new OrderStatusChangeEvent((Object)orderMain, orgCode, Lang.isEmpty((Object)operator) ? Contants.ORDER_OPERATOR_SYSTEM : operator));
            }
        }
    }

    public static SubOrder toSubOrder(TrdOrder trdOrder, OrderMain order) {
        SubOrder subOrder = new SubOrder();
        subOrder.setOrder(order);
        subOrder.setSubOrderNo(trdOrder.getTrdOrderNo());
        subOrder.setTrdSpState("" + trdOrder.getState());
        subOrder.setTrdOrderState("" + trdOrder.getOrderstate());
        subOrder.setTrdSubmitState("" + trdOrder.getSubmitstate());
        List cskus = trdOrder.getSku();
        ArrayList<SubOrderItem> subOrderItems = new ArrayList<SubOrderItem>();
        BigDecimal sumCostPrice = BigDecimal.ZERO;
        for (TrdOrderSku cSku : cskus) {
            SubOrderItem subOrderItem = new SubOrderItem();
            subOrderItem.setCount(Integer.valueOf(cSku.getNum()));
            subOrderItem.setOrder(order);
            order.getOrderItems().stream().filter(it -> it.getSku().equals(cSku.getSkuId())).findFirst().ifPresent(it -> subOrderItem.setOrderItem(it));
            subOrderItem.setSubOrder(subOrder);
            if (!Lang.isEmpty((Object)cSku.getType())) {
                subOrderItem.setType(Integer.valueOf(cSku.getType()));
                if (cSku.getType() == CSku.TYPE_GENERAL.toString()) {
                    sumCostPrice = sumCostPrice.add(subOrderItem.getOrderItem().getCostPrice().multiply(BigDecimal.valueOf(cSku.getNum())));
                }
            }
            subOrderItem.setPrice(cSku.getPrice());
            subOrderItem.setName(cSku.getName());
            subOrderItem.setTaxPrice(cSku.getTaxPrice());
            subOrderItem.setSkuId(cSku.getSkuId());
            subOrderItem.setNakedPrice(cSku.getTaxPrice());
            subOrderItems.add(subOrderItem);
        }
        subOrder.setFreight(trdOrder.getFreight());
        subOrder.setSumCostPrice(sumCostPrice);
        subOrder.setSubOrderItems(subOrderItems);
        return subOrder;
    }
}

