/*
 * Decompiled with CFR 0.152.
 */
package order.service.order.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import order.service.stubs.SalesPriceRateApiStub;
import order.vo.OrderSumItemPrices;
import order.vo.TempOrderItemVo;
import order.vo.TempOrderVo;
import order.vo.TempSubOrderVo;
import order.vo.response.OrderItemPrice;
import order.vo.response.OrderPrice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import utils.Lang;
import utils.lang.Copys;
import utils.spring.SequenceGenerator;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TempOrderHelper {
    private static final Logger log = LoggerFactory.getLogger(TempOrderHelper.class);
    @Value(value="${spring.profiles.active}")
    private String activeEnv;
    @Value(value="${order.temporderno.prefix:}")
    private String TEMP_ORDER_NO_PREFIX;
    @Value(value="${order.temporderno.dbkey:}")
    private String TEMP_ORDER_NO_KEY;
    @Value(value="${order.temporderno.size:10}")
    private Integer TEMP_ORDER_NO_SIZE;
    @Autowired
    private SequenceGenerator sequenceGenerator;
    @Autowired
    SalesPriceRateApiStub salesPriceRateApi;

    public TempOrderVo combime(List<TempOrderVo> tempOrderVoList) {
        if (tempOrderVoList != null && !tempOrderVoList.isEmpty()) {
            if (tempOrderVoList.size() > 1) {
                Map<String, List<TempSubOrderVo>> groupedByStoreOrders = tempOrderVoList.stream().flatMap(o -> o.getSubOrders().stream()).collect(Collectors.groupingBy(TempSubOrderVo::getStoreId));
                TempOrderVo tempOrderVo = new TempOrderVo();
                Copys copys = Copys.create();
                copys.from((Object)tempOrderVoList.get(0)).excludes(new String[]{"orderItems", "subOrders", "tmpOrderGifts", "orderAttrs", "orderCouponVos", "tempInvoiceVos"}).to(new Object[]{tempOrderVo});
                tempOrderVo.setTmpOrderNo(this.genTempOrderNo());
                ArrayList<TempSubOrderVo> subOrderVoList = new ArrayList<TempSubOrderVo>();
                ArrayList combimedOrderItems = new ArrayList();
                for (Map.Entry<String, List<TempSubOrderVo>> e : groupedByStoreOrders.entrySet()) {
                    List<TempSubOrderVo> tempSubOrderList = e.getValue();
                    if (tempSubOrderList == null || tempSubOrderList.size() <= 0) continue;
                    for (TempSubOrderVo subOrderVo : e.getValue()) {
                        combimedOrderItems.addAll(subOrderVo.getOrderItems());
                    }
                    TempSubOrderVo tempStoreOrder = new TempSubOrderVo();
                    Copys copys2 = Copys.create();
                    copys.from((Object)tempSubOrderList.get(0)).excludes(new String[]{"orderItems", "subOrders", "tmpOrderGifts", "orderAttrs", "orderCouponVos", "tempInvoiceVos"}).to(new Object[]{tempStoreOrder});
                    tempStoreOrder.setTmpOrderNo(this.genTempOrderNo());
                    tempSubOrderList.forEach(it -> it.setPOrderNo(tempStoreOrder.getTmpOrderNo()));
                    tempStoreOrder.setSubOrders(tempSubOrderList);
                    tempStoreOrder.setOrderItems(tempSubOrderList.stream().flatMap(o -> o.getOrderItems().stream()).collect(Collectors.toList()));
                    OrderSumItemPrices orderSumItemPrices = TempOrderHelper.calculateSumItemPrices((List)tempStoreOrder.getOrderItems());
                    tempStoreOrder.setSumPrice(orderSumItemPrices.getSumPrice());
                    tempStoreOrder.setSumOrginalPrice(orderSumItemPrices.getSumOrginalPrice());
                    tempStoreOrder.setSumCostPrice(orderSumItemPrices.getSumCostPrice());
                    tempStoreOrder.setSumMarketPrice(orderSumItemPrices.getSumMarketPrice());
                    tempStoreOrder.setPOrderNo(tempOrderVo.getTmpOrderNo());
                    subOrderVoList.add(tempStoreOrder);
                }
                tempOrderVo.setOrderItems(combimedOrderItems);
                OrderSumItemPrices orderSumItemPrices = TempOrderHelper.calculateSumItemPrices(combimedOrderItems);
                tempOrderVo.setSumPrice(orderSumItemPrices.getSumPrice());
                tempOrderVo.setSumOrginalPrice(orderSumItemPrices.getSumOrginalPrice());
                tempOrderVo.setSumCostPrice(orderSumItemPrices.getSumCostPrice());
                tempOrderVo.setSumMarketPrice(orderSumItemPrices.getSumMarketPrice());
                tempOrderVo.setSubOrders(subOrderVoList);
            } else {
                return tempOrderVoList.get(0);
            }
        }
        return null;
    }

    public static void updateOrderItemPrice(TempOrderVo tempOrderVo, Predicate<? super TempOrderItemVo> filter, BigDecimal newSalesPirce) {
        tempOrderVo.getOrderItems().stream().filter(filter).forEach(oi -> {
            oi.setSalePrice(newSalesPirce);
            oi.recalateSumPrices();
        });
        if (tempOrderVo.getSubOrders() != null && tempOrderVo.getSubOrders().size() > 0) {
            TempOrderHelper.updateOrderItemPrice((List)tempOrderVo.getSubOrders(), filter, (BigDecimal)newSalesPirce);
        }
        OrderSumItemPrices orderSumItemPrices = TempOrderHelper.calculateSumItemPrices((List)tempOrderVo.getOrderItems());
        tempOrderVo.setSumPrice(orderSumItemPrices.getSumPrice());
        tempOrderVo.setSumOrginalPrice(orderSumItemPrices.getSumOrginalPrice());
        tempOrderVo.setSumCostPrice(orderSumItemPrices.getSumCostPrice());
        tempOrderVo.setSumMarketPrice(orderSumItemPrices.getSumMarketPrice());
    }

    public static void updateOrderItemPrice(List<TempSubOrderVo> subOrderVoList, Predicate<? super TempOrderItemVo> filter, BigDecimal newSalesPrice) {
        for (TempSubOrderVo tso : subOrderVoList) {
            tso.getOrderItems().stream().filter(filter).forEach(oi -> {
                oi.setSalePrice(newSalesPrice);
                oi.recalateSumPrices();
            });
            if (tso.getSubOrders() != null && tso.getSubOrders().size() > 0) {
                TempOrderHelper.updateOrderItemPrice((List)tso.getSubOrders(), filter, (BigDecimal)newSalesPrice);
            }
            OrderSumItemPrices orderSumItemPrices = TempOrderHelper.calculateSumItemPrices((List)tso.getOrderItems());
            tso.setSumPrice(orderSumItemPrices.getSumPrice());
            tso.setSumOrginalPrice(orderSumItemPrices.getSumOrginalPrice());
            tso.setSumCostPrice(orderSumItemPrices.getSumCostPrice());
            tso.setSumMarketPrice(orderSumItemPrices.getSumMarketPrice());
        }
    }

    public static List<TempOrderItemVo> findItemInSubOrders(List<TempSubOrderVo> subOrderVos, Predicate<? super TempOrderItemVo> filter) {
        ArrayList<TempOrderItemVo> result = new ArrayList<TempOrderItemVo>();
        subOrderVos.forEach(i -> {
            result.addAll(i.getOrderItems().stream().filter(filter).collect(Collectors.toList()));
            if (i.getSubOrders() != null && i.getSubOrders().size() > 0) {
                result.addAll(TempOrderHelper.findItemInSubOrders((List)i.getSubOrders(), (Predicate)filter));
            }
        });
        return result;
    }

    public static OrderSumItemPrices calculateSumItemPrices(List<TempOrderItemVo> tempOrderItemList) {
        OrderSumItemPrices orderSumItemPrices = new OrderSumItemPrices();
        BigDecimal orderSumPrice = new BigDecimal(0);
        BigDecimal orderSumCostPrice = new BigDecimal(0);
        BigDecimal orderSumMarketPrice = new BigDecimal(0);
        for (TempOrderItemVo orderItem : tempOrderItemList) {
            orderSumPrice = orderItem.getSumSalePrice() == null || orderItem.getSumSalePrice().equals(BigDecimal.ZERO) ? orderSumPrice.add(orderItem.getSalePrice().multiply(BigDecimal.valueOf(orderItem.getCount().intValue()))) : orderSumPrice.add(orderItem.getSumSalePrice());
            orderSumCostPrice = orderItem.getSumCostPrice() == null || orderItem.getSumCostPrice().equals(BigDecimal.ZERO) ? orderSumCostPrice.add(orderItem.getCostPrice().multiply(BigDecimal.valueOf(orderItem.getCount().intValue()))) : orderSumCostPrice.add(orderItem.getSumCostPrice());
            if (orderItem.getSumMarketPrice() == null || orderItem.getSumMarketPrice().equals(BigDecimal.ZERO)) {
                orderSumMarketPrice = orderSumMarketPrice.add(orderItem.getMarketPrice().multiply(BigDecimal.valueOf(orderItem.getCount().intValue())));
                continue;
            }
            orderSumMarketPrice = orderSumMarketPrice.add(orderItem.getSumMarketPrice());
        }
        orderSumItemPrices.setSumPrice(orderSumPrice);
        orderSumItemPrices.setSumOrginalPrice(orderSumPrice);
        orderSumItemPrices.setSumCostPrice(orderSumCostPrice);
        orderSumItemPrices.setSumMarketPrice(orderSumMarketPrice);
        return orderSumItemPrices;
    }

    public String genTempOrderNo() {
        int fullYear = Calendar.getInstance().get(1);
        String envPrefix = this.getEnvPrefix();
        return this.TEMP_ORDER_NO_PREFIX + (envPrefix == null ? "" : envPrefix) + fullYear + this.sequenceGenerator.generateSequence(this.TEMP_ORDER_NO_KEY, this.TEMP_ORDER_NO_SIZE.intValue());
    }

    private String getEnvPrefix() {
        String envStr = "";
        if (!Lang.isEmpty((Object)this.activeEnv)) {
            String[] envArr;
            for (String env : envArr = this.activeEnv.split(",")) {
                if (env.equals("adaptive")) continue;
                envStr = env;
                break;
            }
        }
        return envStr;
    }

    public static List<TempSubOrderVo> flatSubOrders(TempOrderVo tempOrderVo) {
        ArrayList<TempSubOrderVo> flat = new ArrayList<TempSubOrderVo>();
        tempOrderVo.getSubOrders().forEach(it -> {
            if (it.getSubOrders() != null && it.getSubOrders().size() > 0) {
                flat.addAll(TempOrderHelper.flatSubOrders((TempSubOrderVo)it));
            } else {
                flat.add((TempSubOrderVo)it);
            }
        });
        return flat;
    }

    public static List<TempSubOrderVo> flatSubOrders(TempSubOrderVo tempOrderVo) {
        ArrayList<TempSubOrderVo> flat = new ArrayList<TempSubOrderVo>();
        tempOrderVo.getSubOrders().forEach(it -> {
            if (it.getSubOrders() != null && it.getSubOrders().size() > 0) {
                it.getSubOrders().forEach(sso -> flat.addAll(TempOrderHelper.flatSubOrders((TempSubOrderVo)sso)));
            } else {
                flat.add((TempSubOrderVo)it);
            }
        });
        return flat;
    }

    public static void updateTempOrderPrices(TempOrderVo tempOrderVo, OrderPrice orderPrice) {
        List flatSubOrders = TempOrderHelper.flatSubOrders((TempOrderVo)tempOrderVo);
        for (TempSubOrderVo subOrder : flatSubOrders) {
            OrderPrice fp = orderPrice.findChildFirst(subOrder.getTmpOrderNo());
            if (fp == null) continue;
            for (OrderItemPrice oip2 : fp.getOrderItemPrices()) {
                subOrder.getOrderItems().stream().filter(i -> i.getProductFashionId().equals(oip2.getFashionId())).forEach(i -> {
                    i.setCostPrice(oip2.getCostPrice());
                    i.setSalePrice(oip2.getSalesPrice());
                    i.setMarketPrice(oip2.getMarketPrice());
                    i.setOrginSalePrice(i.getSalePrice());
                    i.recalateSumPrices();
                });
                subOrder.recalatePrices();
            }
        }
        orderPrice.getOrderItemPrices().forEach(oip -> tempOrderVo.getOrderItems().stream().filter(i -> i.getProductFashionId().equals(oip.getFashionId())).forEach(i -> {
            i.setCostPrice(oip.getCostPrice());
            i.setSalePrice(oip.getSalesPrice());
            i.setMarketPrice(oip.getMarketPrice());
            i.setOrginSalePrice(i.getSalePrice());
            i.recalateSumPrices();
        }));
        tempOrderVo.recalatePrices();
    }
}

