/*
 * Decompiled with CFR 0.152.
 */
package order.service.order.templates;

import activities.dto.goods.GoodsDto;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import goods.dto.product.ProductFashionDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ma.glasnost.orika.metadata.Type;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberDto;
import order.Contants;
import order.exceptions.IllegalAreaCodeException;
import order.exceptions.NoStockException;
import order.exceptions.OrderCreateException;
import order.exceptions.temporder.TempOrderCreateException;
import order.model.po.OrderItem;
import order.model.po.OrderMain;
import order.service.operator.OrderPriceOperator;
import order.service.operator.OrderStockOperator;
import order.service.order.helper.OrderHelper;
import order.service.order.helper.TempOrderHelper;
import order.service.order.templates.OrderTemplateAdapter;
import order.service.service.OrderMainService;
import order.service.service.PaymentConfigService;
import order.service.service.PaymentService;
import order.service.service.query.OrderMainQueryService;
import order.service.stubs.ActivityGoodsApiStub;
import order.service.stubs.BiddingMainApiStub;
import order.service.stubs.CoreCompDepartUserApiStub;
import order.service.stubs.CoreCompanyApiStub;
import order.service.stubs.MemberAddressApiStub;
import order.service.stubs.MemberApiStub;
import order.service.stubs.OrganizationApiStub;
import order.service.stubs.OutsideProductApiStub;
import order.service.stubs.ProductFashionApiStub;
import order.service.stubs.SupplierOrderApiStub;
import order.service.stubs.SystemLogApiStub;
import order.vo.CancelOrderDetailResp;
import order.vo.CancelOrderResp;
import order.vo.CreateOrderRequest;
import order.vo.GoodsInfoVo;
import order.vo.OrderKey;
import order.vo.OrderPayConfirmResp;
import order.vo.OrderSumItemPrices;
import order.vo.OrderVo;
import order.vo.TempOrderCreateRequest;
import order.vo.TempOrderItemVo;
import order.vo.TempOrderVo;
import order.vo.TempSubOrderVo;
import order.vo.response.OrderAuditingResult;
import order.vo.response.OrderPrice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.exceptions.OrderCancelException;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierOrderComfirmFalidException;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.order.TrdOrderKey;
import outsideapi.vo.orderrequest.OrderRequst;
import payment.model.po.Payment;
import sinomall.global.common.response.BaseResponse;
import sysmg.dto.SystemLogDto;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.web.UserAgent;
import utils.web.UserAgentUtil;

public abstract class MallDefaultOrderTemplate
extends OrderTemplateAdapter {
    private static final Logger log = LoggerFactory.getLogger(MallDefaultOrderTemplate.class);
    private static final String PHONE_REG = "\\b(ip(hone|od)|android|opera m(ob|in)i|windows (phone|ce)|blackberry|s(ymbian|eries60|amsung)|p(laybook|alm|rofile/midp|laystation portable)|nokia|fennec|htc[-_]|mobile|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b";
    private static final String TABLE_REG = "\\b(ipad|tablet|(Nexus 7)|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b";
    private static Pattern phonePat = Pattern.compile("\\b(ip(hone|od)|android|opera m(ob|in)i|windows (phone|ce)|blackberry|s(ymbian|eries60|amsung)|p(laybook|alm|rofile/midp|laystation portable)|nokia|fennec|htc[-_]|mobile|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b", 2);
    private static Pattern tablePat = Pattern.compile("\\b(ipad|tablet|(Nexus 7)|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b", 2);
    @Autowired
    SupplierOrderApiStub supplierOrderApi;
    @Autowired
    OutsideProductApiStub outsideProductApi;
    @Autowired
    TempOrderHelper tempOrderHelper;
    @Autowired
    ProductFashionApiStub productFashionApi;
    @Autowired
    OrderStockOperator orderStockOperator;
    @Autowired
    MemberApiStub memberApi;
    @Autowired
    OrganizationApiStub organizationApi;
    @Autowired
    CoreCompDepartUserApiStub coreCompDepartUserApi;
    @Autowired
    CoreCompanyApiStub coreCompanyApi;
    @Autowired
    OrderHelper orderHelper;
    @Autowired
    PaymentConfigService paymentConfigService;
    @Autowired
    PaymentService paymentService;
    @Autowired
    MemberAddressApiStub MemberAddressApi;
    @Autowired
    SystemLogApiStub systemLogApi;
    @Autowired
    OrderMainService orderMainService;
    @Autowired
    OrderMainQueryService orderMainQueryService;
    @Autowired
    BiddingMainApiStub biddingMainApi;
    @Autowired
    ActivityGoodsApiStub activityGoodsApi;
    @Autowired
    OrderPriceOperator orderPriceOperator;

    public BaseResponse<Boolean> orderPreCheck(TempOrderVo tempOrderVo) {
        BaseResponse response = super.orderPreCheck(tempOrderVo);
        ArrayList skus = new ArrayList();
        tempOrderVo.getOrderItems().forEach(oi -> skus.add(oi.getSku()));
        Boolean isExitsResult = this.biddingMainApi.findTempOrderBySkus(skus);
        String realOrganizationCode = tempOrderVo.getOrganizationCode() == null ? "jicai" : tempOrderVo.getOrganizationCode();
        Vector goodsVector = new Vector();
        tempOrderVo.getOrderItems().stream().filter(it -> !Lang.isEmpty((Object)it.getGoodsId())).forEach(it -> {
            GoodsDto goodsDto = new GoodsDto();
            goodsDto.setId(it.getGoodsId());
            goodsVector.add(goodsDto);
        });
        List activityPriceBatch = this.activityGoodsApi.isActivityGoodsAndGetActivityPriceBatch(goodsVector, realOrganizationCode);
        try {
            OrderPrice orderPrice = this.orderPriceOperator.get(tempOrderVo);
            Vector errorSkus = new Vector();
            orderPrice.getOrderItemPrices().forEach(oip -> {
                Optional<Map> activityPriceOpt;
                boolean isAct = false;
                Optional<TempOrderItemVo> itemOpt = tempOrderVo.getOrderItems().stream().filter(oi -> oi.getProductFashionId().equals(oip.getFashionId())).findFirst();
                if (itemOpt.isPresent() && activityPriceBatch != null && (activityPriceOpt = activityPriceBatch.stream().filter(m -> ((TempOrderItemVo)itemOpt.get()).getGoodsId().equals(m.get("goodsId"))).findFirst()).isPresent()) {
                    isAct = (Boolean)activityPriceOpt.get().get("isActivityGoods");
                    if (!isExitsResult.booleanValue() && !isAct && oip.getSalesPrice().compareTo(oip.getCostPrice()) < 0) {
                        errorSkus.add(itemOpt.get().getSku());
                    }
                }
            });
            if (errorSkus.size() > 0) {
                response.setSuccess(true);
                response.setResultCode(Contants.ORDER_PRECHECK_RESP_CODES.SALES_PRICE_TOO_LOW.getValue());
                response.setResultMessage(Contants.ORDER_PRECHECK_RESP_CODES.SALES_PRICE_TOO_LOW.getMessage().replace("[]", "[" + Joiner.on((String)",").join(errorSkus) + "]"));
                response.setResult((Object)false);
            }
        }
        catch (IllegalAreaCodeException e) {
            response.setSuccess(false);
            response.setResultCode(Contants.ORDER_PRECHECK_RESP_CODES.SALES_PRICE_QUERY_ERROR.getValue());
            response.setResultMessage(Contants.ORDER_PRECHECK_RESP_CODES.SALES_PRICE_QUERY_ERROR.getMessage() + ", " + e.getMessage());
            response.setResult((Object)false);
            e.printStackTrace();
        }
        return super.orderPreCheck(tempOrderVo);
    }

    public TempOrderVo createTempOrder(TempOrderCreateRequest tempOrderCreateRequest) throws TempOrderCreateException {
        tempOrderCreateRequest.getGoodsInfoVos();
        TempOrderVo tempOrderVo = (TempOrderVo)BeanMapper.map((Object)tempOrderCreateRequest, TempOrderVo.class);
        tempOrderVo.setTmpOrderNo(this.tempOrderHelper.genTempOrderNo());
        tempOrderVo.setOrderItems(new ArrayList());
        String[] areaCodeArray = new String[]{null, null, null, null};
        if (!Lang.isEmpty((Object)tempOrderCreateRequest.getTownCode())) {
            tempOrderVo.setAreaCode(tempOrderCreateRequest.getTownCode());
            areaCodeArray[3] = tempOrderCreateRequest.getTownCode();
        }
        if (!Lang.isEmpty((Object)tempOrderCreateRequest.getCountyCode())) {
            if (Lang.isEmpty((Object)tempOrderVo.getAreaCode())) {
                tempOrderVo.setAreaCode(tempOrderCreateRequest.getCountyCode());
            }
            areaCodeArray[2] = tempOrderCreateRequest.getCountyCode();
        }
        if (!Lang.isEmpty((Object)tempOrderCreateRequest.getCityCode())) {
            if (Lang.isEmpty((Object)tempOrderVo.getAreaCode())) {
                tempOrderVo.setAreaCode(tempOrderCreateRequest.getCityCode());
            }
            areaCodeArray[1] = tempOrderCreateRequest.getCityCode();
        }
        if (!Lang.isEmpty((Object)tempOrderCreateRequest.getProvinceCode())) {
            if (Lang.isEmpty((Object)tempOrderVo.getAreaCode())) {
                tempOrderVo.setAreaCode(tempOrderCreateRequest.getProvinceCode());
            }
            areaCodeArray[0] = tempOrderCreateRequest.getProvinceCode();
        }
        tempOrderVo.setAreaCodeList(Arrays.asList(areaCodeArray));
        List productFashionDtos = this.productFashionApi.findByIds(tempOrderCreateRequest.getGoodsInfoVos().stream().map(GoodsInfoVo::getProductFashionId).collect(Collectors.toList()));
        Map productFashionDtoMap = productFashionDtos.stream().collect(Collectors.toMap(ProductFashionDto::getId, Function.identity()));
        for (GoodsInfoVo goodsInfoVo : tempOrderCreateRequest.getGoodsInfoVos()) {
            ProductFashionDto productFashion = (ProductFashionDto)productFashionDtoMap.get(goodsInfoVo.getProductFashionId());
            TempOrderItemVo tempOrderItemVo = this.createTempOrderItem(goodsInfoVo, productFashion);
            tempOrderVo.getOrderItems().add(tempOrderItemVo);
        }
        OrderSumItemPrices orderSumItemPrices = TempOrderHelper.calculateSumItemPrices((List)tempOrderVo.getOrderItems());
        tempOrderVo.setSumPrice(orderSumItemPrices.getSumPrice());
        tempOrderVo.setSumOrginalPrice(orderSumItemPrices.getSumOrginalPrice());
        tempOrderVo.setSumCostPrice(orderSumItemPrices.getSumCostPrice());
        tempOrderVo.setSumMarketPrice(orderSumItemPrices.getSumMarketPrice());
        tempOrderVo.setSumShippingFee(new BigDecimal(0));
        tempOrderVo.setOrganizationCode(tempOrderCreateRequest.getOrganizationCode());
        tempOrderVo.setRealOrganizationId(tempOrderCreateRequest.getOrgainzationId());
        UserAgent agent = UserAgentUtil.getUserAgent((String)tempOrderCreateRequest.getUserAgent());
        tempOrderVo.setBrowserType(agent.getBrowserType());
        tempOrderVo.setPlatformType(agent.getPlatformType());
        Matcher matcherPhone = phonePat.matcher(tempOrderCreateRequest.getUserAgent());
        Matcher matcherTable = tablePat.matcher(tempOrderCreateRequest.getUserAgent());
        if (matcherTable.find()) {
            tempOrderVo.setBuyType("ipad");
        } else if (matcherPhone.find()) {
            tempOrderVo.setBuyType("mobile");
        } else {
            tempOrderVo.setBuyType("pc");
        }
        List splitedOrder = this.splitOrder(tempOrderVo.getOrderItems(), tempOrderVo.getTmpOrderNo());
        splitedOrder.forEach(o -> {
            o.setOrgCode(tempOrderCreateRequest.getOrganizationCode());
            o.setGoodsType(tempOrderCreateRequest.getGoodsType());
            o.setOrderMode(tempOrderCreateRequest.getOrderMode());
        });
        tempOrderVo.setSubOrders(splitedOrder);
        return tempOrderVo;
    }

    protected List<TempSubOrderVo> splitOrder(List<TempOrderItemVo> allItems, String parentOrderNo) {
        Map<String, List<TempOrderItemVo>> orderItemGroup = allItems.stream().collect(Collectors.groupingBy(TempOrderItemVo::getStoreId));
        ArrayList<TempSubOrderVo> subOrderList = new ArrayList<TempSubOrderVo>();
        orderItemGroup.forEach((s, tempOrderItemVos) -> {
            if (tempOrderItemVos.size() > 0 && tempOrderItemVos.get(0) != null) {
                TempSubOrderVo tempSubOrderVo = new TempSubOrderVo();
                tempSubOrderVo.setPOrderNo(parentOrderNo);
                tempSubOrderVo.setTmpOrderNo(this.tempOrderHelper.genTempOrderNo());
                tempSubOrderVo.setOrderItems(tempOrderItemVos);
                tempSubOrderVo.setStoreId(s);
                tempSubOrderVo.setStoreCode(((TempOrderItemVo)tempOrderItemVos.get(0)).getStoreCode());
                OrderSumItemPrices orderSumItemPrices = TempOrderHelper.calculateSumItemPrices((List)tempOrderItemVos);
                tempSubOrderVo.setSumPrice(orderSumItemPrices.getSumPrice());
                tempSubOrderVo.setSumOrginalPrice(orderSumItemPrices.getSumOrginalPrice());
                tempSubOrderVo.setSumCostPrice(orderSumItemPrices.getSumCostPrice());
                tempSubOrderVo.setSumMarketPrice(orderSumItemPrices.getSumMarketPrice());
                tempSubOrderVo.setCreateTime(new Date());
                subOrderList.add(tempSubOrderVo);
            }
        });
        return subOrderList;
    }

    protected TempOrderItemVo createTempOrderItem(GoodsInfoVo goodsInfoVo, ProductFashionDto fashion) {
        TempOrderItemVo tempOrderItemVo = new TempOrderItemVo();
        tempOrderItemVo.setProductFashionId(fashion.getId());
        tempOrderItemVo.setProductId(fashion.getProduct().getId());
        tempOrderItemVo.setStoreId(fashion.getProduct().getStoreId());
        tempOrderItemVo.setSalePrice(fashion.getSalePrice());
        tempOrderItemVo.setMarketPrice(fashion.getMarketPrice());
        tempOrderItemVo.setCostPrice(fashion.getCostPrice());
        tempOrderItemVo.setFashionPic(fashion.getFashionPic());
        tempOrderItemVo.setCount(goodsInfoVo.getCount());
        if (!Lang.isEmpty((Object)fashion.getGoods())) {
            tempOrderItemVo.setFashionTitle(fashion.getGoods().getName());
        } else {
            tempOrderItemVo.setFashionTitle(Lang.isEmpty((Object)fashion.getFashionTitle()) ? fashion.getProduct().getProductName() : fashion.getFashionTitle());
        }
        tempOrderItemVo.setFieldCode(fashion.getFieldCode());
        tempOrderItemVo.setFieldName(fashion.getFieldName());
        tempOrderItemVo.setFieldType(fashion.getFieldType());
        tempOrderItemVo.setValueName(fashion.getValueName());
        tempOrderItemVo.setGoodsId(goodsInfoVo.getGoodsId());
        tempOrderItemVo.setValue(fashion.getValue());
        tempOrderItemVo.setLackRemind(fashion.getLackRemind());
        tempOrderItemVo.setStockCount(new Long(fashion.getStockCount().intValue()));
        tempOrderItemVo.setProductCode(fashion.getProductCode());
        tempOrderItemVo.setSku(fashion.getProductCode());
        tempOrderItemVo.setStoreId(goodsInfoVo.getStoreId());
        tempOrderItemVo.setStoreCode(goodsInfoVo.getStoreCode());
        tempOrderItemVo.setStoreType(goodsInfoVo.getStoreType());
        if (goodsInfoVo.getChildren() != null && !goodsInfoVo.getChildren().isEmpty()) {
            tempOrderItemVo.setChildren(new ArrayList());
            for (GoodsInfoVo gi : goodsInfoVo.getChildren()) {
                Optional<ProductFashionDto> optional = fashion.getChildren().stream().filter(it -> it.getId() == gi.getProductFashionId()).findFirst();
                if (!optional.isPresent()) continue;
                tempOrderItemVo.getChildren().add(this.createTempOrderItem(gi, optional.get()));
            }
            BigDecimal combinationSalePrice = new BigDecimal(0);
            BigDecimal combinationMarketPrice = new BigDecimal(0);
            BigDecimal combinationCostPrice = new BigDecimal(0);
            for (TempOrderItemVo subItems : tempOrderItemVo.getChildren()) {
                combinationSalePrice = combinationSalePrice.add(subItems.getSumSalePrice());
                combinationMarketPrice = combinationMarketPrice.add(subItems.getSumMarketPrice());
                combinationCostPrice = combinationCostPrice.add(subItems.getSumCostPrice());
            }
            tempOrderItemVo.setSalePrice(combinationSalePrice);
            tempOrderItemVo.setMarketPrice(combinationMarketPrice);
            tempOrderItemVo.setCostPrice(combinationCostPrice);
        }
        tempOrderItemVo.recalateSumPrices();
        tempOrderItemVo.setOrginSalePrice(tempOrderItemVo.getSalePrice());
        return tempOrderItemVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public OrderVo createOrder(CreateOrderRequest request) throws OrderCreateException, NoStockException {
        long methodStartTime = System.currentTimeMillis();
        log.info("### \u5f00\u59cb\u521b\u5efa\u6b63\u5f0f\u8ba2\u5355 ... ###");
        log.info("\u521b\u5efa\u8ba2\u5355 temp \u6570\u636e tempOrderVo -> {}", (Object)JSON.toJSONString((Object)request));
        OrderVo orderVo = null;
        Long memberTime = System.currentTimeMillis();
        String coreUserId = request.getUserId();
        String coreUserOrganizationId = this.memberApi.findOrganizationIdById(request.getMemberId());
        CoreUserDto coreUser = new CoreUserDto();
        coreUser.setId(coreUserId);
        coreUser.setOrganizationId(coreUserOrganizationId);
        MemberDto member = new MemberDto();
        member.setId(request.getMemberId());
        member.setCoreUser(coreUser);
        log.info("\u83b7\u53d6 member \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - memberTime));
        if (request.getSubOrder() == null) {
            throw new OrderCreateException(Contants.ORDER_CREATE_ERROR.SUBORDER_NOT_PROVIDED);
        }
        if (request.getSubOrder().getOrderItems() == null || request.getSubOrder().getOrderItems().size() <= 0) {
            throw new OrderCreateException(Contants.ORDER_CREATE_ERROR.GOODS_NOT_PROVIDED);
        }
        String realOrganizationId = request.getRealOrganizationId();
        String realOrganizationCode = null;
        if (!Lang.isEmpty((Object)realOrganizationId)) {
            long organizationTime = System.currentTimeMillis();
            realOrganizationCode = this.organizationApi.findOrganizationCodeById(request.getRealOrganizationId());
            log.info("\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - organizationTime));
        }
        ArrayList<TempSubOrderVo> subOrders = new ArrayList<TempSubOrderVo>();
        if (request.getSubOrder().getSubOrders() != null && request.getSubOrder().getSubOrders().size() > 0) {
            subOrders.addAll(request.getSubOrder().getSubOrders());
        } else {
            subOrders.add(request.getSubOrder());
        }
        ArrayList<OrderVo> sucOrders = new ArrayList<OrderVo>();
        MemberAddressDto memberAddress = this.MemberAddressApi.findById(request.getMemberAddrId());
        for (TempSubOrderVo cOrder : subOrders) {
            long genOrderTime = System.currentTimeMillis();
            OrderMain order = this.orderHelper.genOrder(request, cOrder, member);
            log.info("\u751f\u6210\u8ba2\u5355\u4fe1\u606f\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - genOrderTime));
            boolean hasPriceError = false;
            ArrayList<String> goodsIds = new ArrayList<String>();
            for (OrderItem item : order.getOrderItems()) {
                if (Lang.isEmpty((Object)item.getGoodsId())) continue;
                goodsIds.add(item.getGoodsId());
            }
            Payment payment = new Payment();
            payment.setConfig(this.paymentConfigService.findByCode(request.getPaymentCode()));
            payment.setStoreId(cOrder.getStoreId());
            payment.setUserId(request.getUserId());
            payment.setType("1");
            payment.setMoney(cOrder.getSumPrice());
            if (!Lang.isEmpty((Object)order.getPayMethod()) && order.getPayMethod().equals("SCORE")) {
                payment.setStatus("1");
            } else {
                payment.setStatus("0");
            }
            payment.setOrderId(order.getId());
            payment = this.paymentService.saveOrUpdate(payment, Boolean.valueOf(true));
            order.setPaymentId(payment.getId());
            OrderVo orderVo1 = this.orderMainService.toOrderVo(this.orderMainService.saveOrder(order, Boolean.valueOf(true)), payment, memberAddress);
            orderVo1.setOrganizationCode(request.getOrganizationCode());
            sucOrders.add(orderVo1);
        }
        if (request.getSubOrder().getSubOrders() != null && !Lang.isEmpty((Object)request.getSubOrder().getSubOrders())) {
            OrderVo pOrder = (OrderVo)BeanMapper.map(sucOrders.get(0), OrderVo.class);
            pOrder.setOrderItems(sucOrders.stream().flatMap(o -> o.getOrderItems().stream()).collect(Collectors.toList()));
            pOrder.setSubOrders(sucOrders);
            pOrder.setOrderId(null);
            pOrder.setOrderNo(this.orderHelper.generateOrderNo());
            pOrder.setFreight(sucOrders.stream().map(OrderVo::getFreight).reduce(BigDecimal.ZERO, BigDecimal::add));
            pOrder.setSumNofreightPrice(sucOrders.stream().map(OrderVo::getSumNofreightPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            pOrder.setSumPrice(pOrder.getSumNofreightPrice().add(pOrder.getFreight()));
        } else {
            orderVo = (OrderVo)sucOrders.get(0);
        }
        log.info("### \u521b\u5efa\u6b63\u5f0f\u8ba2\u5355\u603b\u8017\u65f6 {} ms ###", (Object)(System.currentTimeMillis() - methodStartTime));
        return orderVo;
    }

    public OrderPayConfirmResp paySubmit(OrderVo orderVo) throws SupplierInterfaceInvokeException, SupplierOrderComfirmFalidException {
        OrderRequst orderRequst = (OrderRequst)BeanMapper.map((Object)orderVo, (Type)BeanMapper.getType(OrderVo.class), (Type)BeanMapper.getType(OrderRequst.class));
        OrderPayConfirmResp response = new OrderPayConfirmResp();
        this.supplierOrderApi.confirmOrder(orderRequst);
        this.orderMainService.updateBatchStatusByOrderNo((List)new /* Unavailable Anonymous Inner Class!! */, GlobalContants.ORDER_STATUS.OUNFILLED);
        response.setSuccess(Boolean.valueOf(true));
        return response;
    }

    public BaseResponse<CancelOrderResp> cancelOrder(List<OrderKey> orderKeys, Contants.CancelOrderType cancelType) {
        List orderKeyStrs = orderKeys.stream().map(orderKey -> Joiner.on((String)"_").skipNulls().join((Object)orderKey.getOrderId(), (Object)orderKey.getOrderNo(), new Object[0])).collect(Collectors.toList());
        ((Runnable)() -> {
            SystemLogDto systemLog = new SystemLogDto();
            systemLog.setLogType("INFO");
            systemLog.setPostUrl("CANCEL_ORDER" + Joiner.on((String)",").join((Iterable)orderKeyStrs));
            systemLog.setLogSource("JICAI");
            systemLog.setErrorDesc(cancelType.toString());
            systemLog.setPostUrl("orderNo: " + Joiner.on((String)",").join((Iterable)orderKeyStrs) + ", cancelType: " + cancelType.toString());
            this.systemLogApi.saveBean(systemLog);
        }).run();
        long sucCount = 0L;
        long failCount = 0L;
        BaseResponse resp = new BaseResponse();
        CancelOrderResp cancelOrderResp = new CancelOrderResp();
        ArrayList<CancelOrderDetailResp> detailResps = new ArrayList<CancelOrderDetailResp>();
        if (orderKeys != null && orderKeys.size() > 0) {
            List orderMainList = this.orderMainQueryService.findByKey(orderKeys);
            for (OrderMain om : orderMainList) {
                CancelOrderDetailResp detail = new CancelOrderDetailResp();
                detail.setOrderNo(om.getOrderNo());
                try {
                    int effected;
                    if (!Lang.isEmpty((Object)om.getThirdOrderNo())) {
                        TrdOrderKey trdOrderKey = new TrdOrderKey();
                        trdOrderKey.setTrdOrderNo(om.getThirdOrderNo());
                        trdOrderKey.setStoreCode(om.getStoreCode());
                        this.supplierOrderApi.cancelOrder(trdOrderKey);
                    }
                    if ((effected = this.orderMainService.cancelOrder(new OrderKey(om.getId()), cancelType)) > 0) {
                        cancelOrderResp = new CancelOrderResp();
                        ++sucCount;
                        detail.setSuccessed(Boolean.valueOf(true));
                    } else {
                        ++failCount;
                        detail.setSuccessed(Boolean.valueOf(false));
                        detail.setErrorCode(Contants.ORDER_CANCEL_ERROR.ORDER_NOFOUND.getValue());
                        detail.setMessage(Contants.ORDER_CANCEL_ERROR.ORDER_NOFOUND.getMessage());
                    }
                }
                catch (OrderCancelException oce) {
                    detail.setMessage(oce.getMessage());
                    detail.setSuccessed(Boolean.valueOf(false));
                    detail.setErrorCode(oce.getErrorCode().getValue());
                }
                catch (Exception e) {
                    ++failCount;
                    detail.setMessage(e.getMessage());
                    detail.setSuccessed(Boolean.valueOf(false));
                    detail.setErrorCode(Contants.ORDER_CANCEL_ERROR.ORDER_SQL_EXCEPTION.getValue());
                }
                detailResps.add(detail);
            }
        }
        cancelOrderResp.setSuccessCounts(Long.valueOf(sucCount));
        cancelOrderResp.setFailureCounts(Long.valueOf(failCount));
        cancelOrderResp.setDetails(detailResps);
        resp.setSuccess(true);
        resp.setResult((Object)cancelOrderResp);
        return resp;
    }

    public List<OrderAuditingResult> audit(List<OrderKey> orderKeys, Boolean passed) {
        ArrayList<OrderAuditingResult> r = new ArrayList<OrderAuditingResult>();
        List orderMains = this.orderMainQueryService.findByKey(orderKeys);
        for (OrderMain m : orderMains) {
            OrderAuditingResult oar;
            if (m.getStatus().equals(GlobalContants.ORDER_STATUS.CANCEL.getValue()) || m.getStatus().equals(GlobalContants.ORDER_STATUS.OUTOFTIME_CANCEL.getValue()) || m.getStatus().equals(GlobalContants.ORDER_STATUS.ERROR.getValue())) {
                oar = new OrderAuditingResult();
                oar.setErrorCode(Contants.ORDER_AUDITING_ERROR.NOTAUDITABLE.getValue());
                oar.setMessage("\u8ba2\u5355\u5df2\u53d6\u6d88");
                oar.setOrderKey(new OrderKey(m.getId(), m.getOrderNo()));
                oar.setSuccess(Boolean.valueOf(false));
                r.add(oar);
                orderKeys.removeIf(i -> m.getId().equals(i.getOrderId()) || m.getOrderNo().equals(i.getOrderNo()));
                continue;
            }
            if (!m.getStatus().equals(GlobalContants.ORDER_STATUS.NEWORDER.getValue())) {
                oar = new OrderAuditingResult();
                oar.setMessage("\u975e\u53ef\u5ba1\u6838\u8ba2\u5355");
                oar.setErrorCode(Contants.ORDER_AUDITING_ERROR.NOTAUDITABLE.getValue());
                oar.setOrderKey(new OrderKey(m.getId(), m.getOrderNo()));
                oar.setSuccess(Boolean.valueOf(false));
                r.add(oar);
                orderKeys.removeIf(i -> m.getId().equals(i.getOrderId()) || m.getOrderNo().equals(i.getOrderNo()));
                continue;
            }
            oar = new OrderAuditingResult();
            oar.setOrderKey(new OrderKey(m.getId(), m.getOrderNo()));
            oar.setSuccess(Boolean.valueOf(true));
            r.add(oar);
        }
        if (passed.booleanValue()) {
            ArrayList sucOrders = new ArrayList();
            r.stream().filter(ri -> ri.getSuccess()).forEach(suc -> sucOrders.add(suc.getOrderKey()));
            this.orderMainService.updateBatchStatusByOrderNo(sucOrders.stream().map(OrderKey::getOrderNo).collect(Collectors.toList()), GlobalContants.ORDER_STATUS.OBLIGATION);
        } else {
            this.orderMainService.updateBatchStatusByOrderNo(orderKeys.stream().map(OrderKey::getOrderNo).collect(Collectors.toList()), GlobalContants.ORDER_STATUS.NO_PASS);
        }
        return r;
    }

    public BaseResponse<List<OrderVo>> refresh(List<OrderKey> orderKeys) {
        BaseResponse baseResponse = new BaseResponse();
        ArrayList result = new ArrayList();
        baseResponse.setSuccess(true);
        List orderMainList = this.orderMainQueryService.findByKey(orderKeys);
        for (OrderMain m : orderMainList) {
            TrdOrderKey trdOrderKey = new TrdOrderKey();
            trdOrderKey.setStoreCode(m.getStoreCode());
            trdOrderKey.setTrdOrderNo(m.getThirdOrderNo());
            try {
                TrdOrder trdOrder = this.supplierOrderApi.getDetail(trdOrderKey);
                this.orderMainService.updateTrdOrderInfo(new OrderKey(m.getId(), m.getOrderNo()), trdOrder);
            }
            catch (SupplierInterfaceInvokeException e) {
                baseResponse.setSuccess(false);
                baseResponse.setResultCode(e.getErrorCode().getValue());
                baseResponse.setResultMessage(e.getMessage());
                log.error("\u4f9b\u5e94\u5546\u63a5\u53e3\u8c03\u7528\u62a5\u9519", (Throwable)e);
            }
        }
        return super.refresh(orderKeys);
    }
}

