/*
 * Decompiled with CFR 0.152.
 */
package order.service.order.templates;

import java.util.stream.Collectors;
import ma.glasnost.orika.metadata.Type;
import order.Contants;
import order.exceptions.IllegalAreaCodeException;
import order.service.operator.OrderFreightOperator;
import order.service.order.templates.MallDefaultOrderTemplate;
import order.service.stubs.SupplierOrderApiStub;
import order.vo.OrderKey;
import order.vo.OrderVo;
import order.vo.TempOrderVo;
import order.vo.TempSubOrderVo;
import order.vo.response.OrderFreight;
import order.vo.response.OrderStock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.orderrequest.OrderRequst;
import sinomall.global.common.response.BaseResponse;
import utils.data.BeanMapper;

public abstract class MallEntityGoodsOrderTemplate
extends MallDefaultOrderTemplate {
    private static final Logger log = LoggerFactory.getLogger(MallEntityGoodsOrderTemplate.class);
    @Autowired
    OrderFreightOperator orderFreightOperator;
    @Autowired
    SupplierOrderApiStub supplierOrderApi;

    public BaseResponse<OrderStock> validateStock(TempSubOrderVo tempOrderVo, String areaCode, String organizationId) throws IllegalAreaCodeException {
        OrderStock orderStock = null;
        orderStock = this.orderStockOperator.get(tempOrderVo, areaCode, organizationId);
        if (orderStock != null) {
            return new BaseResponse(true, "SUC", (Object)orderStock);
        }
        orderStock = new OrderStock();
        orderStock.setHasNoStock(Boolean.valueOf(true));
        return new BaseResponse(true, "SUC", (Object)orderStock);
    }

    public BaseResponse<OrderFreight> getFreight(TempOrderVo tempOrderVo) {
        OrderFreight orderFreight = this.orderFreightOperator.get(tempOrderVo);
        return new BaseResponse(true, "SUC", (Object)orderFreight);
    }

    public BaseResponse<Boolean> subscribeOrder(OrderVo orderVo) {
        BaseResponse response = new BaseResponse();
        response.setSuccess(true);
        response.setResult((Object)true);
        try {
            OrderRequst orderRequst = new OrderRequst();
            orderRequst = (OrderRequst)BeanMapper.map((Object)orderVo, (Type)BeanMapper.getType(OrderVo.class), (Type)BeanMapper.getType(OrderRequst.class));
            TrdOrder trdOrder = this.supplierOrderApi.takeOrder(orderRequst);
            this.orderMainService.updateTrdOrderInfo(new OrderKey(orderVo.getOrderId(), orderVo.getOrderNo()), trdOrder);
            log.info("\u8ba2\u5355\u3010{}\u3011\u9884\u5360\u5e93\u5b58\u6210\u529f\uff01", (Object)orderVo.getOrderNo());
        }
        catch (SupplierInterfaceInvokeException e) {
            e.printStackTrace();
            response.setResultCode(e.getErrorCode().getValue());
            response.setResultMessage(e.getErrorCode().getMessage());
            response.setSuccess(false);
            this.cancelOrder(orderVo.getSubOrders().stream().map(o -> new OrderKey(o.getOrderId())).collect(Collectors.toList()), Contants.CancelOrderType.ERROR);
        }
        catch (SupplierTakeOrderFalidException e) {
            response.setResultCode(e.getErrorCode().getValue());
            response.setResultMessage(e.getMessage());
            response.setSuccess(false);
            this.cancelOrder(orderVo.getSubOrders().stream().map(o -> new OrderKey(o.getOrderId())).collect(Collectors.toList()), Contants.CancelOrderType.ERROR);
        }
        return response;
    }
}

