/*
 * Decompiled with CFR 0.152.
 */
package order.service.order.templates;

import activities.dto.goods.GoodsDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import ma.glasnost.orika.metadata.Type;
import member.api.dto.core.CoreCompanyDto;
import order.Contants;
import order.exceptions.NoStockException;
import order.exceptions.OrderCreateException;
import order.exceptions.temporder.TempOrderCreateException;
import order.model.po.OrderMain;
import order.service.operator.OrderPriceOperator;
import order.service.order.helper.TempOrderHelper;
import order.service.order.templates.MallEntityGoodsOrderTemplate;
import order.service.service.JicaiOrderChecker;
import order.service.service.OrderService;
import order.service.stubs.ActivityGoodsApiStub;
import order.service.stubs.BiddingMainApiStub;
import order.service.stubs.GoodsApiStub;
import order.service.stubs.ProductFashionApiStub;
import order.service.stubs.SalesPriceRateApiStub;
import order.vo.CancelOrderResp;
import order.vo.CreateOrderRequest;
import order.vo.OrderKey;
import order.vo.OrderStatus;
import order.vo.OrderVo;
import order.vo.TempOrderCreateRequest;
import order.vo.TempOrderItemVo;
import order.vo.TempOrderVo;
import order.vo.response.OrderAuditingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;

public class MallJicaiOrderTemplate
extends MallEntityGoodsOrderTemplate {
    private static final Logger log = LoggerFactory.getLogger(MallJicaiOrderTemplate.class);
    @Autowired
    SalesPriceRateApiStub salesPriceRateApiStub;
    @Autowired
    TempOrderHelper tempOrderHelper;
    @Autowired
    OrderService orderService;
    @Autowired
    ActivityGoodsApiStub activityGoodsApi;
    @Autowired
    ProductFashionApiStub productFashionApi;
    @Autowired
    GoodsApiStub goodsApi;
    @Autowired
    OrderPriceOperator orderPriceOperator;
    @Autowired
    BiddingMainApiStub biddingMainApi;
    @Autowired
    JicaiOrderChecker jicaiOrderChecker;

    public TempOrderVo createTempOrder(TempOrderCreateRequest tempOrderCreateRequest) throws TempOrderCreateException {
        TempOrderVo tempOrderVo = super.createTempOrder(tempOrderCreateRequest);
        return tempOrderVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public OrderVo createOrder(CreateOrderRequest request) throws OrderCreateException, NoStockException {
        OrderVo orderVo = super.createOrder(request);
        OrderMain orderMain = this.orderMainQueryService.getOrder(orderVo.getOrderId());
        long getBuyerCompanyTime = System.currentTimeMillis();
        CoreCompanyDto coreCompanyDto = this.coreCompDepartUserApi.getBuyerCompany(request.getUserId());
        log.info("\u83b7\u53d6\u4e70\u5bb6\u673a\u6784\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getBuyerCompanyTime));
        if (!Lang.isEmpty((Object)coreCompanyDto)) {
            long getParentCompanyTime = System.currentTimeMillis();
            CoreCompanyDto compLv2 = this.coreCompanyApi.getParentCompany(coreCompanyDto.getId(), Integer.valueOf(2));
            log.info("\u83b7\u53d6\u7236\u7ea7\u673a\u6784\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getParentCompanyTime));
            if (compLv2 != null) {
                orderMain.setCompanyId(compLv2.getId());
            }
        }
        OrderStatus orderStatus = new OrderStatus();
        orderStatus.setOrderId(orderVo.getOrderId());
        orderStatus.setOrderNo(orderVo.getOrderNo());
        orderStatus.setStatus(GlobalContants.ORDER_STATUS.IN_CHECK);
        this.orderService.statusChange(orderStatus);
        orderVo.setGotoPay(Boolean.valueOf(false));
        return orderVo;
    }

    public BaseResponse<Boolean> orderPreCheck(TempOrderVo tempOrderVo) {
        BaseResponse response = super.orderPreCheck(tempOrderVo);
        if (!response.isSuccess()) {
            return response;
        }
        if (response.isSuccess()) {
            this.jicaiOrderChecker.checkOrderPriceLimit(tempOrderVo);
        }
        return response;
    }

    public BaseResponse<Boolean> marketingDone(TempOrderVo tempOrderVo) {
        List allGoodsIds = tempOrderVo.getOrderItems().stream().filter(it -> !Lang.isEmpty((Object)it.getGoodsId())).map(TempOrderItemVo::getGoodsId).collect(Collectors.toList());
        List goodsDtos = this.goodsApi.findByIdIn(allGoodsIds);
        List actGoodsDtos = BeanMapper.mapList((Iterable)goodsDtos, (Type)BeanMapper.getType(goods.dto.goods.GoodsDto.class), (Type)BeanMapper.getType(GoodsDto.class));
        List actRs = this.activityGoodsApi.isActivityGoodsAndGetActivityPriceBatch(actGoodsDtos, tempOrderVo.getOrganizationCode());
        if (actRs != null) {
            actRs.forEach(m -> {
                if (((Boolean)m.get("isActivityGoods")).booleanValue()) {
                    TempOrderHelper.updateOrderItemPrice((TempOrderVo)tempOrderVo, tempOrderItemVo -> m.get("goodsId").equals(tempOrderItemVo.getGoodsId()), (BigDecimal)((BigDecimal)m.get("price")));
                }
            });
        }
        return new BaseResponse(true, "SUC", (Object)true);
    }

    public BaseResponse<Boolean> orderPayPreSubmitDone(OrderVo orderVo) {
        BaseResponse superRs = super.orderPayPreSubmitDone(orderVo);
        return superRs;
    }

    public List<OrderAuditingResult> audit(List<OrderKey> orderKeys, Boolean passed) {
        ArrayList<OrderAuditingResult> orderAuditingResults = new ArrayList<OrderAuditingResult>();
        if (passed.booleanValue()) {
            orderKeys.forEach(orderKey -> {
                OrderAuditingResult orderAuditingResult = new OrderAuditingResult();
                orderAuditingResult.setSuccess(Boolean.valueOf(true));
                orderAuditingResult.setOrderKey(orderKey);
                orderAuditingResults.add(orderAuditingResult);
            });
        }
        return orderAuditingResults;
    }

    public BaseResponse<CancelOrderResp> cancelOrder(List<OrderKey> orderKeys, Contants.CancelOrderType cancelType) {
        return super.cancelOrder(orderKeys, cancelType);
    }

    public void orderReceipt(OrderKey orderKey, String receiptType) {
    }
}

