/*
 * Decompiled with CFR 0.152.
 */
package order.service.order.templates;

import java.util.List;
import order.Contants;
import order.exceptions.IllegalAreaCodeException;
import order.exceptions.NoStockException;
import order.exceptions.OrderCreateException;
import order.exceptions.temporder.TempOrderCreateException;
import order.service.operator.OrderFreightOperator;
import order.service.order.templates.OrderTemplate;
import order.vo.CancelOrderResp;
import order.vo.CreateOrderRequest;
import order.vo.OrderKey;
import order.vo.OrderPayConfirmResp;
import order.vo.OrderVo;
import order.vo.TempOrderCreateRequest;
import order.vo.TempOrderVo;
import order.vo.TempSubOrderVo;
import order.vo.response.OrderAuditingResult;
import order.vo.response.OrderFreight;
import order.vo.response.OrderStock;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierOrderComfirmFalidException;
import sinomall.global.common.response.BaseResponse;

public abstract class OrderTemplateAdapter
implements OrderTemplate {
    public TempOrderVo createTempOrder(TempOrderCreateRequest tempOrderCreateRequest) throws TempOrderCreateException {
        return new TempOrderVo();
    }

    public BaseResponse<OrderStock> validateStock(TempSubOrderVo tempOrderVo, String areaCode, String organizationId) throws IllegalAreaCodeException {
        OrderStock orderStock = new OrderStock();
        orderStock.setHasNoStock(Boolean.valueOf(false));
        return new BaseResponse(true, "SUC", (Object)orderStock);
    }

    public BaseResponse<OrderFreight> getFreight(TempOrderVo tempOrderVo) {
        return new BaseResponse(true, "SUC", (Object)OrderFreightOperator.defaultFromTempOrder((TempOrderVo)tempOrderVo));
    }

    public BaseResponse<Boolean> orderPreCheck(TempOrderVo tempOrderVo) {
        return new BaseResponse(true, "SUC", (Object)true);
    }

    public OrderVo createOrder(CreateOrderRequest request) throws OrderCreateException, NoStockException {
        return new OrderVo();
    }

    public List<OrderAuditingResult> audit(List<OrderKey> orderKeys, Boolean passed) {
        return null;
    }

    public BaseResponse<Boolean> subscribeOrder(OrderVo orderVo) {
        return new BaseResponse(true, "SUC", (Object)true);
    }

    public BaseResponse<Boolean> marketingDone(TempOrderVo tempOrderVo) {
        return new BaseResponse(true, "SUC", (Object)true);
    }

    public BaseResponse<Boolean> orderPayPreSubmitDone(OrderVo orderVo) {
        return new BaseResponse(true, "SUC", (Object)true);
    }

    public OrderPayConfirmResp paySubmit(OrderVo orderVo) throws SupplierInterfaceInvokeException, SupplierOrderComfirmFalidException {
        OrderPayConfirmResp orderPayConfirmResp = new OrderPayConfirmResp();
        orderPayConfirmResp.setSuccess(Boolean.valueOf(true));
        return orderPayConfirmResp;
    }

    public BaseResponse<CancelOrderResp> cancelOrder(List<OrderKey> orderKeys, Contants.CancelOrderType cancelType) {
        return new BaseResponse(true, "SUC", (Object)new CancelOrderResp());
    }

    public void orderReceipt(OrderKey orderKey, String receiptType) {
    }

    public BaseResponse<List<OrderVo>> refresh(List<OrderKey> orderKeys) {
        return null;
    }
}

