/*
 * Decompiled with CFR 0.152.
 */
package order.service.service;

import cart.api.dto.payment.PaymentConfigDto;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.shop.MemberDto;
import order.service.stubs.CoreCompDepartUserApiStub;
import order.service.stubs.CoreCompanyApiStub;
import order.service.stubs.MemberApiStub;
import order.service.stubs.SystemConfigApiStub;
import order.vo.TempOrderVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;

@Service
@Transactional(readOnly=true, rollbackFor={Exception.class})
public class JicaiOrderChecker {
    @Autowired
    CoreCompanyApiStub coreCompanyApi;
    @Autowired
    SystemConfigApiStub systemConfigApi;
    @Autowired
    CoreCompDepartUserApiStub coreCompDepartUserApi;
    @Autowired
    MemberApiStub memberApi;

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public String checkOrderPriceLimit(TempOrderVo tempOrderVo) {
        Map config;
        CoreCompanyDto company;
        CoreCompanyDto compLv2;
        String onlinePayLimitStr = this.systemConfigApi.getConfigValue("jicai", "ORDER_CONFIGS", "ONLINE_PAY_LIMITS", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        String errorCode = "0";
        List onlinePayLimitConfigs = JSON.parseArray((String)onlinePayLimitStr, Map.class);
        MemberDto member = this.memberApi.findMemberById(tempOrderVo.getMemberId());
        CoreCompanyDto coreCompanyDto = this.coreCompDepartUserApi.getBuyerCompany(member.getCoreUser().getId());
        String lv2CompId = null;
        if (!Lang.isEmpty((Object)coreCompanyDto) && (compLv2 = this.coreCompanyApi.getParentCompany(coreCompanyDto.getId(), Integer.valueOf(2))) != null) {
            lv2CompId = compLv2.getId();
        }
        if (!Lang.isEmpty(lv2CompId) && (company = this.coreCompanyApi.findById(lv2CompId)) != null && (config = (Map)Lang.findInBeanList((List)onlinePayLimitConfigs, (String)"comCode", (Object)company.getCode())) != null && tempOrderVo.getSumPrice().compareTo((BigDecimal)config.get("limit")) > 0 && tempOrderVo.getPayMethodCode().equals(PaymentConfigDto.PAYMENT_CONFIG_CODE_ONLINE)) {
            errorCode = "1";
        }
        return errorCode;
    }

    public void checkQuota() {
    }
}

