/*
 * Decompiled with CFR 0.152.
 */
package order.service.service;

import activities.api.ActivityConfigurationApi;
import activities.api.ActivityGoodsApi;
import cart.api.OrderMainApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.api.vo.CartItemVo;
import cart.api.vo.TempOrderItemVo;
import cart.api.vo.TempOrderStoreVo;
import cart.api.vo.TempOrderVo;
import cms.api.DepositHistoryApi;
import cms.api.OrganizationApi;
import cms.api.OrganizationCreditsApi;
import cms.api.dto.DepositHistoryDto;
import cms.api.dto.OrganizationCreditsDto;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.api.PriceParityApi;
import goods.api.ProductApi;
import goods.api.ProductFashionApi;
import goods.api.SalesPriceRateApi;
import goods.api.ShareApi;
import goods.dto.product.ProductFashionDto;
import goods.vo.SalesPriceCalVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import jdek.api.service.JdekApi;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.metadata.Type;
import member.api.AddressCommonApi;
import member.api.CoreCompDepartUserApi;
import member.api.CoreCompanyApi;
import member.api.MemberAddressApi;
import member.api.MemberCreditsHitsApi;
import member.api.MemberCreditsTranApi;
import member.api.MemberInvoinceApi;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberCreditsTranDto;
import member.api.dto.shop.MemberDto;
import order.Contants;
import order.model.po.OrderGift;
import order.model.po.OrderItem;
import order.model.po.OrderItemRelations;
import order.model.po.OrderMain;
import order.model.po.OrderMainAttr;
import order.model.po.OrderMainExt;
import order.model.po.SubOrder;
import order.model.po.SubOrderItem;
import order.model.repository.OrderGiftRepos;
import order.model.repository.OrderItemRelationsRepos;
import order.model.repository.OrderItemRepos;
import order.model.repository.OrderParityRepos;
import order.model.repository.OrderRepos;
import order.model.repository.SubOrderItemRepos;
import order.model.repository.SubOrderRepos;
import order.service.order.helper.OrderHelper;
import order.service.service.OrderMainService;
import order.service.service.OrderService;
import order.service.service.query.OrderMainQueryService;
import order.service.stubs.GroupBuyingApiStub;
import order.service.stubs.MemberApiStub;
import order.service.stubs.SalesPriceRateQueryApiStub;
import order.vo.OrderItemVo;
import order.vo.OrderKey;
import order.vo.OrderPaymentVo;
import order.vo.OrderReceiver;
import order.vo.OrderVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.api.OutsideProductApi;
import outsideapi.vo.FashionNumsVo;
import outsideapi.vo.FashionPriceParamVo;
import outsideapi.vo.FashionPriceRequestVo;
import outsideapi.vo.FashionPriceVo;
import outsideapi.vo.HandlerRespVo;
import outsideapi.vo.ShippingFeeRequetVo;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.order.TrdOrderSku;
import payment.model.po.Payment;
import sinomall.global.common.response.BaseResponse;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import sysmg.api.SystemConfigApi;
import sysmg.api.SystemLogApi;
import sysmg.dto.SystemLogDto;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.date.DateUtils;
import utils.lang.Copys;
import utils.log.Log;
import utils.log.Logs;
import utils.rpc.motan.ApiResponseVo;
import utils.spring.SequenceGenerator;

@Component
@Transactional(readOnly=true)
public class OrderMainService {
    private static final Log logs = Logs.getLog((String)OrderService.class.getName());
    @Value(value="${spring.profiles.active}")
    private String activeEnv;
    @Value(value="${order.orderno.envprefix:DEV}")
    private String envPrefix;
    @Resource(name="redisTemplate")
    ValueOperations<String, BigDecimal> shippingFeeOps;
    @Resource(name="redisTemplate")
    ValueOperations<String, FashionPriceVo> productPriceOps;
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    MemberApiStub memberApi;
    @Autowired
    SalesPriceRateQueryApiStub salesPriceRateQueryApi;
    @Autowired
    GroupBuyingApiStub groupBuyingApi;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    OrderItemRepos orderItemRepos;
    @Autowired
    SubOrderRepos subOrderRepos;
    @Autowired
    OrderItemRelationsRepos orderItemRelationsRepos;
    @Autowired
    SubOrderItemRepos subOrderItemRepos;
    @Autowired
    OrderGiftRepos orderGiftRepos;
    @Autowired
    OrderRepos orderRepos;
    @Autowired
    SequenceGenerator sequenceGenerator;
    @MotanReferer
    ProductFashionApi productFashionApi;
    @MotanReferer
    GoodsApi goodsApi;
    @MotanReferer
    OutsideProductApi outsideProductApi;
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    AddressCommonApi addressCommonApi;
    @MotanReferer
    MemberInvoinceApi memberInvoinceApi;
    @MotanReferer
    CoreCompDepartUserApi coreCompDepartUserApi;
    @MotanReferer
    CoreCompanyApi coreCompanyApi;
    @MotanReferer
    SystemConfigApi systemConfigApi;
    @MotanReferer
    ShareApi shareApi;
    @MotanReferer
    SystemLogApi systemLogApi;
    @MotanReferer
    ActivityConfigurationApi activityConfigurationApi;
    @MotanReferer
    ActivityGoodsApi activityGoodsApi;
    @MotanReferer
    MemberCreditsHitsApi memberCreditsHitsApi;
    @Autowired
    EntityManager entityManager;
    @MotanReferer
    StoreApi storeApi;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @MotanReferer
    JdekApi jdekApi;
    @MotanReferer
    PriceParityApi priceParityApi;
    @MotanReferer
    ProductApi productApi;
    @Autowired
    OrderParityRepos orderParityRepos;
    @MotanReferer
    MemberCreditsTranApi tranApi;
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    DepositHistoryApi depositHistoryApi;
    @MotanReferer
    OrganizationCreditsApi organizationCreditsApi;
    @MotanReferer
    SalesPriceRateApi salesPriceRateApi;
    @Autowired
    OrderMainQueryService orderMainQueryService;

    public void saveSuccessLog(String orderNo, OrderMainApi.CancelOrderType cancelType, ApiResponseVo responseVo, ApiResponseVo apiResponseVo) {
        responseVo.setStatus("success");
        responseVo.setMessage(apiResponseVo.getMessage());
        SystemLogDto systemLog = new SystemLogDto();
        systemLog.setLogType("INFO");
        systemLog.setLogSource("JICAI");
        systemLog.setErrorDesc("\u53d6\u6d88\u57ce\u901a\u79ef\u5206\u8ba2\u5355\u8fd4\u8fd8\u6210\u529f\uff01" + apiResponseVo.getMessage());
        systemLog.setPostUrl("orderNo: " + orderNo + ", cancelType: " + cancelType.toString());
        this.systemLogApi.saveBean(systemLog);
    }

    public void saveErrorLog(String orderNo, OrderMainApi.CancelOrderType cancelType, ApiResponseVo responseVo, ApiResponseVo apiResponseVo) {
        responseVo.setStatus("error");
        responseVo.setMessage(apiResponseVo.getMessage());
        SystemLogDto systemLog = new SystemLogDto();
        systemLog.setLogType("ERROR");
        systemLog.setLogSource("JICAI");
        systemLog.setErrorDesc("\u53d6\u6d88\u57ce\u901a\u79ef\u5206\u8ba2\u5355\u8fd4\u8fd8\u79ef\u5206\u5931\u8d25\uff01" + apiResponseVo.getMessage());
        systemLog.setPostUrl("orderNo: " + orderNo + ", cancelType: " + cancelType.toString());
        this.systemLogApi.saveBean(systemLog);
    }

    private void backActivityGoodsStockAndSolcNum(OrderMain orderMain, String organizationCode) {
        for (OrderItem orderItem : orderMain.getOrderItems()) {
            if (Lang.isEmpty((Object)orderItem.getActivityId())) continue;
            this.activityGoodsApi.backActivityGoodsStockAndSolcNum(orderItem.getGoodsId(), orderItem.getActivityId(), orderItem.getCount(), organizationCode);
        }
    }

    private void generateDepositHistory(BigDecimal totalPrice, String memberId, OrganizationDto organization) {
        DepositHistoryDto depositHistory = new DepositHistoryDto();
        depositHistory.setDepositType("CancelOrder");
        depositHistory.setDepositMoney(totalPrice);
        depositHistory.setDepositUserId(memberId);
        MemberDto member = this.memberApi.findMemberById(memberId);
        depositHistory.setDepositUserName(member.getCoreUser().getUsername());
        depositHistory.setOrganization(organization);
        depositHistory.setRemark("\u7528\u6237\uff1a" + member.getCoreUser().getUsername() + "\u5728" + DateUtils.getNowTime() + "\u53d6\u6d88\u4e86\u8ba2\u5355\uff0c\u53d1\u8d77\u9000\u6b3e\u91d1\u989d\u4e3a" + totalPrice + "\u5143");
        this.depositHistoryApi.saveDepositHistory(depositHistory);
    }

    public void prePayOrder(String orderNo) {
        this.orderRepos.updateStatusByOrderNo("1", orderNo);
        this.updateGoodsSaleCount("1", orderNo);
    }

    public OrderMain cpyOrder(OrderMain from, OrderMain to) {
        OrderMain orderMainNew = to == null ? new OrderMain() : to;
        Copys copys = Copys.create();
        ArrayList<OrderItem> orderItemList = new ArrayList<OrderItem>();
        ArrayList<SubOrder> subOrders = new ArrayList<SubOrder>();
        ArrayList<OrderGift> orderGifts = new ArrayList<OrderGift>();
        ArrayList<OrderMainAttr> orderMainAttrs = new ArrayList<OrderMainAttr>();
        if (from == null) {
            return null;
        }
        copys.from((Object)from).excludes(new String[]{"orderItems", "subOrders", "orderGifts", "orderAttrs"}).to(new Object[]{orderMainNew}).clear();
        if (!Lang.isEmpty((Object)from.getOrderItems())) {
            for (OrderItem i : from.getOrderItems()) {
                OrderItem orderItemTmp = new OrderItem();
                copys.from((Object)i).excludes(new String[]{"order"}).to(new Object[]{orderItemTmp}).clear();
                orderItemTmp.setOrder(orderMainNew);
                orderItemList.add(orderItemTmp);
            }
            orderMainNew.setOrderItems(orderItemList);
        }
        if (from.getSubOrders() != null) {
            for (SubOrder s : from.getSubOrders()) {
                ArrayList<SubOrderItem> subOrderItemList = new ArrayList<SubOrderItem>();
                SubOrder subOrderTmp = new SubOrder();
                copys.from((Object)s).excludes(new String[]{"order", "subOrderItems"}).to(new Object[]{subOrderTmp}).clear();
                subOrderTmp.setOrder(from);
                for (SubOrderItem soi : s.getSubOrderItems()) {
                    SubOrderItem subOrderItem = new SubOrderItem();
                    copys.from((Object)soi).excludes(new String[]{"order", "subOrder", "orderItem"}).to(new Object[]{subOrderItem}).clear();
                    subOrderItem.setOrder(orderMainNew);
                    subOrderItem.setSubOrder(subOrderTmp);
                    subOrderItemList.add(subOrderItem);
                    if (Lang.isEmpty((Object)soi.getOrderItem())) continue;
                    for (OrderItem i : orderMainNew.getOrderItems()) {
                        if (i.getId().equals(soi.getOrderItem().getId())) {
                            subOrderItem.setOrderItem(soi.getOrderItem());
                            continue;
                        }
                        subOrderItem.setOrderItem(soi.getOrderItem());
                    }
                }
                subOrderTmp.setSubOrderItems(subOrderItemList);
                subOrders.add(subOrderTmp);
            }
            orderMainNew.setSubOrders(subOrders);
        }
        if (from.getOrderGifts() != null) {
            for (OrderGift og : from.getOrderGifts()) {
                OrderGift orderGiftTmp = new OrderGift();
                copys.from((Object)og).excludes(new String[]{"order"}).to(new Object[]{orderGiftTmp}).clear();
                orderGiftTmp.setOrder(orderMainNew);
                orderGifts.add(orderGiftTmp);
            }
            orderMainNew.setOrderGifts(orderGifts);
        }
        if (from.getOrderAttrs() != null) {
            for (OrderMainAttr attr : from.getOrderAttrs()) {
                OrderMainAttr orderMainAttrTmp = new OrderMainAttr();
                copys.from((Object)attr).excludes(new String[]{"order"}).to(new Object[]{orderMainAttrTmp}).clear();
                orderMainAttrTmp.setOrder(orderMainNew);
                orderMainAttrs.add(orderMainAttrTmp);
            }
            orderMainNew.setOrderAttrs(orderMainAttrs);
        }
        return orderMainNew;
    }

    public TempOrderVo updateOutsidePrices(TempOrderVo tempOrderVo, Map<Integer, String> areaCodeList, Boolean usePriceCache) {
        for (TempOrderStoreVo storeVo : tempOrderVo.getStoreList()) {
            HandlerRespVo outsideApiRes;
            if (areaCodeList == null) continue;
            FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo(areaCodeList);
            fashionPriceRequestVo.setFashionPriceParamVos(new ArrayList());
            for (TempOrderItemVo orderItemVo : storeVo.getOrderItems()) {
                fashionPriceRequestVo.getFashionPriceParamVos().add(new FashionPriceParamVo(orderItemVo.getProductFashionId(), orderItemVo.getProductCode()));
            }
            ArrayList<FashionPriceParamVo> needQueryList = null;
            ArrayList<FashionPriceVo> resultFashionPrice = new ArrayList<FashionPriceVo>();
            if (usePriceCache.booleanValue()) {
                needQueryList = new ArrayList<FashionPriceParamVo>();
                for (FashionPriceParamVo it2 : fashionPriceRequestVo.getFashionPriceParamVos()) {
                    FashionPriceVo price = this.getProductPriceInCache(storeVo.getStoreId(), it2.getProductCode());
                    if (price == null) {
                        needQueryList.add(it2);
                        continue;
                    }
                    resultFashionPrice.add(price);
                }
                fashionPriceRequestVo.setFashionPriceParamVos(needQueryList);
            }
            if (fashionPriceRequestVo.getFashionPriceParamVos().size() > 0 && (outsideApiRes = this.outsideProductApi.queryFashionPrice(storeVo.getStoreId(), fashionPriceRequestVo)) != null && outsideApiRes.getStatus() == HandlerRespVo.RESPONSE_STATUS_SUCCESS && !Lang.isEmpty((Object)outsideApiRes.getData())) {
                resultFashionPrice.addAll((Collection)outsideApiRes.getData());
                ((List)outsideApiRes.getData()).forEach(it -> this.setProductPriceInCache(storeVo.getStoreId(), it.getProductCode(), it));
            }
            resultFashionPrice.forEach(r -> {
                Optional<TempOrderItemVo> optional = storeVo.getOrderItems().stream().filter(tempOrderItemVo -> tempOrderItemVo.getProductFashionId().equals(r.getFashionId())).findFirst();
                if (optional.isPresent()) {
                    TempOrderItemVo orderItemVo = optional.get();
                    orderItemVo.setSalePrice(r.getSalePrice());
                    orderItemVo.setMarketPrice(r.getMarketPrice());
                    orderItemVo.setCostPrice(r.getCostPrice());
                }
            });
        }
        return tempOrderVo;
    }

    public void genOrganizationSalesPrice(String organizationCode, TempOrderVo tempOrderVo) {
        long methodStartTime = System.currentTimeMillis();
        logs.info((Object)"### \u5f00\u59cb\u4e3a\u8ba2\u5355\u8ba1\u7b97\u7b2c\u4e09\u65b9\u8d39\u7387\u4ef7\u683c ... ###");
        if (!Lang.isEmpty((Object)organizationCode)) {
            long organizationTime = System.currentTimeMillis();
            String organizationId = this.organizationApi.findOrganizationIdByOrgCode(organizationCode);
            logs.info((Object)"\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - organizationTime});
            if (organizationId != null) {
                ArrayList<SalesPriceCalVo> salesPriceCalVoList = new ArrayList<SalesPriceCalVo>();
                for (TempOrderStoreVo storeVo : tempOrderVo.getStoreList()) {
                    for (TempOrderItemVo itemVo : storeVo.getOrderItems()) {
                        salesPriceCalVoList.add(new SalesPriceCalVo(itemVo.getProductFashionId(), storeVo.getStoreId(), storeVo.getCode(), organizationId, itemVo.getSalePrice(), itemVo.getCostPrice(), itemVo.getMarketPrice(), itemVo.getCostPrice(), itemVo.getCount(), organizationCode));
                    }
                }
                long calBatchSalesPriceTime = System.currentTimeMillis();
                List rateCalRs = this.salesPriceRateApi.calBatchSalesPrice(salesPriceCalVoList);
                logs.info((Object)"\u6279\u91cf\u8ba1\u7b97\u8d39\u7387\u4ef7\u683c\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - calBatchSalesPriceTime});
                for (Map m : rateCalRs) {
                    for (TempOrderStoreVo storeVo : tempOrderVo.getStoreList()) {
                        for (TempOrderItemVo itemVo : storeVo.getOrderItems()) {
                            if (!itemVo.getProductFashionId().equals(m.get("fashionId"))) continue;
                            itemVo.setSalePrice(((BigDecimal)m.get("salePrice")).setScale(2, 0));
                            itemVo.setSalesPriceRate((BigDecimal)m.get("rate"));
                            long activityIdTime = System.currentTimeMillis();
                            String activityId = this.activityGoodsApi.isInActivityNow(itemVo.getGoodsId(), organizationCode);
                            logs.info((Object)"\u83b7\u53d6\u5546\u54c1\u6d3b\u52a8\u573a\u6b21\u4fe1\u606f\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - activityIdTime});
                            if (Lang.isEmpty((Object)activityId)) continue;
                            itemVo.setActivityId(activityId);
                            long activityPriceTime = System.currentTimeMillis();
                            BigDecimal salePrice = this.activityGoodsApi.getActivityPrice(itemVo.getGoodsId(), organizationCode, storeVo.getCode()).setScale(2, 0);
                            logs.info((Object)"\u83b7\u53d6\u6d3b\u52a8\u4ef7\u683c\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - activityPriceTime});
                            itemVo.setSalePrice(salePrice);
                            logs.info((Object)"\u521b\u5efa\u8ba2\u5355 - \u6d3b\u52a8\u5546\u54c1ID {}, \u6d3b\u52a8\u573a\u6b21ID {}, \u6d3b\u52a8\u4ef7\u683c {}", new Object[]{itemVo.getGoodsId(), activityId, salePrice});
                        }
                    }
                }
            }
        }
        logs.info((Object)"### \u4e3a\u8ba2\u5355\u8ba1\u7b97\u7b2c\u4e09\u65b9\u8d39\u7387\u4ef7\u683c\u603b\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - methodStartTime});
    }

    public TempOrderStoreVo generateStoreVo(StoreDto storeDto) {
        TempOrderStoreVo storeVo = new TempOrderStoreVo();
        storeVo.setStoreId(storeDto.getId());
        storeVo.setCode(storeDto.getStoreExt().getCode());
        storeVo.setDomain(storeDto.getStoreExt().getDomain());
        storeVo.setLogoImg(storeDto.getStoreExt().getLogoImg());
        storeVo.setStoreName(storeDto.getStoreExt().getStoreName());
        storeVo.setShortName(storeDto.getStoreExt().getShortName());
        storeVo.setStorePath(storeDto.getStoreExt().getStorePath());
        storeVo.setType(storeDto.getStoreExt().getType());
        storeVo.setSumPrice(BigDecimal.valueOf(0L));
        storeVo.setSumMarketPrice(BigDecimal.valueOf(0L));
        return storeVo;
    }

    private Boolean isScoreEnough(OrganizationDto organization, BigDecimal totalScore) {
        Boolean isEnough = true;
        if (organization.getOrgScore().subtract(totalScore).compareTo(BigDecimal.ZERO) <= 0) {
            isEnough = false;
        }
        return isEnough;
    }

    private void updateOrganizationAccount(BigDecimal totalPrice, String type, OrganizationDto organization) {
        BigDecimal currentMoney = organization.getCurrentMoney();
        currentMoney = "add".equals(type) ? currentMoney.add(totalPrice) : currentMoney.subtract(totalPrice);
        organization.setCurrentMoney(currentMoney);
        this.organizationApi.saveOrganization(organization);
    }

    private void updateOrganizationScore(BigDecimal totalScore, OrganizationDto organization) {
        BigDecimal currentScore = organization.getOrgScore();
        currentScore = currentScore.subtract(totalScore);
        organization.setOrgScore(currentScore);
        this.organizationApi.saveOrganization(organization);
    }

    private void generateCreditsHistory(Integer totalScore, MemberDto member, OrganizationDto organization) {
        OrganizationCreditsDto organizationCreditsDto = new OrganizationCreditsDto();
        organizationCreditsDto.setMemberId(member.getId());
        organizationCreditsDto.setUseScore(totalScore);
        organizationCreditsDto.setOrganization(organization);
        organizationCreditsDto.setRemark("\u7528\u6237\uff1a" + member.getCoreUser().getUsername() + "\u5728" + DateUtils.getNowTime() + "\u6d88\u8d39\u4e86" + totalScore + "\u79ef\u5206");
        this.organizationCreditsApi.saveOrganizationCredits(organizationCreditsDto);
    }

    private MemberCreditsTranDto genMemberCreditsTran(TempOrderStoreVo tempOrderStoreVo, MemberDto member, BigDecimal sumScore) {
        MemberCreditsTranDto tran = new MemberCreditsTranDto();
        tran.setUseScore(sumScore);
        tran.setSendName(member.getRealName());
        tran.setTargetMemberId(tempOrderStoreVo.getStoreId());
        tran.setTargetName(tempOrderStoreVo.getStoreName());
        tran.setSendUserId(member.getId());
        tran.setSendType("4");
        return tran;
    }

    private void genOrder(String addressId, MemberDto member, OrderMain order, TempOrderStoreVo tempOrderStoreVo, String invoiceId, String usageCode, TempOrderVo tempOrderVo) {
        HandlerRespVo respVo;
        MemberAddressDto address = this.memberAddressApi.findById(addressId);
        order.setAddressId(addressId);
        order.setMemberId(member.getId());
        order.setOrganizationId(member.getCoreUser().getOrganizationId());
        order.setSumPrice(tempOrderStoreVo.getSumPrice());
        order.setSumNofreightPrice(tempOrderStoreVo.getSumPrice());
        order.setOrderItems(new ArrayList());
        if (address != null) {
            order.setRecipientName(address.getUsername());
        }
        if ((respVo = this.outsideProductApi.isOutsideStore(tempOrderStoreVo.getStoreId())).getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS) && ((Boolean)respVo.getData()).booleanValue()) {
            order.setStatus("0");
        } else {
            order.setStatus("1");
        }
        order.setStoreId(tempOrderStoreVo.getStoreId());
        order.setCreateTime(new Date());
        order.setFreight(new BigDecimal(0));
        order.setFreeFreight(BigDecimal.ZERO);
        order.reCalSumPrice();
        order.setInvoiceId(invoiceId);
        order.setUsageCode(usageCode);
        if (order.getRealOrganizationId() == null) {
            order.setRealOrganizationId(order.getOrganizationId());
        }
        order.setStoreType(tempOrderStoreVo.getType());
        order.setStoreName(tempOrderStoreVo.getStoreName());
        order.setStoreCode(tempOrderStoreVo.getCode());
        this.saveOrderMainExtMessage(addressId, member, order, tempOrderStoreVo, invoiceId, usageCode, tempOrderVo);
    }

    private void saveOrderMainExtMessage(String addressId, MemberDto member, OrderMain order, TempOrderStoreVo tempOrderStoreVo, String invoiceId, String usageCode, TempOrderVo tempOrderVo) {
        order.setBuyType(tempOrderVo.getBuyType());
        order.setHeadMessage(tempOrderVo.getHeadMessage());
        order.setBrowserType(tempOrderVo.getBrowserType());
        order.setPlatformType(tempOrderVo.getPlatformType());
        order.setRequestId(tempOrderVo.getRequestId());
        logs.info((Object)"tempOrderVo.getRequestId{}", new Object[]{tempOrderVo.getRequestId()});
        HashMap<String, Object> postMap = new HashMap<String, Object>();
        postMap.put("tempOrderVo", tempOrderVo);
        postMap.put("addressId", addressId);
        postMap.put("invoiceId", invoiceId);
        postMap.put("usageCode", usageCode);
        order.setPostDesc(JSONObject.toJSONString(postMap));
        if (Lang.isEmpty((Object)tempOrderVo.getRequestId())) {
            order.setRequestId(tempOrderVo.getTmpOrderNo());
        }
    }

    private void genOrder(String addressId, MemberDto member, OrderMain order, TempOrderStoreVo tempOrderStoreVo, String invoiceId, TempOrderVo tempOrderVo) {
        this.genOrder(addressId, member, order, tempOrderStoreVo, invoiceId, null, tempOrderVo);
    }

    private void reduceStock(OrderMain order) {
        for (OrderItem it : order.getOrderItems()) {
            ProductFashionDto pf;
            if (Lang.isEmpty((Object)it) || Lang.isEmpty((Object)(pf = this.productFashionApi.findById(it.getProductFashId())))) continue;
            if (pf.getStockCount() > 0) {
                pf.setStockCount(Integer.valueOf(pf.getStockCount() - it.getCount()));
            }
            this.productFashionApi.saveFashion(pf);
        }
    }

    private int genOrderItem(OrderMain order, TempOrderStoreVo tempOrderStoreVo) {
        int totalCounts = 0;
        MemberAddressDto memberAddress = this.memberAddressApi.findById(order.getAddressId());
        FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo();
        fashionPriceRequestVo.setCityCode(memberAddress.getCityCode());
        fashionPriceRequestVo.setProvinceCode(memberAddress.getProvinceCode());
        fashionPriceRequestVo.setCountyCode(memberAddress.getAreaCode());
        fashionPriceRequestVo.setTownCode(memberAddress.getTownCode());
        fashionPriceRequestVo.setFashionPriceParamVos(new ArrayList());
        for (TempOrderItemVo c : tempOrderStoreVo.getOrderItems()) {
            FashionPriceParamVo fashionPriceParamVo = new FashionPriceParamVo();
            fashionPriceParamVo.setFactionId(c.getProductFashionId());
            fashionPriceParamVo.setProductCode(c.getProductCode());
            fashionPriceRequestVo.getFashionPriceParamVos().add(fashionPriceParamVo);
            ++totalCounts;
            OrderItem orderItem = this.generateOrderItem(c);
            if (c.getChildren() != null && c.getChildren().size() > 0) {
                ArrayList<OrderItem> childOrderItemList = new ArrayList<OrderItem>();
                for (TempOrderItemVo cc : c.getChildren()) {
                    OrderItem childOrderItem = this.generateOrderItem(cc);
                    childOrderItem.setParent(orderItem);
                    childOrderItemList.add(childOrderItem);
                }
                orderItem.setChildren(childOrderItemList);
            }
            orderItem.setOrder(order);
            order.getOrderItems().add(orderItem);
        }
        String spiderLogFlag = this.systemConfigApi.getConfigValue("COMMON", "ORDER_CONFIGS", "ORDER_SPIDER_PRICE_LOG", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (spiderLogFlag != null && "1".equals(spiderLogFlag)) {
            Long time = System.currentTimeMillis();
            HandlerRespVo apiRes = this.outsideProductApi.runPriceSpider(order.getStoreId(), fashionPriceRequestVo, "ORDER", Boolean.valueOf(false));
            logs.info((Object)"orderItem\u6279\u91cf\u83b7\u53d6\u4f9b\u5e94\u5546\u552e\u4ef7:{}ms", new Object[]{System.currentTimeMillis() - time});
            if (apiRes != null && apiRes.getStatus() != null && apiRes.getStatus() == HandlerRespVo.RESPONSE_STATUS_SUCCESS) {
                Map resData = (Map)apiRes.getData();
                block2: for (TempOrderItemVo c : tempOrderStoreVo.getOrderItems()) {
                    for (OrderItem oi : order.getOrderItems()) {
                        if (!oi.getProductFashId().equals(c.getProductFashionId())) continue;
                        oi.setTrdSalePrice((BigDecimal)resData.get(c.getProductCode()));
                        continue block2;
                    }
                }
            }
        }
        return totalCounts;
    }

    private OrderItem generateOrderItem(TempOrderItemVo tempOrderItemVo) {
        OrderItem orderItem = new OrderItem();
        orderItem.setCount(tempOrderItemVo.getCount());
        orderItem.setProductName(tempOrderItemVo.getFashionTitle());
        orderItem.setCostPrice(tempOrderItemVo.getCostPrice());
        orderItem.setSalePrice(tempOrderItemVo.getSalePrice());
        orderItem.setOrginSalePrice(tempOrderItemVo.getOrginSalePrice());
        orderItem.setProductPrice(tempOrderItemVo.getMarketPrice());
        orderItem.setMemberPrice(orderItem.getSalePrice());
        orderItem.setFinalPrice(tempOrderItemVo.getSalePrice());
        orderItem.setSeckillPrice(tempOrderItemVo.getSalePrice());
        orderItem.setActivityId(tempOrderItemVo.getActivityId());
        orderItem.setGoodsId(tempOrderItemVo.getGoodsId());
        orderItem.setProductFashId(tempOrderItemVo.getProductFashionId());
        orderItem.setProductId(tempOrderItemVo.getProductId());
        orderItem.setSku(tempOrderItemVo.getProductCode());
        orderItem.setSalePriceRate(tempOrderItemVo.getSalesPriceRate());
        orderItem.setProductType(tempOrderItemVo.getProductType());
        orderItem.setProductPic(tempOrderItemVo.getFashionPic());
        orderItem.setBusinessCode(tempOrderItemVo.getBusinessCode());
        return orderItem;
    }

    public BaseResponse<BigDecimal> queryShippingFee(String storeId, List<TempOrderItemVo> orderItems, String addressId, Boolean useCache) {
        long methodStartTime = System.currentTimeMillis();
        logs.info((Object)"### \u5f00\u59cb\u67e5\u8be2\u8ba2\u5355\u8fd0\u8d39 ... ###");
        BigDecimal shippingFee = null;
        if (useCache.booleanValue()) {
            shippingFee = this.getShippingFeeInCache(storeId, orderItems);
        }
        BaseResponse baseResponse = new BaseResponse(false, "\u83b7\u53d6\u8fd0\u8d39\u5931\u8d25");
        if (useCache.booleanValue() && shippingFee != null) {
            logs.info((Object)"\u4f7f\u7528\u7f13\u5b58\u8fd0\u8d39, shippingFee: {}", new Object[]{shippingFee});
            logs.info((Object)"### \u67e5\u8be2\u8ba2\u5355\u8fd0\u8d39\u603b\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - methodStartTime});
            return new BaseResponse(true, "\u83b7\u53d6\u8fd0\u8d39\u6210\u529f", (Object)shippingFee);
        }
        long addressTime = System.currentTimeMillis();
        MemberAddressDto address = this.memberAddressApi.findById(addressId);
        logs.info((Object)"\u67e5\u8be2\u5730\u5740\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - addressTime});
        Map areaNodeMap = null;
        if (address == null || Lang.isEmpty((Object)address.getId())) {
            long areaNodeMapTime = System.currentTimeMillis();
            areaNodeMap = this.addressCommonApi.areaCodeNodeList(addressId);
            logs.info((Object)"\u67e5\u8be2\u533a\u57df\u4ee3\u7801\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - areaNodeMapTime});
        }
        if (!(Lang.isEmpty((Object)storeId) || Lang.isEmpty((Object)address) && Lang.isEmpty((Object)areaNodeMap))) {
            long checkStoreTime = System.currentTimeMillis();
            HandlerRespVo checkStoreRes = this.outsideProductApi.isOutsideStore(storeId);
            logs.info((Object)"\u68c0\u67e5\u5e97\u94fa\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - checkStoreTime});
            if (checkStoreRes != null && checkStoreRes.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS) && ((Boolean)checkStoreRes.getData()).booleanValue()) {
                ShippingFeeRequetVo shippingFeeRequetVo = new ShippingFeeRequetVo();
                ArrayList<FashionNumsVo> fashionNums = new ArrayList<FashionNumsVo>();
                for (TempOrderItemVo itemVo : orderItems) {
                    FashionNumsVo fashionNumsVo = new FashionNumsVo(itemVo.getProductFashionId(), itemVo.getProductCode(), new Long(itemVo.getCount().intValue()));
                    fashionNums.add(fashionNumsVo);
                }
                shippingFeeRequetVo.setFashionNums(fashionNums);
                if (address != null && !Lang.isEmpty((Object)address.getId())) {
                    shippingFeeRequetVo.setProvinceCode(address.getProvinceCode());
                    shippingFeeRequetVo.setCityCode(address.getCityCode());
                    shippingFeeRequetVo.setCountyCode(address.getAreaCode());
                    shippingFeeRequetVo.setTownCode(address.getTownCode());
                } else {
                    shippingFeeRequetVo.setProvinceCode((String)areaNodeMap.get(1));
                    shippingFeeRequetVo.setCityCode((String)areaNodeMap.get(2));
                    shippingFeeRequetVo.setCountyCode((String)areaNodeMap.get(3));
                    shippingFeeRequetVo.setTownCode((String)areaNodeMap.get(4));
                }
                shippingFeeRequetVo.setAddrDetail(address.getAddressDetail());
                long queryShippingFeeTime = System.currentTimeMillis();
                HandlerRespVo res = this.outsideProductApi.queryShippingFee(storeId, shippingFeeRequetVo);
                logs.info((Object)"\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u8fd0\u8d39\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - queryShippingFeeTime});
                if (res.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
                    logs.info((Object)"### \u67e5\u8be2\u8ba2\u5355\u8fd0\u8d39\u603b\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - methodStartTime});
                    BigDecimal freight = (BigDecimal)((Map)res.getData()).get("freight");
                    if (freight == null) {
                        return new BaseResponse(true, "\u83b7\u53d6\u8fd0\u8d39\u6210\u529f", (Object)new BigDecimal(0));
                    }
                    this.setShippingFeeCache(storeId, orderItems, freight);
                    return new BaseResponse(true, "\u83b7\u53d6\u8fd0\u8d39\u6210\u529f", (Object)freight);
                }
                baseResponse.setResultMessage(res.getMessage());
            } else {
                logs.info((Object)"### \u67e5\u8be2\u8ba2\u5355\u8fd0\u8d39\u603b\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - methodStartTime});
                return new BaseResponse(true, "\u83b7\u53d6\u8fd0\u8d39\u6210\u529f", (Object)new BigDecimal(0));
            }
        }
        logs.info((Object)"### \u67e5\u8be2\u8ba2\u5355\u8fd0\u8d39\u603b\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - methodStartTime});
        return baseResponse;
    }

    public BigDecimal queryCartShippingFee(String storeId, List<CartItemVo> cartItems, String addressId) {
        MemberAddressDto address = this.memberAddressApi.findById(addressId);
        Map areaNodeMap = null;
        if (address == null || Lang.isEmpty((Object)address.getId())) {
            areaNodeMap = this.addressCommonApi.areaCodeNodeList(addressId);
        }
        if (!(Lang.isEmpty((Object)storeId) || Lang.isEmpty((Object)address) && Lang.isEmpty((Object)areaNodeMap))) {
            HandlerRespVo checkStoreRes = this.outsideProductApi.isOutsideStore(storeId);
            if (checkStoreRes != null && checkStoreRes.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS) && ((Boolean)checkStoreRes.getData()).booleanValue()) {
                ShippingFeeRequetVo shippingFeeRequetVo = new ShippingFeeRequetVo();
                ArrayList<FashionNumsVo> fashionNums = new ArrayList<FashionNumsVo>();
                for (CartItemVo itemVo : cartItems) {
                    FashionNumsVo fashionNumsVo = new FashionNumsVo(itemVo.getProductFashId(), itemVo.getProduct().getCode(), new Long(itemVo.getCount().intValue()));
                    fashionNums.add(fashionNumsVo);
                }
                shippingFeeRequetVo.setFashionNums(fashionNums);
                if (address != null && !Lang.isEmpty((Object)address.getId())) {
                    shippingFeeRequetVo.setProvinceCode(address.getProvinceCode());
                    shippingFeeRequetVo.setCityCode(address.getCityCode());
                    shippingFeeRequetVo.setCountyCode(address.getAreaCode());
                    shippingFeeRequetVo.setTownCode(address.getTownCode());
                } else if (areaNodeMap != null) {
                    shippingFeeRequetVo.setProvinceCode((String)areaNodeMap.get(1));
                    shippingFeeRequetVo.setCityCode((String)areaNodeMap.get(2));
                    shippingFeeRequetVo.setCountyCode((String)areaNodeMap.get(3));
                    shippingFeeRequetVo.setTownCode((String)areaNodeMap.get(4));
                }
                HandlerRespVo res = this.outsideProductApi.queryShippingFee(storeId, shippingFeeRequetVo);
                if (res.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
                    return (BigDecimal)((Map)res.getData()).get("freight");
                }
            } else {
                return new BigDecimal(0);
            }
        }
        return null;
    }

    public void reCalFreight(OrderMain orderMain, TempOrderStoreVo storeVo, String memberAddressId, Boolean useCache, Map params) {
        BigDecimal freight;
        try {
            freight = (BigDecimal)this.queryShippingFee(storeVo.getStoreId(), storeVo.getOrderItems(), memberAddressId, Boolean.valueOf(useCache == null ? false : useCache)).getResult();
        }
        catch (Exception E) {
            freight = BigDecimal.ZERO;
        }
        orderMain.setFreight(freight);
        if (!Lang.isEmpty((Object)params) && ((Boolean)params.get("isFreeFreight")).booleanValue()) {
            orderMain.setFreeFreight(freight);
        } else {
            orderMain.setFreeFreight(BigDecimal.ZERO);
        }
        orderMain.reCalSumPrice();
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public void updateGoodsSaleCount(String status, String orderNo) {
        try {
            String countGoodsSaleSql = "select sum(ot.count) from order_item  ot ,order_main om where ot.goods_id=? and om.status in(1,2,3,4,5,7) and om.id=ot.order_id ";
            OrderMain orderMain = this.orderRepos.findByOrderNo(orderNo);
            if (!Lang.isEmpty((Object)orderMain.getOrderItems())) {
                for (OrderItem item : orderMain.getOrderItems()) {
                    Integer saleCount = (Integer)this.jdbcTemplate.queryForObject(countGoodsSaleSql, new Object[]{item.getGoodsId()}, Integer.class);
                    if (Lang.isEmpty((Object)saleCount)) {
                        saleCount = 0;
                    }
                    this.goodsApi.updateGoodsSaleCount(item.getGoodsId(), saleCount.longValue());
                }
            }
        }
        catch (Exception e) {
            logs.error((Object)"\u66f4\u65b0goods\u9500\u552e\u91cf\u51fa\u9519", new Object[]{e});
        }
    }

    public Page<Map<String, Object>> queryForInvoicePrint(String companyCodeTpds, String storeId, String orderNo, String compName, String payMethod, List<String> orderStatus, List<String> invoiceStatus, Date createTimeLower, Date createTimeHigher, String orgId, List<String> fields, String invoiceType, Pageable pageable) {
        String storeType;
        String orderSelects = "o.*";
        ArrayList<String> queryFields = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (!Lang.isEmpty(fields)) {
            for (String f : fields) {
                if ("invoice_money".equals(f)) {
                    queryFields.add(" (SELECT SUM(i.money) from sp_invoice_info i WHERE i.member_invoice_id = member_invoice.id and i.is_delete = 0 ) as invoice_money ");
                } else if ("invoice_tax".equals(f)) {
                    queryFields.add(" (SELECT SUM(i.tax) from sp_invoice_info i WHERE i.member_invoice_id = member_invoice.id and i.is_delete = 0 ) as invoice_tax ");
                } else if ("invoice_no_tax_price".equals(f)) {
                    queryFields.add(" (SELECT SUM(i.money) - SUM(i.tax) from sp_invoice_info i WHERE i.order_id = o.id and i.is_delete = 0 ) as invoice_no_tax_price ");
                } else if ("invoice_tax_rate".equals(f)) {
                    queryFields.add(" (SELECT SUM(i.tax) / (SUM(i.money) - SUM(i.tax)) from sp_invoice_info i WHERE i.order_id = o.id and i.is_delete = 0 ) as invoice_tax_rate ");
                } else if (!f.contains(".")) {
                    queryFields.add("o." + f);
                } else {
                    queryFields.add(f);
                }
                fieldNames.add(f);
            }
            orderSelects = Joiner.on((String)",").skipNulls().join(queryFields);
            fieldNames.add("pay_method_name");
            fieldNames.add("store_name");
            fieldNames.add("org_name");
            fieldNames.add("item_counts");
            fieldNames.add("invoice_type");
        }
        StringBuilder sql = new StringBuilder().append("SELECT ").append(orderSelects).append(" , payment_config.name AS pay_method_name, (SELECT store_ext.store_name FROM store_ext store_ext WHERE store_ext.store_id = sotre.id) AS store_name, organization.org_name ").append(" , (SELECT COUNT(0) from ORDER_ITEM item WHERE item.order_id = o.id) AS item_counts").append(" ,  member_invoice.type AS invoice_type");
        StringBuilder countSql = new StringBuilder().append("SELECT COUNT(0) ");
        StringBuilder where = new StringBuilder().append(" FROM ORDER_MAIN o, PAYMENT payment , PAYMENT_CONFIG payment_config, STORE sotre, ORGANIZATION organization, MEMBER_IN_VOICE member_invoice ").append("WHERE payment.id = o.payment_id AND payment_config.id = payment.payment_mode_id AND sotre.id = o.store_id  AND (member_invoice.id = o.invoice_id or member_invoice.order_no = o.order_no) AND organization.id = o.organization_id ");
        ArrayList<Object> arrs = new ArrayList<Object>();
        StringBuilder invoiceInfoSubQuery = new StringBuilder();
        invoiceInfoSubQuery.append(" AND (SELECT COUNT(0) from sp_invoice_info i WHERE i.order_id = o.id AND i.can_invoice_time <= ?1 AND i.is_delete != 1");
        arrs.add(new Date());
        if (!Lang.isEmpty((Object)compName)) {
            arrs.add("%" + compName + "%");
            invoiceInfoSubQuery.append(" AND i.name like ?").append(arrs.size()).append(" ");
        }
        invoiceInfoSubQuery.append(") > 0 ");
        where.append((CharSequence)invoiceInfoSubQuery);
        if (!Lang.isEmpty(invoiceStatus)) {
            arrs.add(invoiceStatus);
            where.append(" AND (select count(0) from sp_invoice_info i where i.MEMBER_INVOICE_ID = member_invoice.id AND i.status in ?").append(arrs.size()).append(" ) > 0 ");
        }
        if (!Lang.isEmpty((Object)storeId)) {
            arrs.add(storeId);
            where.append(" AND o.store_id=?" + arrs.size());
        }
        if (!Lang.isEmpty((Object)orderNo)) {
            arrs.add("%" + orderNo + "%");
            where.append(" AND o.order_No like ?" + arrs.size());
        }
        if (!Lang.isEmpty((Object)orgId)) {
            arrs.add(orgId);
            where.append(" AND o.organization_id=?" + arrs.size());
        }
        if (!Lang.isEmpty((Object)payMethod)) {
            arrs.add(payMethod);
            where.append(" AND payment_config.id=?" + arrs.size());
        }
        if (!Lang.isEmpty((Object)createTimeLower)) {
            arrs.add(createTimeLower);
            where.append(" AND o.date_created >= ?" + arrs.size());
        }
        if (!Lang.isEmpty((Object)createTimeHigher)) {
            arrs.add(createTimeHigher);
            where.append(" AND o.date_created < ?" + arrs.size());
        }
        if (!Lang.isEmpty(orderStatus)) {
            arrs.add(orderStatus);
            where.append(" AND o.status in ?" + arrs.size());
        }
        if (!Lang.isEmpty((Object)(storeType = "2"))) {
            arrs.add(storeType);
            where.append(" AND o.store_type <> ?" + arrs.size());
        }
        if (!Lang.isEmpty((Object)invoiceType)) {
            arrs.add(invoiceType);
            where.append(" AND (select count(0) from sp_invoice_info i where i.MEMBER_INVOICE_ID = member_invoice.id AND i.type in ?").append(arrs.size()).append(" ) > 0 ");
        }
        if (!Lang.isEmpty((Object)companyCodeTpds)) {
            arrs.add(companyCodeTpds);
            where.append(" and o.company_id not in (select id from core_company  where code = ?" + arrs.size() + ") ");
        }
        where.append(" AND (select count(0) from sp_invoice_info i where i.MEMBER_INVOICE_ID = member_invoice.id AND i.type is not null )>0 ");
        countSql.append((CharSequence)where);
        sql.append((CharSequence)where);
        sql.append(" order by o.order_no asc, o.date_created asc");
        logs.info((Object)"countSql:{}", new Object[]{countSql.toString()});
        logs.info((Object)"sql:{}", new Object[]{sql.toString()});
        Query totalCountQuery = this.entityManager.createNativeQuery(countSql.toString());
        Query dataQuery = this.entityManager.createNativeQuery(sql.toString());
        for (int i = 0; i < arrs.size(); ++i) {
            totalCountQuery.setParameter(i + 1, arrs.get(i));
            dataQuery.setParameter(i + 1, arrs.get(i));
        }
        List countRs = totalCountQuery.getResultList();
        Integer total = 0;
        if (!Lang.isEmpty((Object)countRs) && !Lang.isEmpty(countRs.get(0))) {
            total = ((BigDecimal)countRs.get(0)).intValue();
        }
        if (pageable != null && pageable.getOffset() < total && pageable.getPageSize() > 0) {
            dataQuery.setFirstResult(pageable.getOffset());
            dataQuery.setMaxResults(pageable.getPageSize());
        }
        List resultList = dataQuery.getResultList();
        ArrayList returnList = new ArrayList();
        if (Lang.isEmpty(fields)) {
            for (Object[] objects : resultList) {
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                for (int i = 0; i < objects.length; ++i) {
                    tempMap.put("" + i, objects[i]);
                }
                returnList.add(tempMap);
            }
        } else {
            for (Object[] objects : resultList) {
                HashMap tempMap = new HashMap();
                for (int i = 0; i < fieldNames.size(); ++i) {
                    tempMap.put(fieldNames.get(i), objects[i]);
                }
                returnList.add(tempMap);
            }
        }
        PageImpl page = new PageImpl(returnList, pageable, (long)total.intValue());
        return page;
    }

    public List<Map<String, Object>> findSubOrderItemBySubOrderNo(String subOrderNo) {
        String sql = "select so.sub_order_no,g.sku,g.sku,g.name,oi.cost_price,oi.count\n  from sub_order so, sub_order_item soi, goods g, order_item oi\n where so.id = soi.sub_order_id\n   and soi.order_item_id = oi.id\n   and oi.goods_id = g.id\n   and so.sub_order_no = ? ";
        return this.jdbcTemplate.queryForList(sql, new Object[]{subOrderNo});
    }

    public OrderMainDto transToDto(OrderMain orderMain) {
        if (orderMain == null) {
            return null;
        }
        OrderMainDto dto = (OrderMainDto)this.mapperFacade.map((Object)orderMain, OrderMainDto.class);
        return dto;
    }

    public List<OrderMainDto> transToDto(List<OrderMain> orderMains) {
        if (orderMains == null || orderMains.size() <= 0) {
            return null;
        }
        List dtos = this.mapperFacade.mapAsList(orderMains, OrderMainDto.class);
        return dtos;
    }

    public void filterMerchandise(List<OrderMainDto> dtos) {
        dtos.forEach(orderMainDto -> {
            List orderItems = orderMainDto.getOrderItems();
            List merchandiseOrderItems = orderItems.stream().filter(orderItemDto -> "1".equals(orderItemDto.getProductType())).collect(Collectors.toList());
            orderMainDto.setOrderItems(merchandiseOrderItems);
        });
    }

    public List<OrderMainDto> buildOrderItemRelations(List<OrderMainDto> orderMainDtoList) {
        ArrayList<String> orderItemParentIds = new ArrayList<String>();
        ArrayList<OrderItemDto> allItems = new ArrayList<OrderItemDto>();
        for (OrderMainDto omd : orderMainDtoList) {
            for (OrderItemDto oid : omd.getOrderItems()) {
                allItems.add(oid);
                if (!"1".equals(oid.getProductType())) continue;
                orderItemParentIds.add(oid.getId());
            }
        }
        List orderItemRelations = this.orderItemRelationsRepos.findAll((root, query, cb) -> {
            ArrayList<Predicate> andQuerys = new ArrayList<Predicate>();
            ArrayList<Predicate> pidOrQuerys = new ArrayList<Predicate>();
            for (String pItemId : orderItemParentIds) {
                pidOrQuerys.add(cb.equal((Expression)root.get("parentId"), (Object)pItemId));
            }
            if (pidOrQuerys.size() > 0) {
                andQuerys.add(cb.or(pidOrQuerys.toArray(new Predicate[0])));
            }
            andQuerys.add(cb.or(new Predicate[]{cb.equal((Expression)root.get("type"), (Object)OrderItemRelations.PROD_RELATE_TYPE_SUBORDINATE)}));
            return cb.and(andQuerys.toArray(new Predicate[0]));
        });
        if (orderItemRelations != null && orderItemRelations.size() > 0) {
            HashMap<String, ArrayList<Object>> orderItemRelateMap = new HashMap<String, ArrayList<Object>>();
            List<Object> tmpOrderItemDtos = null;
            for (OrderItemRelations r : orderItemRelations) {
                tmpOrderItemDtos = (ArrayList<Object>)orderItemRelateMap.get(r.getParentId());
                if (tmpOrderItemDtos == null) {
                    tmpOrderItemDtos = new ArrayList<Object>();
                }
                tmpOrderItemDtos.add(Lang.findInBeanList(allItems, (String)"id", (Object)r.getChildId()));
                orderItemRelateMap.put(r.getParentId(), (ArrayList<Object>)tmpOrderItemDtos);
            }
            for (OrderMainDto omd : orderMainDtoList) {
                for (OrderItemDto oid : omd.getOrderItems()) {
                    if (!"1".equals(oid.getProductType())) continue;
                    tmpOrderItemDtos = (List)orderItemRelateMap.get(oid.getId());
                    oid.setChildren(tmpOrderItemDtos);
                }
            }
        }
        return orderMainDtoList;
    }

    public OrderMainDto buildOrderItemRelations(OrderMainDto orderMainDto) {
        List orderMainDtos = this.buildOrderItemRelations(Arrays.asList(orderMainDto));
        if (orderMainDtos != null && orderMainDtos.size() > 0) {
            return (OrderMainDto)orderMainDtos.get(0);
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void changeAuditFlag(String orderId, Boolean auditFlag) {
        OrderMain orderMain = (OrderMain)this.orderRepos.getOne((Serializable)((Object)orderId));
        if (orderMain != null) {
            orderMain.setAuditFlag(auditFlag);
            this.orderRepos.save((Object)orderMain);
        }
    }

    public List<OrderMain> findAll(OrderMain orderMainSpec, OrderMainExt orderMainExt) {
        Specification specification = this.getSpecification(orderMainSpec, orderMainExt);
        return this.orderRepos.findAll(specification);
    }

    public Page<OrderMain> findAll(OrderMain orderMainSpec, OrderMainExt orderMainExt, Pageable pageable) {
        Specification specification = this.getSpecification(orderMainSpec, orderMainExt);
        return this.orderRepos.findAll(specification, pageable);
    }

    private Specification getSpecification(OrderMain orderMain, OrderMainExt orderMainExt) {
        return (root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (!Lang.isEmpty((Object)orderMain.getMemberId())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("memberId"), (Object)orderMain.getMemberId()));
            }
            if (!Lang.isEmpty((Object)orderMain.getStatus())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("status"), (Object)orderMain.getStatus()));
            } else {
                predicates.add(criteriaBuilder.notEqual((Expression)root.get("status"), (Object)"0"));
                predicates.add(criteriaBuilder.notEqual((Expression)root.get("status"), (Object)"9"));
            }
            if (!Lang.isEmpty((Object)orderMain.getOrderNo())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("orderNo"), (Object)orderMain.getOrderNo()));
            }
            if (!Lang.isEmpty((Object)orderMain.getStoreType())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("storeType"), (Object)orderMain.getStoreType()));
            }
            if (orderMain.getIsDelete() != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("isDelete"), (Object)orderMain.getIsDelete()));
            }
            if (!Lang.isEmpty((Object)orderMain.getId())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("id"), (Object)orderMain.getId()));
            }
            if (!Lang.isEmpty((Object)orderMain.getHaveReview())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("haveReview"), (Object)orderMain.getHaveReview()));
            }
            if (!Lang.isEmpty((Object)orderMainExt)) {
                if (!Lang.isEmpty((Object)orderMainExt.getCreateTimeLowerBound())) {
                    predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("createTime"), (Comparable)orderMainExt.getCreateTimeLowerBound()));
                }
                if (!Lang.isEmpty((Object)orderMainExt.getCreateTimeUpBound())) {
                    predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get("createTime"), (Comparable)orderMainExt.getCreateTimeUpBound()));
                }
            }
            if (!Lang.isEmpty((Object)orderMain.getHaveReview())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("haveReview"), (Object)orderMain.getHaveReview()));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
        };
    }

    public Long countByRequerstId(String requerstId) {
        return this.orderRepos.countByRequestId(requerstId);
    }

    public Boolean checkSuccessedByRequestId(String requestId) {
        Long counts = this.orderRepos.count((root, query, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get("requestId"), (Object)requestId), cb.notEqual((Expression)root.get("isDelete"), (Object)true), cb.notEqual((Expression)root.get("status"), (Object)"6")}));
        return counts > 0L;
    }

    public Long countOrder(String memberId, List<String> status, boolean isDelete) {
        return this.orderRepos.countByMemberIdAndStatusInAndIsDelete(memberId, status, isDelete);
    }

    public void updateOrderFirstAuditTime(String orderId) {
        this.orderRepos.updateOrderFirstAuditTime(new Date(), orderId);
    }

    public void updateOrderAuditEndTime(String orderId) {
        this.orderRepos.updateOrderAuditEndTime(new Date(), orderId);
    }

    public Long countOrderNotCommemted(String memberId, List<String> status, boolean isDelete, boolean haveReview) {
        return this.orderRepos.countByMemberIdAndStatusInAndIsDeleteAndHaveReviewNot(memberId, status, isDelete, haveReview);
    }

    public OrderMain findByOrderNoAndMemberId(String orderNo, String memberId) {
        return this.orderRepos.findByOrderNoAndMemberId(orderNo, memberId);
    }

    public OrderMain findByOrderNo(String orderNo) {
        return this.orderRepos.findByOrderNo(orderNo);
    }

    public List<OrderItem> findByOrderId(String orderId) {
        return this.orderItemRepos.findByOrderId(orderId);
    }

    public List<OrderItem> findByOrderIdAndIsDiscussOrIsDiscussIsNull(String id, Boolean isDelete) {
        return this.orderItemRepos.findByOrderIdAndIsDiscussOrIsDiscussIsNull(id, isDelete);
    }

    public void saveAndFlush(OrderMain orderMain) {
        this.orderRepos.saveAndFlush((Object)orderMain);
    }

    public OrderMain findByOrderNoAndStatusIn(String orderNo, List<String> status) {
        return this.orderRepos.findByOrderNoAndStatusIn(orderNo, status);
    }

    public List<OrderMainDto> findByOrderNos(List<String> orderNos) {
        List orderMains = this.orderRepos.findByOrderNoIn(orderNos);
        List orderMainDtos = BeanMapper.mapList((Iterable)orderMains, OrderMain.class, OrderMainDto.class);
        return orderMainDtos;
    }

    public List<OrderMainDto> findByStatusAndShippingComfirmTimeIsNull(String status) {
        List orderMains = this.orderRepos.findByStatusAndShippingComfirmTimeIsNull(status);
        List orderMainDtos = BeanMapper.mapList((Iterable)orderMains, OrderMain.class, OrderMainDto.class);
        return orderMainDtos;
    }

    public List<OrderMainDto> findByOrganizationIdAndAuditEndTimeIsNotNullAndBillsCreated(String organizationId, boolean billsCreated) {
        List orderMains = this.orderRepos.findByOrganizationIdAndAuditEndTimeIsNotNullAndBillsCreated(organizationId, Boolean.valueOf(billsCreated));
        List orderMainDtos = BeanMapper.mapList((Iterable)orderMains, OrderMain.class, OrderMainDto.class);
        return orderMainDtos;
    }

    private BigDecimal getShippingFeeInCache(String storeId, List<TempOrderItemVo> orderItems) {
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(storeId).append("_").append(Joiner.on((String)"_").join((Iterable)orderItems.stream().map(tempOrderItemVo -> String.format("%s_%s", tempOrderItemVo.getProductCode(), tempOrderItemVo.getCount())).collect(Collectors.toList())));
        return (BigDecimal)this.shippingFeeOps.get((Object)cacheKey.toString());
    }

    private void setShippingFeeCache(String storeId, List<TempOrderItemVo> orderItems, BigDecimal value) {
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(storeId).append("_").append(Joiner.on((String)"_").join((Iterable)orderItems.stream().map(tempOrderItemVo -> String.format("%s_%s", tempOrderItemVo.getProductCode(), tempOrderItemVo.getCount())).collect(Collectors.toList())));
        this.shippingFeeOps.set((Object)cacheKey.toString(), (Object)value, 10L, TimeUnit.MINUTES);
    }

    private FashionPriceVo getProductPriceInCache(String storeKey, String sku) {
        FashionPriceVo fashionPriceVo = (FashionPriceVo)this.productPriceOps.get((Object)String.format("cache.orderservice.product.price.%s_%s", storeKey, sku));
        logs.info((Object)"\u4f7f\u7528\u7f13\u5b58\u4ef7\u683c-> storeKey: {}, sku: {}, price: {}", new Object[]{storeKey, sku, fashionPriceVo});
        return fashionPriceVo;
    }

    private void setProductPriceInCache(String storeKey, String sku, FashionPriceVo value) {
        this.productPriceOps.set((Object)String.format("cache.orderservice.product.price.%s_%s", storeKey, sku), (Object)value, 10L, TimeUnit.MINUTES);
    }

    public String findStatusByOrderNo(String orderNo) {
        return this.orderRepos.findStatusByOrderNo(orderNo);
    }

    public String findOrderNoById(String id) {
        return this.orderRepos.findOrderNoById(id);
    }

    public String findIdByOrderNo(String orderNo) {
        return this.orderRepos.findIdByOrderNo(orderNo);
    }

    public String findStoreTypeByOrderNo(String orderNo) {
        return this.orderRepos.findStoreTypeByOrderNO(orderNo);
    }

    public String findAddressIdByOrderNo(String orderNo) {
        return this.orderRepos.findAddressIdByOrderNo(orderNo);
    }

    public int cancelOrder(OrderKey key, Contants.CancelOrderType cancelOrderType) {
        String newOrderStatus = "6";
        switch (1.$SwitchMap$order$Contants$CancelOrderType[cancelOrderType.ordinal()]) {
            case 1: {
                newOrderStatus = "9";
                break;
            }
            case 2: {
                newOrderStatus = "8";
                break;
            }
            default: {
                newOrderStatus = "6";
            }
        }
        if (Lang.isEmpty((Object)key.getOrderId())) {
            return this.orderRepos.updateStatusByOrderNo(key.getOrderNo(), newOrderStatus);
        }
        return this.orderRepos.updateStatusById(key.getOrderId(), newOrderStatus);
    }

    @Transactional(readOnly=false)
    public OrderMain saveOrder(OrderMain orderMain, Boolean flush) {
        if (flush.booleanValue()) {
            return (OrderMain)this.orderRepos.saveAndFlush((Object)orderMain);
        }
        return (OrderMain)this.orderRepos.save((Object)orderMain);
    }

    public void updateBatchStatusByOrderNo(List<String> orderNo, GlobalContants.ORDER_STATUS status) {
        if (orderNo != null && !orderNo.isEmpty()) {
            this.orderRepos.updateBatchStatusByOrderNo(status.getValue(), orderNo);
        }
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public void updateTrdOrderInfo(OrderKey orderKey, TrdOrder trdOrder) {
        OrderMain orderMain = this.orderMainQueryService.findByKey(orderKey);
        orderMain.setStatus(trdOrder.getFinalStatus().getValue());
        List subOrderList = orderMain.getSubOrders();
        List subOrderTrdNos = subOrderList.stream().map(SubOrder::getSubOrderNo).collect(Collectors.toList());
        ArrayList trdSubOrderNos = trdOrder.getCorders() == null ? new ArrayList() : trdOrder.getCorders().stream().map(TrdOrder::getTrdOrderNo).collect(Collectors.toList());
        List deletedTrdNos = subOrderTrdNos;
        deletedTrdNos.removeAll(trdSubOrderNos);
        ArrayList addedTrdNos = trdSubOrderNos;
        addedTrdNos.removeAll(subOrderTrdNos);
        if (deletedTrdNos.size() > 0) {
            this.subOrderRepos.delete((Iterable)subOrderList.stream().filter(it -> deletedTrdNos.contains(it.getSubOrderNo())).collect(Collectors.toList()));
            subOrderList.removeIf(it -> deletedTrdNos.contains(it.getSubOrderNo()));
        }
        for (SubOrder so : subOrderList) {
            String subOrderNo = so.getSubOrderNo();
            Optional<TrdOrder> tOrder = trdOrder.getCorders().stream().filter(it -> it.getTrdOrderNo().equals(subOrderNo)).findFirst();
            if (!tOrder.isPresent()) continue;
            List supplierOrderSkus = tOrder.get().getSku().stream().map(TrdOrderSku::getSkuId).collect(Collectors.toList());
            SubOrder newSubOrder = OrderHelper.toSubOrder((TrdOrder)tOrder.get(), (OrderMain)orderMain);
            newSubOrder.setId(so.getId());
            newSubOrder.setVersion(so.getVersion());
            newSubOrder.setDateCreated(so.getDateCreated());
            newSubOrder.setIsDelete(Boolean.valueOf(false));
            so = newSubOrder;
            so.setOrder(orderMain);
        }
        if (addedTrdNos.size() > 0) {
            for (String trdNo : addedTrdNos) {
                trdOrder.getCorders().stream().filter(it -> it.getTrdOrderNo().equals(trdNo)).findFirst().ifPresent(it -> subOrderList.add(OrderHelper.toSubOrder((TrdOrder)it, (OrderMain)orderMain)));
            }
        }
        orderMain.setThirdOrderNo(trdOrder.getTrdOrderNo());
        orderMain.setSubOrders(subOrderList);
        this.orderRepos.saveAndFlush((Object)orderMain);
    }

    public OrderVo toOrderVo(OrderMain orderMain, Payment payment, MemberAddressDto memberAddress) {
        OrderVo orderVo = (OrderVo)BeanMapper.map((Object)orderMain, (Type)BeanMapper.getType(OrderMain.class), (Type)BeanMapper.getType(OrderVo.class));
        orderVo.setOrderItems(BeanMapper.mapList((Iterable)orderMain.getOrderItems(), (Type)BeanMapper.getType(OrderItem.class), (Type)BeanMapper.getType(OrderItemVo.class)));
        orderVo.setPayment((OrderPaymentVo)BeanMapper.map((Object)payment, (Type)BeanMapper.getType(Payment.class), (Type)BeanMapper.getType(OrderPaymentVo.class)));
        orderVo.setOrderReceiver((OrderReceiver)BeanMapper.map((Object)memberAddress, (Type)BeanMapper.getType(MemberAddressDto.class), (Type)BeanMapper.getType(OrderReceiver.class)));
        orderVo.setOrderId(orderMain.getId());
        orderVo.setOrderNo(orderMain.getOrderNo());
        return orderVo;
    }
}

