/*
 * Decompiled with CFR 0.152.
 */
package order.service.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import payment.model.po.PayLog;
import payment.model.po.Payment;
import payment.model.po.PaymentConfig;
import payment.model.repository.PayLogRepos;
import payment.model.repository.PaymentConfigRepos;
import payment.model.repository.PaymentRepos;
import utils.lang.Copys;

@Service
@Transactional(readOnly=true, rollbackFor={Exception.class})
public class PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentService.class);
    @Autowired
    PaymentConfigRepos paymentConfigRepos;
    @Autowired
    PaymentRepos paymentRepos;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    PayLogRepos payLogRepos;

    @Transactional(readOnly=false)
    public Payment saveOrUpdate(Payment payment, Boolean flush) {
        Copys copys = Copys.create();
        PaymentConfig config = this.paymentConfigRepos.findById(payment.getConfig().getId());
        if (config == null) {
            config = new PaymentConfig();
            copys.from((Object)payment.getConfig()).to(new Object[]{config}).clear();
            this.paymentConfigRepos.save((Object)config);
        }
        Payment p = new Payment();
        copys.from((Object)payment).excludes(new String[]{"config"}).to(new Object[]{p}).clear();
        p.setConfig(config);
        if (flush.booleanValue()) {
            return this.paymentRepos.saveAndFlush(p);
        }
        return (Payment)this.paymentRepos.save((Object)p);
    }

    @Transactional(readOnly=true)
    public Payment findByid(String id) {
        Payment payment = this.paymentRepos.findById(id);
        payment.setConfig(this.paymentConfigRepos.findById(payment.getConfig().getId()));
        return payment;
    }

    @Transactional(readOnly=true)
    public List<Payment> findByIds(List<String> ids) {
        ArrayList configList = new ArrayList();
        List paymentList = this.paymentRepos.findByIdIn(ids);
        Copys copys = Copys.create();
        for (Payment payment : paymentList) {
            if (payment == null) continue;
            PaymentConfig newConfig = new PaymentConfig();
            copys.clear().excludes(new String[]{"payment"}).from((Object)payment.getConfig()).to(new Object[]{newConfig});
            payment.setConfig(newConfig);
        }
        return this.paymentRepos.findByIdIn(ids);
    }

    public Payment cpyPayment(Payment payment) {
        Copys copys = Copys.create();
        PaymentConfig config = this.paymentConfigRepos.findById(payment.getConfig().getId());
        if (config == null) {
            config = new PaymentConfig();
            copys.from((Object)payment.getConfig()).to(new Object[]{config}).clear();
        }
        Payment p = new Payment();
        copys.from((Object)payment).excludes(new String[]{"config"}).to(new Object[]{p}).clear();
        p.setConfig(config);
        return p;
    }

    public int updatePaymentPayLogId(String paymentId, Integer payLogId) {
        String sql = "update payment set pay_log_id = ? where id = ?";
        int number = this.jdbcTemplate.update(sql, new Object[]{payLogId, paymentId});
        return number;
    }

    public String getPayStatus(Integer payLogId) {
        PayLog payLog = (PayLog)this.payLogRepos.findOne((Serializable)payLogId);
        if (payLog == null) {
            throw new RuntimeException("\u652f\u4ed8\u6210\u529f\u65f6,\u68c0\u6d4b\u5230payLog\u4e0d\u5b58\u5728");
        }
        return payLog.getStatus();
    }

    @Transactional(readOnly=false)
    public int updatePayLogStatus(Integer payLogId, String status) {
        String sql = "update pay_log set status =? where id=?";
        int number = this.jdbcTemplate.update(sql, new Object[]{status, payLogId});
        return number;
    }

    @Transactional(readOnly=false)
    public int updatePaymentStatus(String paymentId, String status) {
        String sql = "update payment set status =?,last_updated=? where id=?";
        int number = this.jdbcTemplate.update(sql, new Object[]{status, new Date(), paymentId});
        return number;
    }
}

