/*
 * Decompiled with CFR 0.152.
 */
package order.service.service.impl;

import java.util.List;
import java.util.stream.Collectors;
import order.Contants;
import order.exceptions.IllegalAreaCodeException;
import order.exceptions.temporder.TempOrderCreateException;
import order.model.repository.OrderRepos;
import order.service.service.OrderService;
import order.service.utils.OrderTemplateFactoryUtil;
import order.vo.CancelOrderResp;
import order.vo.CusPayInfo;
import order.vo.OrderKey;
import order.vo.OrderPayConfirmResp;
import order.vo.OrderStatus;
import order.vo.OrderTemplateConfigKey;
import order.vo.OrderVo;
import order.vo.TempOrderCreateRequest;
import order.vo.TempOrderVo;
import order.vo.response.OrderAuditingResult;
import order.vo.response.OrderPrice;
import order.vo.response.OrderStock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="batchOrderService")
public class BatchOrderServiceImpl
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(BatchOrderServiceImpl.class);
    @Autowired
    OrderTemplateFactoryUtil orderTemplateFactoryUtil;
    @Autowired
    OrderRepos orderRepos;

    public TempOrderVo newTempOrder(TempOrderCreateRequest tempOrderCreateRequest) throws TempOrderCreateException {
        log.info("batchOrderService.newTempOrder");
        List entityGoods = tempOrderCreateRequest.getGoodsInfoVos().stream().filter(it -> "1".equals(it.goodsType)).collect(Collectors.toList());
        List virturlGoods = tempOrderCreateRequest.getGoodsInfoVos().stream().filter(it -> "2".equals(it.goodsType)).collect(Collectors.toList());
        TempOrderVo entityGoodsTempOrder = null;
        TempOrderVo virtualGoodsTempOrder = null;
        TempOrderVo createdTempOrder = null;
        OrderTemplateConfigKey orderTemplateConfigKey = new OrderTemplateConfigKey();
        orderTemplateConfigKey.setOrgCode(tempOrderCreateRequest.getOrganizationCode());
        if (entityGoodsTempOrder == null || virtualGoodsTempOrder == null) {
            createdTempOrder = entityGoodsTempOrder == null ? virtualGoodsTempOrder : entityGoodsTempOrder;
        }
        return createdTempOrder;
    }

    public OrderStock tempOrderStock(TempOrderVo tempOrderVo) throws IllegalAreaCodeException {
        return null;
    }

    public OrderPrice tempOrderPrice(TempOrderVo tempOrderVo) {
        return null;
    }

    public OrderVo submit(TempOrderVo tempOrder) {
        return null;
    }

    public List<OrderVo> refresh(List<OrderKey> orderKeys) {
        return null;
    }

    public OrderAuditingResult audit(OrderKey orderKey, Boolean passed, Boolean cancelSupplierOrder) {
        return null;
    }

    public List<OrderAuditingResult> audit(List<OrderKey> orderKeys, Boolean passed, Boolean cancelSupplierOrder) {
        return null;
    }

    public void prePayDone(OrderKey orderKey, CusPayInfo cusPayInfo) {
    }

    public OrderPayConfirmResp payComfirmed(OrderKey orderKey) {
        return null;
    }

    public CancelOrderResp cancel(List<OrderKey> orderVos, Contants.CancelOrderType cancelType) {
        return null;
    }

    public void receipt(OrderKey orderKey, String receiptType) {
    }

    public void statusChange(OrderStatus orderStatus) {
    }
}

