/*
 * Decompiled with CFR 0.152.
 */
package order.service.service.impl;

import com.google.common.base.Joiner;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import ma.glasnost.orika.metadata.Type;
import member.api.dto.shop.MemberAddressDto;
import order.Contants;
import order.exceptions.IllegalAreaCodeException;
import order.exceptions.NoStockException;
import order.exceptions.OrderCreateException;
import order.exceptions.temporder.TempOrderCreateException;
import order.model.po.OrderMain;
import order.model.repository.OrderRepos;
import order.service.events.OrderCreateEvent;
import order.service.events.OrderEvent;
import order.service.events.OrderShippingComfirmedEvent;
import order.service.events.OrderStatusChangeEvent;
import order.service.factory.OrderTemplateFactory;
import order.service.operator.OrderFreightOperator;
import order.service.operator.OrderPriceOperator;
import order.service.operator.OrderStockOperator;
import order.service.operator.OrgSalesPriceOperator;
import order.service.order.helper.OrderHelper;
import order.service.order.helper.TempOrderHelper;
import order.service.order.templates.OrderTemplate;
import order.service.service.OrderMainService;
import order.service.service.OrderService;
import order.service.service.PaymentService;
import order.service.service.impl.DefaultOrderServiceImpl;
import order.service.service.query.OrderMainQueryService;
import order.service.stubs.MemberAddressApiStub;
import order.service.stubs.OrganizationApiStub;
import order.service.stubs.ProductFashionApiStub;
import order.service.utils.OrderTemplateFactoryUtil;
import order.vo.CancelOrderDetailResp;
import order.vo.CancelOrderResp;
import order.vo.CreateOrderRequest;
import order.vo.CusPayInfo;
import order.vo.GoodsInfoVo;
import order.vo.OrderKey;
import order.vo.OrderPayConfirmResp;
import order.vo.OrderStatus;
import order.vo.OrderTemplateConfigKey;
import order.vo.OrderVo;
import order.vo.TempOrderCreateRequest;
import order.vo.TempOrderVo;
import order.vo.TempSubOrderVo;
import order.vo.response.OrderAuditingResult;
import order.vo.response.OrderFreight;
import order.vo.response.OrderPrice;
import order.vo.response.OrderStock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierOrderComfirmFalidException;
import payment.model.po.Payment;
import sinomall.global.common.response.BaseResponse;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.data.Beans;

@Component(value="orderService")
@Transactional(readOnly=true, rollbackFor={Exception.class})
public class DefaultOrderServiceImpl
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(DefaultOrderServiceImpl.class);
    @Autowired
    OrderTemplateFactoryUtil orderTemplateFactoryUtil;
    @Autowired
    TempOrderHelper tempOrderHelper;
    @Autowired
    OrgSalesPriceOperator orgSalesPriceOperator;
    @Autowired
    ProductFashionApiStub productFashionApi;
    @Autowired
    OrderStockOperator orderStockOperator;
    @Autowired
    OrderPriceOperator orderPriceOperator;
    @Autowired
    OrderFreightOperator orderFreightOperator;
    @Autowired
    OrderRepos orderRepos;
    @Autowired
    OrderHelper orderHelper;
    @Autowired
    OrganizationApiStub organizationApi;
    @Autowired
    OrderMainQueryService orderMainQueryService;
    @Autowired
    PaymentService paymentService;
    @Autowired
    MemberAddressApiStub memberAddressApi;
    @Autowired
    OrderMainService orderMainService;

    public TempOrderVo newTempOrder(TempOrderCreateRequest tempOrderCreateRequest) throws TempOrderCreateException {
        log.info("orderService.newTempOrder");
        TempOrderVo createdTempOrder = null;
        if (tempOrderCreateRequest.getGoodsInfoVos() != null) {
            tempOrderCreateRequest.setGoodsInfoVos(tempOrderCreateRequest.getGoodsInfoVos().stream().filter(Objects::nonNull).collect(Collectors.toList()));
            if (tempOrderCreateRequest.getGoodsInfoVos().isEmpty()) {
                throw new TempOrderCreateException(Contants.TEMPORDER_CREATE_ERROR.GOODS_NOT_PROVIDED);
            }
        } else {
            throw new TempOrderCreateException(Contants.TEMPORDER_CREATE_ERROR.GOODS_NOT_PROVIDED);
        }
        Map<String, List<GoodsInfoVo>> groupingGoods = tempOrderCreateRequest.getGoodsInfoVos().stream().collect(Collectors.groupingBy(GoodsInfoVo::getGoodsType));
        boolean hasMutileGoodsTypes = false;
        if (groupingGoods.entrySet().size() > 1) {
            hasMutileGoodsTypes = true;
        }
        OrderTemplateConfigKey orderTemplateConfigKey = new OrderTemplateConfigKey();
        orderTemplateConfigKey.setOrgCode(tempOrderCreateRequest.getOrganizationCode());
        orderTemplateConfigKey.setOrderMode("1");
        OrderTemplateFactory factory = this.orderTemplateFactoryUtil.getOrderTemplateFactory();
        ArrayList<TempOrderVo> tempOrderVos = new ArrayList<TempOrderVo>();
        for (Map.Entry<String, List<GoodsInfoVo>> e : groupingGoods.entrySet()) {
            orderTemplateConfigKey.setGoodsType(e.getKey());
            OrderTemplate orderTemplate = factory.getOrderTemplate(orderTemplateConfigKey);
            TempOrderCreateRequest requestNew = (TempOrderCreateRequest)Beans.clone((Serializable)tempOrderCreateRequest);
            requestNew.setGoodsInfoVos(e.getValue());
            requestNew.setGoodsType(e.getKey());
            TempOrderVo tempOrderVo = orderTemplate.createTempOrder(requestNew);
            BaseResponse stockRes = null;
            try {
                boolean stockFlag = true;
                for (TempSubOrderVo subOrder : tempOrderVo.getSubOrders()) {
                    stockRes = orderTemplate.validateStock(subOrder, tempOrderVo.getAreaCode(), tempOrderVo.getRealOrganizationId());
                    if (stockRes.isSuccess()) {
                        stockFlag = stockFlag && ((OrderStock)stockRes.getResult()).getHasNoStock() == false;
                        continue;
                    }
                    throw new TempOrderCreateException(stockRes.getResultMessage() + "\uff0c\u9519\u8bef\u4ee3\u7801" + stockRes.getResultCode(), Contants.TEMPORDER_CREATE_ERROR.AREA_CODE_ILLEGAL);
                }
                if (!stockFlag) {
                    throw new TempOrderCreateException(Contants.TEMPORDER_CREATE_ERROR.INCLUED_NO_STOCK);
                }
            }
            catch (IllegalAreaCodeException e1) {
                throw new TempOrderCreateException(e1.getMessage(), Contants.TEMPORDER_CREATE_ERROR.AREA_CODE_ILLEGAL);
            }
            this.orgSalesPriceOperator.updateTempOrder(tempOrderVo);
            BaseResponse orderFreightResp = orderTemplate.getFreight(tempOrderVo);
            if (orderFreightResp.isSuccess()) {
                tempOrderVo.setSumShippingFee(((OrderFreight)orderFreightResp.getResult()).getBaseFreight());
                if (!Lang.isEmpty((Object)((OrderFreight)orderFreightResp.getResult()).getSubOrderFreights())) {
                    ((OrderFreight)orderFreightResp.getResult()).getSubOrderFreights().forEach(it -> tempOrderVo.getSubOrders().stream().filter(so -> so.getTmpOrderNo().equals(it.getOrderNo())).findFirst().ifPresent(tempSubOrderVo -> tempSubOrderVo.setSumShippingFee(it.getBaseFreight())));
                }
            } else {
                throw new TempOrderCreateException(orderFreightResp.getResultMessage(), Contants.TEMPORDER_CREATE_ERROR.FALID_ON_QUERYING_FERIGHT);
            }
            orderTemplate.marketingDone(tempOrderVo);
            tempOrderVo.setNeedPayPrice(tempOrderVo.getSumPrice().add(tempOrderVo.getSumShippingFee()));
            tempOrderVos.add(tempOrderVo);
        }
        if (tempOrderVos != null && !tempOrderVos.isEmpty()) {
            createdTempOrder = tempOrderVos.size() > 1 ? this.tempOrderHelper.combime(tempOrderVos) : (TempOrderVo)tempOrderVos.get(0);
        }
        return createdTempOrder;
    }

    public OrderStock tempOrderStock(TempOrderVo tempOrderVo) throws IllegalAreaCodeException {
        return this.orderStockOperator.get(tempOrderVo);
    }

    public OrderPrice tempOrderPrice(TempOrderVo tempOrderVo) throws IllegalAreaCodeException {
        this.orderFreightOperator.update(tempOrderVo);
        return this.orderPriceOperator.get(tempOrderVo);
    }

    public OrderVo submit(TempOrderVo tempOrder) throws OrderCreateException {
        List tempSubOrders = TempOrderHelper.flatSubOrders((TempOrderVo)tempOrder);
        OrderTemplateFactory factory = this.orderTemplateFactoryUtil.getOrderTemplateFactory();
        ArrayList<OrderVo> createdOrders = new ArrayList<OrderVo>();
        for (TempSubOrderVo s : tempSubOrders) {
            OrderTemplateConfigKey configKey = new OrderTemplateConfigKey();
            configKey.setGoodsType(s.getGoodsType());
            configKey.setOrderMode(s.getOrderMode());
            configKey.setOrgCode(Lang.isEmpty((Object)s.getOrgCode()) ? tempOrder.getOrganizationCode() : s.getOrgCode());
            OrderTemplate template = factory.getOrderTemplate(configKey);
            BaseResponse preCheckRs = template.orderPreCheck(tempOrder);
            if (!preCheckRs.isSuccess() || !((Boolean)preCheckRs.getResult()).booleanValue()) {
                throw new OrderCreateException(preCheckRs.getResultMessage(), Contants.ORDER_CREATE_ERROR.FAILD_ON_ORDER_PRECHECK);
            }
            try {
                BigDecimal orginNeedPayPrice = tempOrder.getNeedPayPrice();
                OrderPrice orderPrice = this.orderPriceOperator.get(tempOrder);
                TempOrderHelper.updateTempOrderPrices((TempOrderVo)tempOrder, (OrderPrice)orderPrice);
                BaseResponse marketingRs = template.marketingDone(tempOrder);
                if (!marketingRs.isSuccess()) {
                    throw new OrderCreateException(marketingRs.getResultMessage(), Contants.ORDER_CREATE_ERROR.FAILD_ON_MARKETING_PROCESSING);
                }
                if (!((Boolean)marketingRs.getResult()).booleanValue()) {
                    throw new OrderCreateException(Contants.ORDER_CREATE_ERROR.FAILD_ON_MARKETING_PROCESSING);
                }
                BaseResponse orderFreightRs = template.getFreight(tempOrder);
                if (!orderFreightRs.isSuccess()) {
                    throw new OrderCreateException(orderFreightRs.getResultMessage(), Contants.ORDER_CREATE_ERROR.FAILD_ON_ORDER_FREIGHT);
                }
                tempOrder.setSumShippingFee(((OrderFreight)orderFreightRs.getResult()).getBaseFreight());
                if (orginNeedPayPrice.subtract(tempOrder.getNeedPayPrice()).abs().compareTo(BigDecimal.ZERO) > 0) {
                    OrderCreateException e = new OrderCreateException(Contants.ORDER_CREATE_ERROR.ORDER_PRICE_REFRESHED);
                    e.setData(tempOrder);
                    throw e;
                }
                CreateOrderRequest createOrderRequest = (CreateOrderRequest)BeanMapper.map((Object)tempOrder, (Type)BeanMapper.getType(TempOrderVo.class), (Type)BeanMapper.getType(CreateOrderRequest.class));
                createOrderRequest.setSubOrder(s);
                createOrderRequest.setPaymentCode(tempOrder.getPayMethodCode());
                OrderVo orderVo = null;
                try {
                    orderVo = template.createOrder(createOrderRequest);
                    createdOrders.add(orderVo);
                    OrderMain order = this.orderMainQueryService.findByKey(new OrderKey(orderVo.getOrderId(), orderVo.getOrderNo()));
                    if (order == null) continue;
                    this.orderHelper.publishOrderEvent((OrderEvent)new OrderCreateEvent((Object)order, orderVo.getOrganizationCode(), Contants.ORDER_OPERATOR_SYSTEM));
                }
                catch (NoStockException e) {
                    throw new OrderCreateException(Contants.ORDER_CREATE_ERROR.INCLUED_NO_STOCK);
                }
            }
            catch (IllegalAreaCodeException e) {
                throw new OrderCreateException(Contants.ORDER_CREATE_ERROR.AREA_CODE_ILLEGAL, (Throwable)e);
            }
        }
        List orderVoList = createdOrders.stream().filter(it -> it != null).collect(Collectors.toList());
        OrderVo pOrder = null;
        if (orderVoList.size() > 1) {
            pOrder = (OrderVo)BeanMapper.map(orderVoList.get(0), OrderVo.class);
            pOrder.setOrderItems(orderVoList.stream().flatMap(o -> o.getOrderItems().stream()).collect(Collectors.toList()));
            pOrder.setSubOrders(orderVoList);
            pOrder.setOrderId(null);
            pOrder.setOrderNo(this.orderHelper.generateOrderNo());
            pOrder.setFreight(orderVoList.stream().map(OrderVo::getFreight).reduce(BigDecimal.ZERO, BigDecimal::add));
            pOrder.setSumNofreightPrice(orderVoList.stream().map(OrderVo::getSumNofreightPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            pOrder.setSumPrice(pOrder.getSumNofreightPrice().add(pOrder.getFreight()));
        } else {
            pOrder = (OrderVo)orderVoList.get(0);
            pOrder.setSubOrders(orderVoList);
        }
        pOrder.setTempOrderNo(tempOrder.getTmpOrderNo());
        return pOrder;
    }

    public List<OrderVo> refresh(List<OrderKey> orderKeys) {
        assert (orderKeys != null && orderKeys.size() > 0) : "\u53c2\u6570orderKeys\u4e0d\u80fd\u4e3a\u7a7a";
        if (orderKeys == null || orderKeys.size() <= 0) {
            return null;
        }
        if (orderKeys.stream().filter(i -> Lang.isEmpty((Object)i.getOrderNo()) || Lang.isEmpty((Object)i.getOrderId())).count() <= 0L) {
            return null;
        }
        orderKeys.stream().filter(i -> Lang.isEmpty((Object)i.getOrderNo())).forEach(i -> i.setOrderNo(this.orderRepos.findOrderNoById(i.getOrderId())));
        OrderTemplateFactory factory = this.orderTemplateFactoryUtil.getOrderTemplateFactory();
        ArrayList<OrderVo> r = new ArrayList<OrderVo>();
        List orderMains = this.orderMainQueryService.findByKey(orderKeys);
        if (orderMains != null) {
            Map<String, List<OrderMain>> groupedOrderVo = orderMains.stream().collect(Collectors.groupingBy(o -> Joiner.on((String)"_").join((Object[])new String[]{o.getOrderMode(), o.getGoodsType(), o.getRealOrganizationId()})));
            groupedOrderVo.entrySet().forEach(stringListEntry -> {
                List orderVoList = (List)stringListEntry.getValue();
                List orderKeyList = orderVoList.stream().map(i -> new OrderKey(i.getId(), i.getOrderNo())).collect(Collectors.toList());
                if (orderVoList.size() > 0) {
                    OrderMain so = (OrderMain)orderVoList.get(0);
                    OrderTemplateConfigKey configKey = new OrderTemplateConfigKey();
                    configKey.setOrderMode("1");
                    configKey.setGoodsType(so.getGoodsType());
                    configKey.setOrgCode(this.organizationApi.findOrganizationCodeById(so.getRealOrganizationId()));
                    OrderTemplate template = factory.getOrderTemplate(configKey);
                    template.refresh(orderKeyList);
                }
            });
        }
        for (OrderMain it : orderMains) {
            this.orderHelper.publishOrderStatusChangeEvent(new OrderKey(it.getId(), it.getOrderNo()), null);
        }
        return r;
    }

    public OrderAuditingResult audit(OrderKey orderKey, Boolean passed, Boolean cancelSupplierOrder) {
        List r = this.audit((List)new /* Unavailable Anonymous Inner Class!! */, passed, cancelSupplierOrder);
        return r == null && r.size() <= 0 ? null : (OrderAuditingResult)r.get(0);
    }

    public List<OrderAuditingResult> audit(List<OrderKey> orderKeys, Boolean passed, Boolean cancelSupplierOrder) {
        assert (orderKeys != null && orderKeys.size() > 0) : "\u53c2\u6570orderKeys\u4e0d\u80fd\u4e3a\u7a7a";
        assert (passed != null) : "\u53c2\u6570passed\u4e0d\u80fd\u4e3a\u7a7a";
        if (passed == null) {
            return null;
        }
        if (orderKeys == null || orderKeys.size() <= 0) {
            return null;
        }
        if (orderKeys.stream().filter(i -> !Lang.isEmpty((Object)i.getOrderNo()) || !Lang.isEmpty((Object)i.getOrderId())).count() <= 0L) {
            return null;
        }
        orderKeys.stream().filter(i -> Lang.isEmpty((Object)i.getOrderNo())).forEach(i -> i.setOrderNo(this.orderMainQueryService.findOrderNoById(i.getOrderId())));
        OrderTemplateFactory factory = this.orderTemplateFactoryUtil.getOrderTemplateFactory();
        ArrayList<OrderAuditingResult> r = new ArrayList<OrderAuditingResult>();
        List orderMains = this.orderMainQueryService.findByKey(orderKeys);
        if (orderMains != null) {
            Map<String, List<OrderMain>> groupedOrderVo = orderMains.stream().collect(Collectors.groupingBy(o -> Joiner.on((String)"_").join((Object[])new String[]{o.getOrderMode(), o.getGoodsType(), o.getRealOrganizationId()})));
            groupedOrderVo.entrySet().forEach(stringListEntry -> {
                List orderVoList = (List)stringListEntry.getValue();
                if (orderVoList.size() > 0) {
                    OrderMain so = (OrderMain)orderVoList.get(0);
                    OrderTemplateConfigKey configKey = new OrderTemplateConfigKey();
                    configKey.setOrderMode("1");
                    configKey.setGoodsType(so.getGoodsType());
                    configKey.setOrgCode(this.organizationApi.findOrganizationCodeById(so.getRealOrganizationId()));
                    OrderTemplate template = factory.getOrderTemplate(configKey);
                    List auditKeys = orderVoList.stream().map(orderMain -> new OrderKey(orderMain.getId(), orderMain.getOrderNo())).collect(Collectors.toList());
                    List responseList = template.audit(auditKeys, passed);
                    List<OrderKey> sucList = responseList.stream().filter(OrderAuditingResult::getSuccess).map(OrderAuditingResult::getOrderKey).collect(Collectors.toList());
                    if (sucList != null && sucList.size() > 0) {
                        sucList.forEach(sucKey -> {
                            Optional<OrderMain> optOrderMain = orderMains.stream().filter(om -> om.getId().equals(sucKey.getOrderId()) || om.getOrderNo().equals(sucKey.getOrderNo())).findFirst();
                            if (optOrderMain.isPresent()) {
                                Payment payment = this.paymentService.findByid(optOrderMain.get().getPaymentId());
                                MemberAddressDto memberAddressDto = this.memberAddressApi.findById(optOrderMain.get().getAddressId());
                                BaseResponse subsucribeRs = template.subscribeOrder(this.orderMainService.toOrderVo(optOrderMain.get(), payment, memberAddressDto));
                                if (!subsucribeRs.isSuccess()) {
                                    responseList.stream().filter(r2 -> r2.getOrderKey().equals(sucKey)).findFirst().ifPresent(r2 -> {
                                        r2.setSuccess(Boolean.valueOf(false));
                                        r2.setMessage(subsucribeRs.getResultMessage());
                                        r2.setErrorCode(Contants.ORDER_AUDITING_ERROR.SUPPLIER_TACK_ORDER_ERROR.getValue());
                                    });
                                    ArrayList<OrderKey> cancelKeys = new ArrayList<OrderKey>();
                                    cancelKeys.add((OrderKey)sucKey);
                                    template.cancelOrder(cancelKeys, Contants.CancelOrderType.ERROR);
                                }
                            } else {
                                responseList.stream().filter(r2 -> r2.getOrderKey().equals(sucKey)).findFirst().ifPresent(r2 -> {
                                    r2.setSuccess(Boolean.valueOf(false));
                                    r2.setMessage(Contants.ORDER_AUDITING_ERROR.ORDERMAIN_NOT_FOUND.getMessage());
                                    r2.setErrorCode(Contants.ORDER_AUDITING_ERROR.ORDERMAIN_NOT_FOUND.getValue());
                                });
                            }
                        });
                    }
                    r.addAll(responseList);
                    if (!passed.booleanValue() && cancelSupplierOrder.booleanValue()) {
                        template.cancelOrder(auditKeys, Contants.CancelOrderType.ERROR);
                    }
                }
            });
        }
        return r;
    }

    public void prePayDone(OrderKey orderKey, CusPayInfo cusPayInfo) {
        OrderMain orderMain = this.orderMainQueryService.findByKey(orderKey);
        OrderTemplateFactory factory = this.orderTemplateFactoryUtil.getOrderTemplateFactory();
        OrderTemplateConfigKey configKey = new OrderTemplateConfigKey();
        configKey.setOrderMode(Lang.isEmpty((Object)orderMain.getOrderMode()) ? "1" : orderMain.getOrderMode());
        configKey.setGoodsType(orderMain.getGoodsType());
        configKey.setOrgCode(this.organizationApi.findOrganizationCodeById(orderMain.getRealOrganizationId()));
        Payment payment = this.paymentService.findByid(orderMain.getPaymentId());
        MemberAddressDto memberAddressDto = this.memberAddressApi.findById(orderMain.getAddressId());
        factory.getOrderTemplate(configKey).orderPayPreSubmitDone(this.orderMainService.toOrderVo(orderMain, payment, memberAddressDto));
    }

    public OrderPayConfirmResp payComfirmed(OrderKey orderKey) {
        OrderMain orderMain = this.orderMainQueryService.findByKey(orderKey);
        OrderTemplateFactory factory = this.orderTemplateFactoryUtil.getOrderTemplateFactory();
        OrderTemplateConfigKey configKey = new OrderTemplateConfigKey();
        configKey.setOrderMode(Lang.isEmpty((Object)orderMain.getOrderMode()) ? "1" : orderMain.getOrderMode());
        configKey.setGoodsType(orderMain.getGoodsType());
        configKey.setOrgCode(this.organizationApi.findOrganizationCodeById(orderMain.getRealOrganizationId()));
        Payment payment = this.paymentService.findByid(orderMain.getPaymentId());
        MemberAddressDto memberAddressDto = this.memberAddressApi.findById(orderMain.getAddressId());
        OrderPayConfirmResp r = null;
        try {
            OrderTemplate template = factory.getOrderTemplate(configKey);
            r = template.paySubmit(this.orderMainService.toOrderVo(orderMain, payment, memberAddressDto));
        }
        catch (SupplierInterfaceInvokeException e) {
            r.setSuccess(Boolean.valueOf(false));
            switch (2.$SwitchMap$outsideapi$exceptions$SupplierInterfaceInvokeException$ERROR_CODES[e.getErrorCode().ordinal()]) {
                default: 
            }
            r.setErrorCode(Contants.ORDER_PAY_CONFIRM_ERROR.SUPPLIER_INTERFACE_ERROR);
            e.printStackTrace();
        }
        catch (SupplierOrderComfirmFalidException e) {
            r.setSuccess(Boolean.valueOf(false));
            switch (2.$SwitchMap$outsideapi$exceptions$SupplierOrderComfirmFalidException$ERROR_CODES[e.getErrorCode().ordinal()]) {
                case 1: {
                    r.setErrorCode(Contants.ORDER_PAY_CONFIRM_ERROR.ORDER_CANCELED);
                    break;
                }
                case 2: {
                    r.setErrorCode(Contants.ORDER_PAY_CONFIRM_ERROR.ACCOUNT_BALANCE_ERROR);
                    break;
                }
                case 3: {
                    r.setErrorCode(Contants.ORDER_PAY_CONFIRM_ERROR.ALREADY_COMFIRMED_ORDER);
                    break;
                }
                default: {
                    r.setErrorCode(Contants.ORDER_PAY_CONFIRM_ERROR.SUPPLIER_COMFIRMED_ERROR);
                    r.setMessage(e.getMessage());
                }
            }
            e.printStackTrace();
        }
        catch (Exception e) {
            r.setSuccess(Boolean.valueOf(false));
            r.setErrorCode(Contants.ORDER_PAY_CONFIRM_ERROR.SUPPLIER_COMFIRMED_ERROR);
            r.setMessage(e.getMessage());
            e.printStackTrace();
        }
        return r;
    }

    public CancelOrderResp cancel(List<OrderKey> orderKeys, Contants.CancelOrderType cancelType) {
        AtomicLong faildCount = new AtomicLong();
        AtomicLong sucCount = new AtomicLong();
        ArrayList cancelOrderDetailResps = new ArrayList();
        OrderTemplateFactory factory = this.orderTemplateFactoryUtil.getOrderTemplateFactory();
        List orderMains = this.orderMainQueryService.findByKey(orderKeys);
        if (orderMains != null) {
            Map<String, List<OrderMain>> groupedOrderVo = orderMains.stream().collect(Collectors.groupingBy(o -> Joiner.on((String)"_").join((Object[])new String[]{o.getOrderMode(), o.getGoodsType(), o.getRealOrganizationId()})));
            groupedOrderVo.entrySet().forEach(stringListEntry -> {
                List orderVoList = (List)stringListEntry.getValue();
                if (orderVoList.size() > 0) {
                    OrderMain so = (OrderMain)orderVoList.get(0);
                    OrderTemplateConfigKey configKey = new OrderTemplateConfigKey();
                    configKey.setOrderMode("1");
                    configKey.setGoodsType(so.getGoodsType());
                    configKey.setOrgCode(this.organizationApi.findOrganizationCodeById(so.getRealOrganizationId()));
                    OrderTemplate template = factory.getOrderTemplate(configKey);
                    List cancelKeys = orderVoList.stream().map(orderMain -> {
                        OrderKey key = new OrderKey();
                        key.setOrderId(orderMain.getId());
                        return key;
                    }).collect(Collectors.toList());
                    BaseResponse response = template.cancelOrder(cancelKeys, cancelType);
                    cancelOrderDetailResps.addAll(((CancelOrderResp)response.getResult()).getDetails());
                    faildCount.addAndGet(((CancelOrderResp)response.getResult()).getFailureCounts());
                    sucCount.addAndGet(((CancelOrderResp)response.getResult()).getSuccessCounts());
                }
            });
        }
        CancelOrderResp cancelOrderResp = new CancelOrderResp();
        cancelOrderResp.setDetails(cancelOrderDetailResps);
        cancelOrderResp.setSuccessCounts(Long.valueOf(sucCount.get()));
        cancelOrderResp.setFailureCounts(Long.valueOf(faildCount.get()));
        List canceledOrderNos = cancelOrderDetailResps.stream().filter(i -> i.getSuccessed()).map(CancelOrderDetailResp::getOrderNo).collect(Collectors.toList());
        List canceledOrderMain = this.orderMainQueryService.findByOrderNos(canceledOrderNos);
        for (String orderNo : canceledOrderNos) {
            canceledOrderMain.stream().filter(i -> orderNo.equals(i.getOrderNo())).findFirst().ifPresent(orderMain -> this.orderHelper.publishOrderEvent((OrderEvent)new OrderStatusChangeEvent(orderMain, this.organizationApi.findOrganizationCodeById(orderMain.getOrganizationId()), cancelType.equals((Object)Contants.CancelOrderType.USER) ? orderMain.getMemberId() : Contants.ORDER_OPERATOR_SYSTEM)));
        }
        return cancelOrderResp;
    }

    public void receipt(OrderKey orderKey, String receiptType) {
        OrderMain orderMain = this.orderMainQueryService.findByKey(orderKey);
        String oldStatus = orderMain.getStatus();
        OrderTemplateFactory factory = this.orderTemplateFactoryUtil.getOrderTemplateFactory();
        OrderTemplateConfigKey configKey = new OrderTemplateConfigKey();
        configKey.setOrderMode(Lang.isEmpty((Object)orderMain.getOrderMode()) ? "1" : orderMain.getOrderMode());
        configKey.setGoodsType(orderMain.getGoodsType());
        configKey.setOrgCode(this.organizationApi.findOrganizationCodeById(orderMain.getRealOrganizationId()));
        OrderTemplate template = factory.getOrderTemplate(configKey);
        if (template != null) {
            template.orderReceipt(orderKey, receiptType);
        }
        if (!oldStatus.equals((orderMain = this.orderMainQueryService.findByKey(orderKey)).getStatus()) && (orderMain.getStatus().equals(GlobalContants.ORDER_STATUS.EVALUATE.getValue()) || orderMain.getStatus().equals(GlobalContants.ORDER_STATUS.FINISH.getValue()))) {
            String orgCode = this.organizationApi.findOrganizationCodeById(orderMain.getOrganizationId());
            this.orderHelper.publishOrderEvent((OrderEvent)new OrderShippingComfirmedEvent((Object)orderMain, orgCode, Contants.ORDER_OPERATOR_SYSTEM));
        }
    }

    public void statusChange(OrderStatus orderStatus) {
        OrderMain orderMain = this.orderMainQueryService.findByKey(new OrderKey(orderStatus.getOrderId(), orderStatus.getOrderNo()));
        if (orderMain != null) {
            String oldStatus = orderMain.getStatus();
            if (!Lang.isEmpty((Object)orderStatus.getOrderId())) {
                this.orderRepos.updateStatusById(orderStatus.getStatus().getValue(), orderStatus.getOrderId());
            } else if (!Lang.isEmpty((Object)orderStatus.getOrderNo())) {
                this.orderRepos.updateStatusByOrderNo(orderStatus.getStatus().getValue(), orderStatus.getOrderNo());
            }
            if (!oldStatus.equals(orderStatus.getStatus().getValue())) {
                String orgCode = this.organizationApi.findOrganizationCodeById(orderMain.getOrganizationId());
                this.orderHelper.publishOrderEvent((OrderEvent)new OrderStatusChangeEvent((Object)orderMain, orgCode, Contants.ORDER_OPERATOR_SYSTEM));
            }
        }
    }
}

