/*
 * Decompiled with CFR 0.152.
 */
package order.service.service.impl;

import java.io.Serializable;
import java.util.List;
import order.dto.MallTempOrderDto;
import order.model.po.MallTempOrder;
import order.model.repository.MallTempOrderRepo;
import order.service.service.MallTempOrderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

@Service
public class MallTempOrderServiceImpl
implements MallTempOrderService {
    private static final Logger log = LoggerFactory.getLogger(MallTempOrderServiceImpl.class);
    @Autowired
    private MallTempOrderRepo mallTempOrderRepo;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse saveMallTempOrder(MallTempOrderDto mallTempOrderDto) {
        MallTempOrder mallTempOrderOld;
        if (!Lang.isEmpty((Object)mallTempOrderDto.getId()) && !Lang.isEmpty((Object)(mallTempOrderOld = (MallTempOrder)this.mallTempOrderRepo.findOne((Serializable)((Object)mallTempOrderDto.getId()))))) {
            this.mallTempOrderRepo.delete((Object)mallTempOrderOld);
        }
        MallTempOrder mallTempOrder = (MallTempOrder)BeanMapper.map((Object)mallTempOrderDto, MallTempOrder.class);
        mallTempOrder.getMallTempGoods().forEach(tempGoods -> tempGoods.setMallTempOrder(mallTempOrder));
        this.mallTempOrderRepo.save((Object)mallTempOrder);
        return new BaseResponse(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse deleteMallTempOrder(List<String> ids) {
        if (ids.size() == 1000) {
            List<String> subList = ids.subList(0, ids.size() / 2 - 1);
            List<String> subList2 = ids.subList(subList.size(), ids.size());
            this.mallTempOrderRepo.deleteByIdIn(subList);
            this.mallTempOrderRepo.deleteByIdIn(subList2);
        } else {
            this.mallTempOrderRepo.deleteByIdIn(ids);
        }
        return new BaseResponse(true, "\u5220\u9664\u4e34\u65f6\u8ba2\u5355\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse deleteMallTempOrder(String memberId) {
        this.mallTempOrderRepo.deleteAllByMemberId(memberId);
        return new BaseResponse(true, "\u5220\u9664\u4e34\u65f6\u8ba2\u5355\u6210\u529f");
    }

    public BaseResponse updateTempOrder(String addressId, String memberId, String errorInfo) {
        this.mallTempOrderRepo.updateTempOrder(errorInfo, addressId, memberId);
        return null;
    }
}

