/*
 * Decompiled with CFR 0.152.
 */
package order.service.service.impl;

import cart.api.OrderMainApi;
import cart.api.TrdSpOrderStatusApi;
import cart.api.difinication.Business;
import cart.api.difinication.Organization;
import cart.api.difinication.TrdSpOrderOperation;
import cart.api.difinication.TrdSpOrderStatus;
import cart.api.dto.mallStatus.MallStatusMachineDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import order.model.po.OrderItem;
import order.model.po.OrderMain;
import order.model.po.SubOrder;
import order.model.po.SubOrderItem;
import order.model.repository.OrderRepos;
import order.model.repository.SubOrderRepos;
import order.service.service.StoreOrderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import utils.Lang;

@Service
public class StoreOrderServiceImpl
implements StoreOrderService {
    @Autowired
    RedisTemplate redisTemplate;
    @MotanReferer
    TrdSpOrderStatusApi trdSpOrderStatusApi;
    @Autowired
    OrderRepos orderRepos;
    @Autowired
    SubOrderRepos subOrderRepos;
    @MotanReferer
    OrderMainApi orderMainApi;
    static final Logger logger = LoggerFactory.getLogger(StoreOrderService.class);

    public void cancleOrder(String thirdOrderNo, String StoreId, String orderId) {
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)("LocalCancelOrder:thirdOrderNo" + thirdOrderNo + '4'));
        if (boundValueOperations.setIfAbsent((Object)true).booleanValue()) {
            int i;
            boundValueOperations.expire(1L, TimeUnit.MILLISECONDS);
            MallStatusMachineDto mallStatusMachineDto = this.trdSpOrderStatusApi.findNextTrdOrderStatus(Business.Order, Organization.TrdSp, TrdSpOrderOperation.Cancel, TrdSpOrderStatus.Obligation);
            if (Lang.isEmpty((Object)mallStatusMachineDto.getNextStatusCode())) {
                logger.info("statusCode:{}", (Object)JSON.toJSONString((Object)mallStatusMachineDto.getNextStatusCode()));
            } else {
                i = this.orderRepos.updateTrdSpStatus(mallStatusMachineDto.getNextStatusCode(), thirdOrderNo, StoreId);
                if (i <= 0) {
                    logger.info("\u53d6\u6d88\u8ba2\u5355\u5931\u8d25");
                }
            }
            i = this.subOrderRepos.updateSubOrderState(orderId, mallStatusMachineDto.getNextStatusCode());
            if (i <= 0) {
                logger.info("\u53d6\u6d88\u8ba2\u5355\u65f6\u5019,\u66f4\u65b0SubOrder\u72b6\u6001\u5931\u8d25");
            }
        }
    }

    public void confimOrder(String thirdOrderNo, String StoreId, String orderId) {
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)("LocalConfirmOrder:thirdOrderNo" + thirdOrderNo));
        if (boundValueOperations.setIfAbsent((Object)true).booleanValue()) {
            int i;
            boundValueOperations.expire(1L, TimeUnit.MILLISECONDS);
            MallStatusMachineDto mallStatusMachineDto = this.trdSpOrderStatusApi.findNextTrdOrderStatus(Business.Order, Organization.TrdSp, TrdSpOrderOperation.Firm, TrdSpOrderStatus.Obligation);
            if (Lang.isEmpty((Object)mallStatusMachineDto.getNextStatusCode())) {
                logger.info("statusCode:{}", (Object)JSON.toJSONString((Object)mallStatusMachineDto.getNextStatusCode()));
            } else {
                i = this.orderRepos.updateTrdSpStatus(mallStatusMachineDto.getNextStatusCode(), thirdOrderNo, StoreId);
                if (i <= 0) {
                    logger.info("\u786e\u8ba4\u8ba2\u5355\u5931\u8d25");
                }
            }
            i = this.subOrderRepos.updateSubOrderState(orderId, mallStatusMachineDto.getNextStatusCode());
            if (i <= 0) {
                logger.info("\u786e\u8ba4\u9884\u5360\u5e93\u5b58\u65f6\u5019,\u66f4\u65b0SubOrder\u72b6\u6001\u5931\u8d25");
            }
        }
    }

    public void takeOrder(String orderNo, String StoreId) {
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)("LocalTakeOrder:thirdOrderNo" + orderNo));
        if (boundValueOperations.setIfAbsent((Object)true).booleanValue()) {
            boundValueOperations.expire(1L, TimeUnit.MILLISECONDS);
            MallStatusMachineDto mallStatusMachineDto = this.trdSpOrderStatusApi.findNextTrdOrderStatus(Business.Order, Organization.TrdSp, TrdSpOrderOperation.TrdSpNewOperation, TrdSpOrderStatus.TrdSpNew);
            if (Lang.isEmpty((Object)mallStatusMachineDto.getNextStatusCode())) {
                logger.info("statusCode:{}", (Object)JSON.toJSONString((Object)mallStatusMachineDto.getNextStatusCode()));
            } else {
                int i = this.orderRepos.updateTrdSpStatusByOrderNo(mallStatusMachineDto.getNextStatusCode(), orderNo, StoreId);
                if (i <= 0) {
                    logger.info("\u8ba2\u5355\u53f7" + orderNo + "\u9884\u5360\u5e93\u5b58\u5931\u8d25");
                }
            }
        }
    }

    public void addSubOrder(String orderNo) {
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)("addSubOrder:subOrderNo" + orderNo));
        if (boundValueOperations.setIfAbsent((Object)true).booleanValue()) {
            boundValueOperations.expire(1L, TimeUnit.MILLISECONDS);
            OrderMain orderMain = this.orderRepos.findByOrderNo(orderNo);
            SubOrder subOrder = new SubOrder();
            ArrayList<SubOrderItem> list = new ArrayList<SubOrderItem>();
            subOrder.setSubOrderNo(orderMain.getThirdOrderNo());
            subOrder.setTrdOrderState(orderMain.getTrdSpStatus());
            subOrder.setFreight(orderMain.getFreight());
            subOrder.setJdstatus(orderMain.getJdstatus());
            subOrder.setSumCostPrice(orderMain.getSumPrice());
            subOrder.setOrder(orderMain);
            for (OrderItem o : orderMain.getOrderItems()) {
                SubOrderItem subOrderItem = new SubOrderItem();
                subOrderItem.setCount(o.getCount());
                subOrderItem.setName(o.getProductName());
                subOrderItem.setPrice(o.getCostPrice());
                subOrderItem.setSkuId(o.getSku());
                subOrderItem.setSubOrder(subOrder);
                subOrderItem.setOrder(orderMain);
                subOrderItem.setOrderItem(o);
                if (o.getProductType() != null) {
                    subOrderItem.setType(Integer.valueOf(o.getProductType()));
                }
                list.add(subOrderItem);
            }
            subOrder.setSubOrderItems(list);
            this.subOrderRepos.save((Object)subOrder);
        }
    }
}

